/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.util;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.util.ProcessElementFactory;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.setting.SettingUtil;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.core.model.item.process.FinalNodeImpl;
import org.openbp.core.model.item.process.InitialNodeImpl;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.SingleSocketNode;

public class ModelerUtil {
    private ModelerUtil() {
    }

    public static void preventOverlap(ProcessDrawing drawing, Figure figure) {
        ModelerUtil.preventOverlap(drawing, figure, new Point(0, 0));
    }

    private static void preventOverlap(ProcessDrawing drawing, Figure figure, Point offset) {
        Point pos = new Point(figure.center());
        pos.x += offset.x;
        pos.y += offset.y;
        FigureEnumeration fe = drawing.figures();
        while (fe.hasMoreElements()) {
            Point fPos;
            Figure f = fe.nextFigure();
            if (f == figure || f.getClass() != figure.getClass() || !(fPos = f.center()).equals(pos)) continue;
            offset.x += 50;
            offset.y += 50;
            ModelerUtil.preventOverlap(drawing, figure, offset);
            return;
        }
        figure.moveBy(offset.x, offset.y);
    }

    public static NodeFigure createInitialNodeFromSocket(SocketFigure patternSocketFigure) {
        InitialNodeImpl node = ProcessElementFactory.getInstance().createStandardInitialNode();
        return ModelerUtil.createNodeFromSocket((SingleSocketNode)node, patternSocketFigure, 100);
    }

    public static NodeFigure createFinalNodeFromSocket(SocketFigure patternSocketFigure) {
        FinalNodeImpl node = ProcessElementFactory.getInstance().createStandardFinalNode();
        return ModelerUtil.createNodeFromSocket((SingleSocketNode)node, patternSocketFigure, 200);
    }

    private static NodeFigure createNodeFromSocket(SingleSocketNode node, SocketFigure patternSocketFigure, int offset) {
        ProcessDrawing drawing = patternSocketFigure.getDrawing();
        NodeSocket patternSocket = patternSocketFigure.getNodeSocket();
        ModelerUtil.copySocketPropertiesToNode(node, patternSocket);
        patternSocket.getProcess().addNode((Node)node);
        NodeFigure nodeFigure = drawing.createNodeFigure((Node)node);
        ModelerUtil.positionNode(nodeFigure, patternSocketFigure, offset);
        drawing.add(nodeFigure);
        return nodeFigure;
    }

    private static void positionNode(NodeFigure nodeFigure, SocketFigure socketFigure, int offset) {
        Rectangle socketBox = socketFigure.displayBox();
        Rectangle nodeBox = nodeFigure.compactDisplayBox();
        double angle = socketFigure.getAngle();
        Point nodeCenter = new Point(0, socketBox.y + socketBox.height / 2);
        nodeCenter.x = angle >= 1.5707963267948966 && angle < 4.71238898038469 ? socketBox.x - offset - nodeBox.width / 2 : socketBox.x + offset + nodeBox.width / 2;
        if (nodeCenter.x - nodeBox.width / 2 - 10 < 0) {
            nodeCenter.x = nodeBox.width / 2 + 10;
        }
        if (nodeCenter.y - nodeBox.height / 2 - 10 < 0) {
            nodeCenter.y = nodeBox.height / 2 + 10;
        }
        nodeFigure.displayBox(nodeCenter, nodeCenter);
        ModelerUtil.preventOverlap(socketFigure.getDrawing(), nodeFigure);
    }

    private static void copySocketPropertiesToNode(SingleSocketNode node, NodeSocket patternSocket) {
        ProcessItem process = patternSocket.getProcess();
        node.setName(patternSocket.getName());
        node.setDisplayName(patternSocket.getDisplayName());
        node.setDescription(patternSocket.getDescription());
        NamedObjectCollectionUtil.createUniqueName((DescriptionObject)node, (Collection)process.getNodeList());
        NodeSocket socket = node.getSocket();
        Iterator it = patternSocket.getParams();
        while (it.hasNext()) {
            NodeParam param = (NodeParam)it.next();
            try {
                param = (NodeParam)param.clone();
            }
            catch (CloneNotSupportedException e) {
                param = null;
            }
            if (param == null) continue;
            socket.addParam(param);
        }
    }

    public static List<String> getStringListFromSettings(String settingName) {
        ArrayList<String> classNames = new ArrayList<String>();
        String classNameList = SettingUtil.getStringSetting((String)"openbp.cockpit.modelObjectConfigurators");
        if (classNameList != null) {
            StringTokenizer st = new StringTokenizer(classNameList, " ,");
            while (st.hasMoreTokens()) {
                String className = st.nextToken();
                if (className.length() == 0) continue;
                classNames.add(className);
            }
        }
        return classNames;
    }
}

