/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.util;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import org.openbp.cockpit.modeler.figures.generic.ShadowDropper;
import org.openbp.cockpit.modeler.util.EmptyFigureEnumerator;
import org.openbp.cockpit.modeler.util.SingleFigureEnumerator;

public class ShadowEnumerator
implements FigureEnumeration {
    private FigureEnumeration enOuter;
    private FigureEnumeration enInner;
    private Figure nextElement;

    public static FigureEnumeration enumerate(Figure f) {
        Figure shadow;
        if (f instanceof CompositeFigure && ((CompositeFigure)f).figureCount() > 0) {
            return new ShadowEnumerator(f);
        }
        if (f instanceof ShadowDropper && (shadow = ((ShadowDropper)f).getShadow()) != null) {
            return new SingleFigureEnumerator(shadow);
        }
        return EmptyFigureEnumerator.getInstance();
    }

    private ShadowEnumerator(Figure figure) {
        this.enOuter = figure.figures();
        this.enInner = ShadowEnumerator.enumerate(this.enOuter.nextFigure());
        if (figure instanceof ShadowDropper) {
            this.nextElement = ((ShadowDropper)figure).getShadow();
            if (this.nextElement != null) {
                return;
            }
        }
        this.determineNext();
    }

    private void determineNext() {
        this.nextElement = null;
        if (this.enInner.hasMoreElements()) {
            this.nextElement = this.enInner.nextFigure();
        } else {
            while (this.enOuter.hasMoreElements() && !(this.enInner = ShadowEnumerator.enumerate(this.enOuter.nextFigure())).hasMoreElements()) {
            }
            if (this.enInner.hasMoreElements()) {
                this.nextElement = this.enInner.nextFigure();
            }
        }
    }

    public Object nextElement() {
        Figure f = this.nextElement;
        this.determineNext();
        return f;
    }

    public boolean hasMoreElements() {
        return this.nextElement != null;
    }

    public Figure nextFigure() {
        return (Figure)this.nextElement();
    }
}

