/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.debugger;

import java.util.ArrayList;
import org.openbp.cockpit.plugins.debugger.DebuggerPlugin;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.option.BooleanOption;
import org.openbp.jaspira.option.LocalizableOptionString;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.option.StringOption;
import org.openbp.jaspira.option.widget.SelectionWidget;
import org.openbp.jaspira.plugin.ExternalOptionModule;
import org.openbp.jaspira.plugin.Plugin;

public class DebuggerOptionModule
extends ExternalOptionModule {
    private static final String LINKTRACE_SKIP_STR = "skip";
    private static final String LINKTRACE_TARGET_STR = "target";
    private static final String LINKTRACE_ANIMATION_STOP_STR = "animationstop";
    private static final String LINKTRACE_ANIMATION_GO_STR = "animationgo";

    public DebuggerOptionModule(Plugin plugin) {
        super(plugin);
    }

    public abstract class LinkTraceOption
    extends Option {
        public LinkTraceOption(String name, Integer defaultValue) {
            super(DebuggerOptionModule.this.getPlugin().getPluginResourceCollection(), name, defaultValue);
        }

        @Override
        public OptionWidget createOptionWidget() {
            ArrayList<LocalizableOptionString> values = new ArrayList<LocalizableOptionString>(4);
            ResourceCollection res = DebuggerOptionModule.this.getPlugin().getPluginResourceCollection();
            values.add(new LocalizableOptionString(res.getRequiredString("debugger.option.linktrace.skip"), DebuggerPlugin.LINKTRACE_SKIP));
            values.add(new LocalizableOptionString(res.getRequiredString("debugger.option.linktrace.target"), DebuggerPlugin.LINKTRACE_TARGET));
            values.add(new LocalizableOptionString(res.getRequiredString("debugger.option.linktrace.animationstop"), DebuggerPlugin.LINKTRACE_ANIMATION_STOP));
            values.add(new LocalizableOptionString(res.getRequiredString("debugger.option.linktrace.animationgo"), DebuggerPlugin.LINKTRACE_ANIMATION_GO));
            return new SelectionWidget(this, values);
        }

        @Override
        public Object loadFromString(String str) {
            Integer value = DebuggerPlugin.LINKTRACE_ANIMATION_STOP;
            if (str.equals(DebuggerOptionModule.LINKTRACE_SKIP_STR)) {
                value = DebuggerPlugin.LINKTRACE_SKIP;
            } else if (str.equals(DebuggerOptionModule.LINKTRACE_TARGET_STR)) {
                value = DebuggerPlugin.LINKTRACE_TARGET;
            } else if (str.equals(DebuggerOptionModule.LINKTRACE_ANIMATION_STOP_STR)) {
                value = DebuggerPlugin.LINKTRACE_ANIMATION_STOP;
            } else if (str.equals(DebuggerOptionModule.LINKTRACE_ANIMATION_GO_STR)) {
                value = DebuggerPlugin.LINKTRACE_ANIMATION_GO;
            }
            return value;
        }

        @Override
        public String saveToString() {
            Object value = this.getValue();
            String str = DebuggerOptionModule.LINKTRACE_ANIMATION_STOP_STR;
            if (value == DebuggerPlugin.LINKTRACE_SKIP) {
                str = DebuggerOptionModule.LINKTRACE_SKIP_STR;
            } else if (value == DebuggerPlugin.LINKTRACE_TARGET) {
                str = DebuggerOptionModule.LINKTRACE_TARGET_STR;
            } else if (value == DebuggerPlugin.LINKTRACE_ANIMATION_STOP) {
                str = DebuggerOptionModule.LINKTRACE_ANIMATION_STOP_STR;
            } else if (value == DebuggerPlugin.LINKTRACE_ANIMATION_GO) {
                str = DebuggerOptionModule.LINKTRACE_ANIMATION_GO_STR;
            }
            return str;
        }
    }

    public class DebuggerIdOption
    extends StringOption {
        public DebuggerIdOption() {
            super(DebuggerOptionModule.this.getPlugin().getPluginResourceCollection(), "debugger.debuggerid", null);
        }
    }

    public class SkipSystemModelOption
    extends BooleanOption {
        public SkipSystemModelOption() {
            super(DebuggerOptionModule.this.getPlugin().getPluginResourceCollection(), "debugger.skipsystemmodel", Boolean.TRUE);
        }
    }

    public class AutosaveOption
    extends BooleanOption {
        public AutosaveOption() {
            super(DebuggerOptionModule.this.getPlugin().getPluginResourceCollection(), "debugger.autosave", Boolean.TRUE);
        }
    }
}

