/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.debugger;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.cockpit.plugins.debugger.DebuggerServerEvent;
import org.openbp.cockpit.plugins.debugger.InspectorNode;
import org.openbp.common.CommonUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.string.TextUtil;
import org.openbp.core.engine.debugger.DebuggerService;
import org.openbp.core.engine.debugger.ObjectMemberInfo;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.remote.ServerConnection;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.swing.components.treetable.DefaultTreeCellRenderer;
import org.openbp.swing.components.treetable.DefaultTreeTableModel;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.TreeTableModel;
import org.openbp.swing.components.treetable.TreeTableNode;

public class InspectorPlugin
extends AbstractVisiblePlugin
implements TreeExpansionListener,
TreeSelectionListener {
    private String debuggerId;
    private DefaultTreeTableModel treeModel;
    private JTreeTable treeTable;
    private static String[] tableHeader;
    private static String titleStatus;
    private Icon defaultIcon;
    private boolean debuggerListening;
    private List expandedNodeSpecList;
    private NodeSpec selectedNodeSpec;
    private boolean stateSaved;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.debugger";
    }

    @Override
    protected void initializeComponents() {
        this.expandedNodeSpecList = new ArrayList();
        this.defaultIcon = this.getIcon();
        this.treeModel = new DefaultTreeTableModel(null);
        ResourceCollection res = this.getPluginResourceCollection();
        if (tableHeader == null) {
            tableHeader = new String[]{res.getRequiredString("header.column1"), res.getRequiredString("header.column2"), res.getRequiredString("header.column3")};
            titleStatus = res.getRequiredString("titlestatus");
        }
        this.treeModel.setColumnHeader(tableHeader);
        this.treeTable = new JTreeTable((TreeTableModel)this.treeModel);
        this.treeTable.setDefaultRowHeight(24);
        this.treeTable.getTree().setCellRenderer((TreeCellRenderer)((Object)new InspectorTreeCellRenderer(this.treeTable)));
        this.treeTable.getTree().addTreeExpansionListener(this);
        this.treeTable.getTree().addTreeSelectionListener(this);
        this.treeTable.setRootVisible(false);
        this.getContentPane().add((Component)new JScrollPane((Component)this.treeTable), "Center");
    }

    protected void refresh() {
        DebuggerService debuggerService = (DebuggerService)ServerConnection.getInstance().lookupOptionalService(DebuggerService.class);
        if (debuggerService == null) {
            return;
        }
        this.saveState();
        this.determineDebuggerId();
        this.treeModel.setRoot((TreeTableNode)new InspectorNode(this.debuggerId, debuggerService));
        this.restoreState();
    }

    protected void determineDebuggerId() {
        if (this.debuggerId == null) {
            AskEvent ae = new AskEvent(this, "debugger.client.getdebuggerid");
            this.fireEvent(ae);
            this.debuggerId = (String)ae.getAnswer();
            if (this.debuggerId == null) {
                System.err.println("Debugger id could not be requested from debugger plugin");
                return;
            }
        }
    }

    @Override
    public String getTitle() {
        if (!this.debuggerListening) {
            return super.getTitle();
        }
        this.determineDebuggerId();
        return super.getTitle() + " " + MsgFormat.format((String)titleStatus, (Object)this.debuggerId);
    }

    @Override
    public String getSubTitle() {
        return super.getTitle();
    }

    void saveState() {
        Object o;
        if (this.stateSaved) {
            return;
        }
        this.stateSaved = true;
        JTree tree = this.treeTable.getTree();
        this.expandedNodeSpecList.clear();
        int nRows = tree.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Object o2;
            TreePath path = tree.getPathForRow(iRow);
            if (!tree.isExpanded(path) || !((o2 = path.getLastPathComponent()) instanceof InspectorNode)) continue;
            InspectorNode node = (InspectorNode)((Object)o2);
            this.expandedNodeSpecList.add(new NodeSpec(node));
        }
        this.selectedNodeSpec = null;
        TreePath[] paths = this.treeTable.getSelection();
        if (paths != null && paths.length > 0 && paths[0] != null && (o = paths[0].getLastPathComponent()) instanceof InspectorNode) {
            InspectorNode node = (InspectorNode)((Object)o);
            this.selectedNodeSpec = new NodeSpec(node);
        }
    }

    private void restoreState() {
        InspectorNode node;
        JTree tree = this.treeTable.getTree();
        int n = this.expandedNodeSpecList.size();
        for (int i = 0; i < n; ++i) {
            NodeSpec nodeSpec = (NodeSpec)this.expandedNodeSpecList.get(i);
            InspectorNode node2 = this.findNode(nodeSpec);
            if (node2 == null) continue;
            Object[] nodes = ((DefaultTreeTableModel)tree.getModel()).getPathToRoot((TreeNode)((Object)node2));
            TreePath path = new TreePath(nodes);
            this.treeTable.expandPath(path);
        }
        if (this.selectedNodeSpec != null && (node = this.findNode(this.selectedNodeSpec)) != null) {
            this.treeTable.selectNode((TreeNode)((Object)node));
        }
        this.stateSaved = false;
        this.expandedNodeSpecList.clear();
        this.selectedNodeSpec = null;
    }

    private InspectorNode findNode(NodeSpec nodeSpec) {
        JTree tree = this.treeTable.getTree();
        int nRows = tree.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            TreePath path = tree.getPathForRow(iRow);
            Object o = path.getLastPathComponent();
            if (!nodeSpec.matches(o)) continue;
            return (InspectorNode)((Object)o);
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        InspectorNode node;
        TreePath path = event.getNewLeadSelectionPath();
        if (path != null && (node = (InspectorNode)this.treeTable.getNodeByPath(path)) != null) {
            node.loadValueDetails();
            ObjectMemberInfo info = node.getInfo();
            String value = info.getToStringValue();
            if (value != null) {
                String title = info.getKey() + " (" + info.getType() + ")";
                String text = TextUtil.convertToHTML((String[])new String[]{title, value}, (boolean)true, (int)-1, (int)-1);
                this.fireEvent(new JaspiraEvent(this, "plugin.infopanel.setinfotext", text));
            } else {
                this.fireEvent(new JaspiraEvent(this, "plugin.infopanel.clearinfotext"));
            }
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        InspectorNode node;
        TreePath path = event.getPath();
        if (path != null && (node = (InspectorNode)this.treeTable.getNodeByPath(path)) != null) {
            node.loadChildren();
            this.treeModel.fireNodeStructureChanged((TreeNode)((Object)node));
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private static class NodeSpec {
        private String contextPath;
        private String expression;

        public NodeSpec(InspectorNode node) {
            this.contextPath = node.getContextPath();
            this.expression = node.getExpression();
        }

        public boolean matches(Object o) {
            InspectorNode node;
            return o instanceof InspectorNode && CommonUtil.equalsNull((Object)this.contextPath, (Object)(node = (InspectorNode)((Object)o)).getContextPath()) && CommonUtil.equalsNull((Object)this.expression, (Object)node.getExpression());
        }
    }

    private class InspectorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private InspectorTreeCellRenderer(JTreeTable treeTable) {
            super(treeTable);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                InspectorNode node;
                ObjectMemberInfo info;
                Icon icon = null;
                TreePath path = tree.getPathForRow(row);
                if (path != null && (info = (node = (InspectorNode)((Object)path.getLastPathComponent())).getInfo()) != null) {
                    String iconName;
                    String type = info.getType();
                    if (type != null) {
                        int index = type.indexOf(32);
                        if (index > 0) {
                            iconName = "TypeBean";
                        } else {
                            if (type.equals("Byte") || type.equals("Double") || type.equals("Float") || type.equals("Integer") || type.equals("Long") || type.equals("Short")) {
                                type = "Numeric";
                            }
                            iconName = "Type" + type;
                        }
                    } else {
                        iconName = "TypeObject";
                    }
                    icon = ItemIconMgr.getInstance().getIcon(iconName, 16);
                }
                if (icon == null) {
                    icon = InspectorPlugin.this.defaultIcon;
                }
                ((JLabel)c).setIcon(icon);
            }
            return c;
        }
    }

    public class ServerEvents
    extends EventModule {
        @Override
        public String getName() {
            return "debugger.server";
        }

        public JaspiraEventHandlerCode nodeentry(DebuggerServerEvent dse) {
            InspectorPlugin.this.refresh();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode nodeexit(DebuggerServerEvent dse) {
            InspectorPlugin.this.refresh();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode dataflow(DebuggerServerEvent dse) {
            InspectorPlugin.this.refresh();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode debugger_client_clearstatuswindows(JaspiraEvent je) {
            InspectorPlugin.this.saveState();
            InspectorPlugin.this.treeModel.setRoot(null);
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode debugger_client_statuschange(JaspiraEvent je) {
            String clientId = (String)je.getObject();
            InspectorPlugin.this.debuggerListening = clientId != null;
            InspectorPlugin.this.postPluginContainerUpdate(false);
            InspectorPlugin.this.saveState();
            InspectorPlugin.this.treeModel.setRoot(null);
            return EVENT_HANDLED;
        }
    }
}

