/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.itembrowser;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.cockpit.itemeditor.ItemCreationUtil;
import org.openbp.cockpit.itemeditor.StandardItemEditor;
import org.openbp.cockpit.plugins.itembrowser.ItemBrowserModule;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.string.StringUtil;
import org.openbp.common.util.observer.EventObserver;
import org.openbp.common.util.observer.ObserverEvent;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.ItemTypeDescriptor;
import org.openbp.core.model.item.activity.JavaActivityItem;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.ItemEditor;
import org.openbp.guiclient.model.item.ItemEditorRegistry;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.model.item.ItemTransferable;
import org.openbp.guiclient.model.item.ItemUtil;
import org.openbp.guiclient.model.item.itemfilter.ItemFilter;
import org.openbp.guiclient.model.item.itemfilter.ItemFilterListener;
import org.openbp.guiclient.model.item.itemfilter.ItemFilterMgr;
import org.openbp.guiclient.model.item.itemfilter.ItemTextFilter;
import org.openbp.guiclient.model.item.itemfilter.ItemTypeFilter;
import org.openbp.guiclient.model.item.itemtree.ItemTree;
import org.openbp.guiclient.model.item.itemtree.ItemTreeEvent;
import org.openbp.guiclient.model.item.itemtree.ItemTreeListener;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.gui.interaction.DragInitiator;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.option.SelectionOption;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.OptionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSetEvent;

public class ItemBrowserPlugin
extends AbstractVisiblePlugin
implements EventObserver,
DragOrigin,
ItemTreeListener,
FocusListener {
    public static final int GUESS_MODEL = 1;
    public static final int USE_CURRENT_MODEL = 2;
    ItemTree itemTree;
    private ItemFilterMgr filterMgr;
    private ItemTypeFilter itemTypeFilter;
    private String[] supportedItemTypes;
    ModelQualifier currentProcessQualifier;
    private MultiIcon dragImage;
    private boolean displayContextMenuWaitCursor = true;
    private JaspiraAction removeAction;
    private JaspiraAction runAction;
    private JaspiraToolbar toolbar;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    @Override
    protected Class[] getExternalEventModuleClasses() {
        return new Class[]{ItemBrowserModule.class};
    }

    @Override
    public boolean hasCloseButton() {
        return false;
    }

    @Override
    protected void initializeComponents() {
        this.getContentPane().removeAll();
        this.setupActions();
        this.setupItemFilter();
        this.setupItemTree();
        this.rebuildTree();
        this.getContentPane().add((Component)new JScrollPane(this.itemTree), "Center");
        this.updateActionStatus(null);
        ModelConnector.getInstance().registerObserver(this, null);
        this.addPluginFocusListener(this);
    }

    private void setupItemFilter() {
        this.filterMgr = new ItemFilterMgr(this);
        this.filterMgr.setFilterListener(new ItemFilterListener(){

            @Override
            public void applyFilter(ItemFilterMgr mgr, ItemFilter filter) {
                ItemBrowserPlugin.this.rebuildTree();
                if (filter instanceof ItemTextFilter) {
                    ItemBrowserPlugin.this.itemTree.expand(3);
                }
            }
        });
        this.itemTypeFilter = new ItemTypeFilter();
        if (this.supportedItemTypes != null) {
            this.itemTypeFilter.setSupportedItemTypes(this.supportedItemTypes);
        }
        this.filterMgr.addFilter(this.itemTypeFilter);
        this.filterMgr.addFilter(new ItemTextFilter());
        JComponent filterPane = this.filterMgr.getConfigurationPane();
        this.getContentPane().add((Component)filterPane, "North");
    }

    private void setupItemTree() {
        this.itemTree = new ItemTree();
        DragInitiator.makeDraggable(this.itemTree, this);
        String[] selectableItemTypes = ModelConnector.getInstance().getItemTypes(2);
        this.itemTree.setSelectableItemTypes(selectableItemTypes);
        this.itemTree.setSupportedItemTypes(this.supportedItemTypes);
        this.itemTree.setSelectionMode(1);
        this.itemTree.setRootVisible(false);
        this.itemTree.addItemTreeListener(this);
        this.itemTree.setFilterMgr(this.filterMgr);
        this.itemTree.setItemTypeFilter(this.itemTypeFilter);
        this.setupKeyBindings();
    }

    private void setupActions() {
        this.removeAction = this.getAction("plugin.itembrowser.remove");
        this.runAction = this.getAction("plugin.itembrowser.run");
    }

    private void updateActionStatus(Item item) {
        Model model;
        Model model2 = model = item != null ? item.getOwningModel() : null;
        if (this.removeAction != null) {
            this.removeAction.setEnabled(item != null && model.isModifiable());
        }
        if (this.runAction != null) {
            this.runAction.setEnabled(model != null);
        }
    }

    @Override
    protected void pluginUninstalled() {
        ModelConnector.getInstance().unregisterObserver(this);
    }

    @Override
    public Component getPluginFocusComponent() {
        return this.itemTree;
    }

    @Override
    public JaspiraToolbar createToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JaspiraToolbar();
            this.toolbar.add(this.filterMgr.getFilterToolbar());
            JaspiraAction action = this.getAction("plugin.itembrowser.togglefunctionalgroup");
            if (action != null) {
                this.toolbar.addSeparator();
                action.setEnabled(true);
                this.toolbar.add(action);
            }
        }
        return this.toolbar;
    }

    @Override
    public void applicationReady() {
        super.applicationReady();
        this.itemTree.setSelectionRow(0);
        this.focusPlugin();
    }

    public Model getSelectedModel(int flag) {
        Model ret = null;
        if ((flag & 1) != 0 && (ret = this.itemTree.determineSelectedModel()) != null) {
            return ret;
        }
        List list = this.itemTree.getSelectedObjects();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object o = list.get(i);
                if (!(o instanceof Model)) continue;
                return (Model)o;
            }
        }
        if (ret == null && (flag & 2) != 0 && this.currentProcessQualifier != null) {
            ModelQualifier modelQualifier = ModelQualifier.constructModelQualifier((String)this.currentProcessQualifier.getModel());
            ret = ModelConnector.getInstance().getOptionalModelByQualifier(modelQualifier);
        }
        return ret;
    }

    public Item getSelectedItem() {
        Item ret = null;
        List list = this.itemTree.getSelectedObjects();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object o = list.get(i);
                if (!(o instanceof Item)) continue;
                Item item = (Item)o;
                if (ret != null && ret != item) {
                    return null;
                }
                ret = item;
            }
        }
        return ret;
    }

    public void setSelectedObject(Object object) {
        if (object != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(object);
            this.itemTree.setSelectedObjects(list);
        } else {
            this.itemTree.setSelectedObjects(null);
        }
    }

    public String[] getSupportedItemTypes() {
        return this.supportedItemTypes;
    }

    public void setSupportedItemTypes(String[] supportedItemTypes) {
        this.supportedItemTypes = supportedItemTypes;
    }

    protected void rebuildTree() {
        this.itemTree.rebuildTree();
    }

    public void performAlternativeSelection() {
        this.itemTree.performAlternativeSelection();
    }

    @Override
    public boolean canCopy() {
        Item item = this.getSelectedItem();
        return item != null && !(item instanceof Model);
    }

    @Override
    public boolean canCut() {
        return this.canCopy();
    }

    @Override
    public boolean canPaste(Transferable transferable) {
        Model model = this.getSelectedModel(3);
        return model != null && model.isModifiable() && transferable != null && transferable.isDataFlavorSupported(ClientFlavors.ITEM);
    }

    @Override
    public Transferable copy() {
        Item item = this.getSelectedItem();
        return new ItemTransferable(item);
    }

    @Override
    public Transferable cut() {
        Item item = this.getSelectedItem();
        this.performAlternativeSelection();
        ModelConnector modelConnector = ModelConnector.getInstance();
        try {
            modelConnector.removeItem(item);
        }
        catch (ModelException ex) {
            modelConnector.showExceptionDialog(ex, (ModelObject)item);
            return null;
        }
        return new ItemTransferable(item);
    }

    @Override
    public void paste(Transferable content) {
        try {
            if (content.isDataFlavorSupported(ClientFlavors.ITEM)) {
                ItemEditor editor;
                JavaActivityItem activity;
                String oldClassName;
                Item source = (Item)content.getTransferData(ClientFlavors.ITEM);
                ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
                XMLDriver.getInstance().serialize((Object)source, (OutputStream)os);
                byte[] bytes = os.toByteArray();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                Item item = (Item)XMLDriver.getInstance().deserializeStream(null, (InputStream)is);
                item.setGeneratorInfo(source.getGeneratorInfo());
                Model model = this.getSelectedModel(3);
                item.setModel(model);
                item.maintainReferences(6);
                String oldName = item.getName();
                ItemUtil.ensureUniqueItemName(item, model);
                String newName = item.getName();
                if (item instanceof JavaActivityItem && (oldClassName = (activity = (JavaActivityItem)item).getHandlerDefinition().getHandlerClassName()) != null && oldName != null) {
                    String className = StringUtil.substitute((String)oldClassName, (String)("." + oldName), (String)("." + newName));
                    activity.getHandlerDefinition().setHandlerClassName(className);
                }
                if ((editor = ItemEditorRegistry.getInstance().lookupItemEditor(item.getItemType())) != null) {
                    StandardItemEditor.ensureProcessType(item);
                    final Item newItem = editor.openItem(item, 2);
                    if (newItem != null && ModelConnector.getInstance().saveItem(item, true)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ItemBrowserPlugin.this.setSelectedObject(newItem);
                            }
                        });
                    }
                }
            }
        }
        catch (XMLDriverException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (UnsupportedFlavorException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (IOException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public void dropAccepted(Transferable t) {
    }

    @Override
    public void dropCanceled(Transferable t) {
    }

    @Override
    public void dropPerformed(Transferable t) {
    }

    @Override
    public Transferable getTranferableAt(Point p) {
        TreePath path = this.itemTree.getPathForLocation(p.x, p.y);
        if (path == null) {
            return null;
        }
        TreeNode treeNode = (TreeNode)path.getLastPathComponent();
        if (treeNode instanceof ItemTree.ItemNode) {
            ItemTree.ItemNode itemnode = (ItemTree.ItemNode)((Object)treeNode);
            Item item = itemnode.getItem();
            this.dragImage = ItemIconMgr.getMultiIcon(ItemIconMgr.getInstance().getIcon(item, 24));
            return new BasicTransferable(item);
        }
        return null;
    }

    @Override
    public MultiIcon getDragImage() {
        return this.dragImage;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Item item = this.getSelectedItem();
        this.firePropertyBrowserEvent(item);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void handleItemTreeEvent(ItemTreeEvent e) {
        Item item;
        if (e.eventType == 1) {
            Item item2 = this.getSelectedItem();
            this.updateActionStatus(item2);
            this.fireEvent("global.clipboard.updatestatus");
            this.firePropertyBrowserEvent(item2);
        } else if (e.eventType == 3) {
            Item item3 = this.getSelectedItem();
            MouseEvent me = e.mouseEvent;
            this.showPopup(item3, me.getComponent(), me.getX(), me.getY());
        } else if (e.eventType == 2 && (item = this.getSelectedItem()) != null && !(item instanceof Model)) {
            this.fireEvent("plugin.association.open", new BasicTransferable(item));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPopup(Item item, Component comp, int x, int y) {
        if (this.displayContextMenuWaitCursor) {
            ApplicationUtil.waitCursorOn();
        }
        InteractionEvent iae = null;
        try {
            iae = new InteractionEvent((Plugin)this, "popup", new ItemTransferable(item));
            this.fireEvent(iae);
        }
        finally {
            if (this.displayContextMenuWaitCursor) {
                ApplicationUtil.waitCursorOff();
                this.displayContextMenuWaitCursor = false;
            }
        }
        iae.createPopupMenu().show(comp, x, y);
    }

    protected void firePropertyBrowserEvent(Item item) {
        String title = null;
        String desc = null;
        MultiIcon icon = null;
        boolean readOnly = false;
        Item originalItem = item;
        if (item != null) {
            AskEvent ae = new AskEvent(this, "global.edit.geteditedinstance", item);
            this.fireEvent(ae);
            Item editedItem = (Item)ae.getAnswer();
            if (editedItem != null) {
                item = editedItem;
            }
            icon = item instanceof Model ? ItemIconMgr.getMultiIcon(ItemIconMgr.getInstance().getIcon("Model", 16)) : ItemIconMgr.getMultiIcon(ItemIconMgr.getInstance().getIcon(item, 16));
            title = item.getDisplayText();
            String modelObjectTypeName = item.getModelObjectTypeName();
            if (modelObjectTypeName != null) {
                title = title + " (" + modelObjectTypeName + ")";
            }
            desc = item.getDescriptionText();
            readOnly |= !item.isModifiable();
        } else {
            readOnly = true;
        }
        PropertyBrowserSetEvent oee = new PropertyBrowserSetEvent(this, item, originalItem, false, desc, title, icon, readOnly, false);
        this.fireEvent(oee);
        this.fireEvent(new JaspiraEvent(this, "plugin.infopanel.setinfotext", item));
    }

    private void setupKeyBindings() {
        InputMap focusInputMap = new InputMap();
        focusInputMap.setParent(SwingUtilities.getUIInputMap(this.itemTree, 0));
        InputMap focusAncestorInputMap = new InputMap();
        focusAncestorInputMap.setParent(SwingUtilities.getUIInputMap(this.itemTree, 1));
        ActionMap actionMap = new ActionMap();
        actionMap.setParent(SwingUtilities.getUIActionMap(this.itemTree));
        KeyStroke ks = KeyStroke.getKeyStroke(32, 0);
        focusInputMap.put(ks, "space");
        focusAncestorInputMap.put(ks, "space");
        actionMap.put("space", new AbstractAction("space"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Item item = ItemBrowserPlugin.this.getSelectedItem();
                TreePath[] paths = ItemBrowserPlugin.this.itemTree.getSelectionPaths();
                if (paths != null && paths.length > 0) {
                    TreePath path = paths[0];
                    Rectangle r = ItemBrowserPlugin.this.itemTree.getPathBounds(path);
                    ItemBrowserPlugin.this.showPopup(item, ItemBrowserPlugin.this.itemTree, r.x, r.y + r.height);
                }
            }
        });
        SwingUtilities.replaceUIInputMap(this.itemTree, 0, focusInputMap);
        SwingUtilities.replaceUIInputMap(this.itemTree, 1, focusAncestorInputMap);
        SwingUtilities.replaceUIActionMap(this.itemTree, actionMap);
    }

    public void observeEvent(ObserverEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ItemBrowserPlugin.this.rebuildTree();
            }
        });
    }

    void addNewItemActions(JaspiraAction group) {
        String[] itemTypes = ModelConnector.getInstance().getItemTypes(2);
        for (int i = 0; i < itemTypes.length; ++i) {
            ItemTypeDescriptor itd = ModelConnector.getInstance().getItemTypeDescriptor(itemTypes[i]);
            NewAction action = new NewAction(itd);
            action.setPriority(i);
            group.addMenuChild(action);
        }
    }

    void addNewItemActions(InteractionEvent iae) {
        String[] itemTypes = ModelConnector.getInstance().getItemTypes(2);
        for (int i = 0; i < itemTypes.length; ++i) {
            ItemTypeDescriptor itd = ModelConnector.getInstance().getItemTypeDescriptor(itemTypes[i]);
            NewAction action = new NewAction(itd);
            action.setPriority(i);
            iae.add(action);
        }
    }

    public class ItemBrowserOptions
    extends OptionModule {

        public class NewModelGeneratorDefaultDirectoriesOption
        extends SelectionOption {
            public NewModelGeneratorDefaultDirectoriesOption() {
                super(ItemBrowserPlugin.this.getPluginResourceCollection(), "itembrowser.newmodelgeneratordefaultdirectories", "maven-common-main", new String[]{"maven-common-main", "maven-common-test", "plain-common", "maven-local-main", "maven-local-test", "plain-local"}, new Object[]{"maven-common-main", "maven-common-test", "plain-common", "maven-local-main", "maven-local-test", "plain-local"});
            }
        }
    }

    private class NewAction
    extends JaspiraAction {
        private ItemTypeDescriptor itd;

        public NewAction(ItemTypeDescriptor itd) {
            super("new." + itd.getItemType(), "_" + itd.getItemType(), null, ItemIconMgr.getMultiIcon(ItemIconMgr.getInstance().getIcon(null, itd.getItemType(), 16)), null, 50, "action");
            this.itd = itd;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Model model = ItemBrowserPlugin.this.getSelectedModel(3);
            Item item = ItemCreationUtil.createItem(model, null, null, this.itd, null);
            if (item != null) {
                final Item newItem = item;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ItemBrowserPlugin.this.setSelectedObject(newItem);
                        ItemBrowserPlugin.this.focusPlugin();
                        if (newItem instanceof ProcessItem) {
                            ItemBrowserPlugin.this.fireEvent("plugin.association.open", new BasicTransferable(newItem));
                        }
                    }
                });
            }
        }
    }

    public class InteractionEvents
    extends InteractionModule {
        @Override
        public JaspiraEventHandlerCode popup(InteractionEvent ie) {
            return this.addActions(ie, true, true) ? EVENT_HANDLED : EVENT_IGNORED;
        }

        private boolean addActions(InteractionEvent ie, boolean isMenu, boolean isPopup) {
            JaspiraAction group;
            if (ie.getSourcePlugin() != ItemBrowserPlugin.this) {
                return false;
            }
            boolean haveModel = ie.isDataFlavorSupported(ClientFlavors.MODEL);
            boolean haveItem = ie.isDataFlavorSupported(ClientFlavors.ITEM);
            boolean haveProcess = ie.isDataFlavorSupported(ClientFlavors.PROCESS_ITEM);
            if (isMenu) {
                group = new JaspiraAction(ItemBrowserPlugin.this, "submenu.new");
                ItemBrowserPlugin.this.addNewItemActions(group);
                ie.add(group);
            }
            group = new JaspiraAction("popup.itembrowser.manage", null, null, null, null, 1, "group");
            if (ItemBrowserPlugin.this.removeAction != null) {
                if (isMenu) {
                    if (isPopup && haveModel | haveItem) {
                        group.addMenuChild(ItemBrowserPlugin.this.removeAction);
                    }
                } else {
                    group.addToolbarChild(ItemBrowserPlugin.this.removeAction);
                }
            }
            ie.add(group);
            group = new JaspiraAction("popup.itembrowser.extras", null, null, null, null, 2, "group");
            if (isMenu) {
                if (isPopup && haveModel | haveProcess && ItemBrowserPlugin.this.runAction != null) {
                    group.addMenuChild(ItemBrowserPlugin.this.runAction);
                }
            } else if (ItemBrowserPlugin.this.runAction != null) {
                group.addToolbarChild(ItemBrowserPlugin.this.runAction);
            }
            ie.add(group);
            return true;
        }
    }
}

