/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.toolbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.cockpit.plugins.toolbox.ToolBoxItem;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.Item;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraMenuItem;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.gui.interaction.BreakoutBoxEntry;
import org.openbp.jaspira.gui.interaction.BreakoutEvent;
import org.openbp.jaspira.gui.interaction.BreakoutProvider;
import org.openbp.jaspira.gui.interaction.Importer;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.interaction.ViewDropRegion;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugins.colorchooser.ColorChooserPlugin;

public abstract class ToolBoxPlugin
extends AbstractVisiblePlugin
implements InteractionClient,
BreakoutProvider {
    private static final String MAINREGION = "main";
    private static final Dimension FIXEDSIZE = new Dimension(50, 50);
    private JPanel toolBoxItemPanel;
    private JLabel emptyMessage;
    private JScrollPane scrollPane;
    private List entries;
    private String toolBoxTitle;
    private String currentSkinName;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    @Override
    protected void initializeComponents() {
        this.entries = new ArrayList();
        this.emptyMessage = new JLabel(this.getPluginResourceCollection().getRequiredString("toolbox.empty"));
        this.toolBoxItemPanel = new JPanel(new ToolBoxLayoutManager());
        this.toolBoxItemPanel.setOpaque(false);
        this.toolBoxItemPanel.add(this.emptyMessage);
        this.toolBoxItemPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    InteractionEvent ie = new InteractionEvent((Plugin)ToolBoxPlugin.this, "toolbox", this);
                    ToolBoxPlugin.this.fireEvent(ie);
                    JPopupMenu pop = ie.createPopupMenu();
                    if (ToolBoxPlugin.this.canTitleChange()) {
                        if (pop == null) {
                            pop = new JPopupMenu();
                        } else {
                            pop.addSeparator();
                        }
                        pop.add(new JaspiraMenuItem(new JaspiraAction(ToolBoxPlugin.this, "toolbox.changename"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String msg = this.getActionResource().getRequiredString("toolbox.dialog.changename.text");
                                String s = JOptionPane.showInputDialog(null, (Object)msg);
                                ToolBoxPlugin.this.setToolBoxTitle(s);
                            }
                        }));
                    }
                    if (pop != null) {
                        pop.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane(this.toolBoxItemPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ToolBoxPlugin.this.toolBoxItemPanel.revalidate();
            }
        });
        this.getContentPane().add(this.scrollPane);
        this.getContentPane().setMinimumSize(FIXEDSIZE);
        this.addStandardToolBoxItems();
    }

    protected void addStandardToolBoxItems() {
    }

    protected void addToolBoxItem(ModelObject mo, String tooltipResourceName) {
        if (mo instanceof Item) {
            ((Item)mo).setRuntimeAttribute("_skeleton", (Object)Boolean.TRUE);
        }
        this.addToolBoxItem(new ToolBoxItem(null, mo.getModelObjectSymbolName(), this.getPluginResourceCollection().getOptionalString(tooltipResourceName), (Transferable)new BasicTransferable(mo)));
    }

    public void addToolBoxItem(ToolBoxItem item) {
        if (this.entries.size() == 0) {
            this.toolBoxItemPanel.remove(this.emptyMessage);
        }
        this.toolBoxItemPanel.add(item);
        this.entries.add(item);
        item.setToolbox(this);
    }

    public void removeToolBoxItem(ToolBoxItem item) {
        this.toolBoxItemPanel.remove(item);
        this.entries.remove(item);
        if (this.entries.size() == 0) {
            this.toolBoxItemPanel.add(this.emptyMessage);
        }
        item.setToolbox(null);
    }

    public void clearToolbox() {
        this.entries.clear();
        this.toolBoxItemPanel.removeAll();
        this.toolBoxItemPanel.add(this.emptyMessage);
    }

    public void refreshContent() {
        this.scrollPane.getViewport().revalidate();
        this.scrollPane.getViewport().repaint();
    }

    public void updateSkinIcons() {
        for (ToolBoxItem toolBoxItem : this.entries) {
            toolBoxItem.updateModelIcon(this.currentSkinName);
        }
    }

    public void setToolBoxTitle(String title) {
        this.toolBoxTitle = title;
        this.updatePluginContainer(false);
    }

    public String getToolBoxTitle() {
        return this.toolBoxTitle;
    }

    @Override
    public String getTitle() {
        String s = super.getTitle();
        String tt = this.getToolBoxTitle();
        if (tt != null) {
            s = s + ": " + tt;
        }
        return s;
    }

    protected boolean canTitleChange() {
        return true;
    }

    protected boolean acceptDrop() {
        return true;
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragEnded(Transferable transferable) {
    }

    @Override
    public void dragStarted(Transferable transferable) {
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return this.getDropRegions(flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        if (this.acceptDrop() && (flavors.contains(ClientFlavors.ITEM) || flavors.contains(ModelerFlavors.COLOR))) {
            return Collections.singletonList(new ViewDropRegion(MAINREGION, this, SwingUtilities.getLocalBounds(this.toolBoxItemPanel), this.toolBoxItemPanel));
        }
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return this.getImportersAt(p);
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        if (MAINREGION.equals(regionId)) {
            DataFlavor[] flavors = data.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (flavors[i].equals(ClientFlavors.ITEM)) {
                    try {
                        Object o = data.getTransferData(ClientFlavors.ITEM);
                        Item item = null;
                        if (o instanceof Item) {
                            item = (Item)o;
                            this.addToolBoxItem(new ToolBoxItem(item.getDisplayText(), ItemIconMgr.getInstance().getIcon(item, 24), item.getDescriptionText(), (Transferable)new BasicTransferable(item)));
                            this.refreshContent();
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (!flavors[i].equals(ModelerFlavors.COLOR)) continue;
                try {
                    Color c = (Color)data.getTransferData(ModelerFlavors.COLOR);
                    ResourceCollection res = this.getPluginResourceCollection();
                    StringBuffer description = new StringBuffer();
                    description.append(res.getOptionalString("color.red"));
                    description.append(' ');
                    description.append(c.getRed());
                    description.append('\n');
                    description.append(res.getOptionalString("color.green"));
                    description.append(' ');
                    description.append(c.getGreen());
                    description.append('\n');
                    description.append(res.getOptionalString("color.blue"));
                    description.append(' ');
                    description.append(c.getBlue());
                    this.addToolBoxItem(new ToolBoxItem(res.getOptionalString("color.title"), ColorChooserPlugin.createColorDragIcon(c).getIcon(24), description.toString(), (Transferable)new BasicTransferable(c)));
                    this.refreshContent();
                    continue;
                }
                catch (UnsupportedFlavorException e) {
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected boolean acceptFlyWheelKey(int key) {
        return false;
    }

    @Override
    public BreakoutBoxEntry[] createBreakOutEntries(List importers) {
        ArrayList<ToolBoxItem> list = new ArrayList<ToolBoxItem>();
        for (Importer importer : importers) {
            DataFlavor[] flavors = importer.getFlavors();
            for (ToolBoxItem item : this.entries) {
                for (int i = 0; i < flavors.length; ++i) {
                    if (!item.getTransferable().isDataFlavorSupported(flavors[i])) continue;
                    item.setImporter(importer);
                    list.add(item);
                }
            }
        }
        return list.toArray(new BreakoutBoxEntry[list.size()]);
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "toolbox.standard";
        }

        public JaspiraEventHandlerCode global_breakout_getprovider(BreakoutEvent boe) {
            if (ToolBoxPlugin.this.acceptFlyWheelKey(boe.getKey())) {
                boe.setProvider(ToolBoxPlugin.this);
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                ToolBoxPlugin.this.currentSkinName = ((Modeler)o).getDrawing().getProcessSkin().getName();
                ToolBoxPlugin.this.updateSkinIcons();
                ToolBoxPlugin.this.refreshContent();
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_skinchanged(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                ToolBoxPlugin.this.currentSkinName = ((Modeler)o).getDrawing().getProcessSkin().getName();
                ToolBoxPlugin.this.updateSkinIcons();
                ToolBoxPlugin.this.refreshContent();
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_closed(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                ToolBoxPlugin.this.currentSkinName = null;
                ToolBoxPlugin.this.updateSkinIcons();
                ToolBoxPlugin.this.refreshContent();
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }

    public class ToolBoxLayoutManager
    extends FlowLayout {
        public ToolBoxLayoutManager() {
            super(0);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            Insets ins = target.getInsets();
            Dimension parentDim = target.getParent().getSize();
            int maxWidth = parentDim.width - ins.left - ins.right - 2 * this.getHgap();
            Dimension d = new Dimension(parentDim.width, 0);
            int currentHeight = 0;
            int currentWidth = 0;
            boolean lineFull = false;
            int count = target.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component comp = target.getComponent(i);
                Dimension cd = comp.getPreferredSize();
                lineFull = false;
                if (currentWidth + cd.width > maxWidth) {
                    d.height += currentHeight + this.getVgap();
                    currentWidth = 0;
                    currentHeight = 0;
                }
                currentHeight = Math.max(currentHeight, cd.height);
                currentWidth += cd.width + this.getVgap();
            }
            if (!lineFull) {
                d.height += currentHeight;
            }
            d.height += this.getVgap();
            d.height = Math.max(d.height, parentDim.height);
            return d;
        }

        @Override
        public void layoutContainer(Container target) {
            Insets ins = target.getInsets();
            Dimension parentDim = target.getParent().getSize();
            int maxWidth = parentDim.width - ins.left - ins.right - this.getHgap();
            int currentWidth = this.getHgap();
            int currentHeight = this.getVgap();
            int heightdif = 0;
            int count = target.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = target.getComponent(i);
                Dimension cd = c.getPreferredSize();
                if (currentWidth + cd.width > maxWidth) {
                    currentWidth = this.getHgap();
                    currentHeight += heightdif + this.getVgap();
                    heightdif = 0;
                }
                c.setLocation(currentWidth, currentHeight);
                currentWidth += cd.width + this.getHgap();
                heightdif = Math.max(heightdif, cd.height);
                c.setSize(cd.width, cd.height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }
    }
}

