/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.plugins.variables;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.figures.process.ProcessVariableConnection;
import org.openbp.cockpit.plugins.variables.VariablesContainer;
import org.openbp.common.CommonUtil;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.util.CopyUtil;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.core.model.item.process.ProcessVariableImpl;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.interaction.BasicDropRegion;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.gui.interaction.DragInitiator;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserEvent;
import org.openbp.jaspira.propertybrowser.PropertyBrowserImpl;
import org.openbp.jaspira.propertybrowser.PropertyBrowserListener;
import org.openbp.jaspira.propertybrowser.SaveStrategy;
import org.openbp.jaspira.propertybrowser.nodes.AbstractNode;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;

public class VariablesPlugin
extends AbstractVisiblePlugin
implements SaveStrategy,
PropertyBrowserListener,
InteractionClient,
DragOrigin,
FocusListener {
    private Modeler currentModeler;
    private ProcessItem currentProcess;
    private VariablesContainer variablesContainer;
    private PropertyBrowserImpl propertyBrowser;
    private static final String MAINREGION = "main";
    private MultiIcon dragImage;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    @Override
    protected void initializeComponents() {
        this.propertyBrowser = new PropertyBrowserImpl(this, null);
        this.propertyBrowser.setRootVisible(false);
        this.getContentPane().add((Component)new JScrollPane((Component)((Object)this.propertyBrowser)), "Center");
        this.propertyBrowser.addPropertyBrowserListener(this);
        this.addPluginFocusListener(this);
        DragInitiator.makeDraggable((Component)((Object)this.propertyBrowser), this);
    }

    protected void refresh() {
    }

    @Override
    public void handlePropertyBrowserEvent(PropertyBrowserEvent e) {
        switch (e.eventType) {
            case 2: 
            case 3: {
                if (e.node == null) break;
                Object eventArg = null;
                eventArg = e.node instanceof ObjectNode ? ((ObjectNode)e.node).getObject() : e.node.getColumnValue(0);
                if (!(eventArg instanceof DescriptionObject)) break;
                this.fireEvent(new JaspiraEvent(this, "plugin.infopanel.setinfotext", eventArg));
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.propertyBrowser.saveObject();
        this.fireEvent(new JaspiraEvent(this, "plugin.infopanel.clearinfotext", null));
    }

    @Override
    public boolean executeSave(PropertyBrowser editor) {
        this.currentModeler.startUndo("Edit Process Variables");
        this.variablesContainer = (VariablesContainer)((Object)editor.getModifiedObject());
        List newVariables = this.variablesContainer.getProcessVariableList();
        this.updateProcessVariables(newVariables);
        this.fireEvent("modeler.view.updatedrawing");
        this.fireEvent("modeler.process.modified");
        this.currentModeler.endUndo();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariablesPlugin.this.showParams();
            }
        });
        return true;
    }

    private void updateProcessVariables(List newVars) {
        List oldVars = this.currentProcess.getProcessVariableList();
        if (oldVars != null) {
            ArrayList<ProcessVariable> toDelete = null;
            for (ProcessVariable oldVar : oldVars) {
                ProcessVariable newVar = this.findVariable(newVars, oldVar);
                if (newVar != null) {
                    try {
                        oldVar.copyFrom((Object)newVar, 1);
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                List dataLinks = null;
                try {
                    dataLinks = (List)CopyUtil.copyCollection((Collection)this.currentProcess.getDataLinkList(), (int)0);
                    for (DataLink link : dataLinks) {
                        if (link.getSourceParam() != oldVar && link.getTargetParam() != oldVar) continue;
                        ProcessVariableConnection con = (ProcessVariableConnection)link.getRepresentation();
                        con.release();
                        this.currentProcess.removeDataLink(link);
                    }
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                if (toDelete == null) {
                    toDelete = new ArrayList<ProcessVariable>();
                }
                toDelete.add(oldVar);
            }
            if (toDelete != null) {
                for (ProcessVariable oldVar : toDelete) {
                    this.currentProcess.removeProcessVariable(oldVar);
                }
            }
        }
        if (newVars != null) {
            for (ProcessVariable newVar : newVars) {
                ProcessVariable oldVar;
                oldVar = this.findVariable(oldVars, newVar);
                if (oldVar != null) continue;
                try {
                    ProcessVariable toAdd = (ProcessVariable)newVar.clone();
                    toAdd.setTmpReference((Object)"!");
                    this.currentProcess.addProcessVariable(toAdd);
                }
                catch (CloneNotSupportedException e) {}
            }
        }
        List vars = this.currentProcess.getProcessVariableList();
        this.adjustTemporaryReferences(vars, false);
        this.currentProcess.maintainReferences(5);
    }

    ProcessVariable findVariable(List list, ProcessVariable reference) {
        if (list != null) {
            for (ProcessVariable var : list) {
                if (!CommonUtil.equalsNull((Object)var.getTmpReference(), (Object)reference.getTmpReference())) continue;
                return var;
            }
        }
        return null;
    }

    void adjustTemporaryReferences(List vars, boolean set) {
        if (vars != null) {
            for (ProcessVariable var : vars) {
                if (set) {
                    var.setTmpReference((Object)var.getName());
                    continue;
                }
                var.setTmpReference(null);
            }
        }
    }

    public void showParams() {
        if (this.currentProcess != null) {
            this.currentProcess.maintainReferences(10);
            try {
                List vars = this.currentProcess.getProcessVariableList();
                this.adjustTemporaryReferences(vars, true);
                List processVariableList = (List)CopyUtil.copyCollection((Collection)vars, (int)2);
                this.adjustTemporaryReferences(processVariableList, true);
                this.variablesContainer = new VariablesContainer(this.currentProcess, processVariableList);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            this.variablesContainer = null;
        }
        try {
            this.propertyBrowser.setObject((Object)this.variablesContainer, false);
            this.propertyBrowser.expandAll(true);
        }
        catch (CloneNotSupportedException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (XMLDriverException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    public void addParam(String name, DataTypeItem type) {
        if (this.currentProcess == null) {
            return;
        }
        this.currentModeler.startUndo("Add Process Variable");
        ProcessVariableImpl param = new ProcessVariableImpl();
        param.setDataType(type);
        List paramList = this.currentProcess.getProcessVariableList();
        if (name == null) {
            name = type.getName();
        }
        name = NamedObjectCollectionUtil.createUniqueId((Collection)paramList, (String)name);
        param.setName(name);
        this.currentProcess.addProcessVariable((ProcessVariable)param);
        param.maintainReferences(5);
        this.showParams();
        this.propertyBrowser.setObjectModified(true);
        this.fireEvent("modeler.process.modified");
        this.currentModeler.endUndo();
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragEnded(Transferable transferable) {
    }

    @Override
    public void dragStarted(Transferable transferable) {
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return this.getDropRegions(flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        if (flavors.contains(ClientFlavors.TYPE_ITEM)) {
            BasicDropRegion region = new BasicDropRegion(MAINREGION, this, this.getPluginComponent());
            region.setPaint(ModelerColors.DROP_REGION);
            return Collections.singletonList(region);
        }
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return this.getImportersAt(p);
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        if (MAINREGION.equals(regionId)) {
            DataFlavor[] flavors = data.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(ClientFlavors.TYPE_ITEM)) continue;
                try {
                    DataTypeItem type = (DataTypeItem)data.getTransferData(ClientFlavors.TYPE_ITEM);
                    if (!this.propertyBrowser.saveObject()) {
                        return false;
                    }
                    this.addParam(null, type);
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.focusPlugin();
        }
        return false;
    }

    @Override
    public void dropAccepted(Transferable t) {
    }

    @Override
    public void dropCanceled(Transferable t) {
    }

    @Override
    public void dropPerformed(Transferable t) {
    }

    @Override
    public Transferable getTranferableAt(Point p) {
        ObjectNode odn;
        TreePath path = this.propertyBrowser.getPathByPoint(p);
        if (path == null || path.getPathCount() < 2) {
            return null;
        }
        AbstractNode treenode = (AbstractNode)path.getLastPathComponent();
        if (treenode != null && (odn = treenode.getObjectNode()) != null && odn.getObject() instanceof ProcessVariable) {
            if (!this.propertyBrowser.saveObject()) {
                return null;
            }
            ProcessVariable param = (ProcessVariable)odn.getObject();
            this.dragImage = ItemIconMgr.getMultiIcon(ItemIconMgr.getInstance().getTypeIcon(param.getDataType(), 24));
            return new BasicTransferable(param);
        }
        return null;
    }

    @Override
    public MultiIcon getDragImage() {
        return this.dragImage;
    }

    public class SaveEvents
    extends EventModule {
        @Override
        public String getName() {
            return "standard.file";
        }

        @Override
        public int getPriority() {
            return 25;
        }

        public JaspiraEventHandlerCode save(JaspiraActionEvent jae) {
            if (!VariablesPlugin.this.getPluginComponent().isShowing()) {
                return EVENT_IGNORED;
            }
            VariablesPlugin.this.propertyBrowser.saveObject();
            return EVENT_HANDLED;
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "variables";
        }

        @Override
        public int getPriority() {
            return 101;
        }

        public JaspiraEventHandlerCode refresh(JaspiraEvent je) {
            VariablesPlugin.this.showParams();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode createprocessvarfromparam(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof NodeParam) {
                if (!VariablesPlugin.this.propertyBrowser.saveObject()) {
                    return EVENT_IGNORED;
                }
                NodeParam nodeParam = (NodeParam)o;
                String name = nodeParam.getName();
                DataTypeItem type = nodeParam.getDataType();
                VariablesPlugin.this.addParam(name, type);
            }
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Modeler) {
                if (!VariablesPlugin.this.propertyBrowser.saveObject()) {
                    return EVENT_IGNORED;
                }
                VariablesPlugin.this.currentModeler = (Modeler)o;
                VariablesPlugin.this.currentProcess = VariablesPlugin.this.currentModeler.getProcess();
                VariablesPlugin.this.showParams();
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_closed(JaspiraEvent je) {
            if (!VariablesPlugin.this.propertyBrowser.saveObject()) {
                return EVENT_IGNORED;
            }
            VariablesPlugin.this.currentModeler = null;
            VariablesPlugin.this.currentProcess = null;
            VariablesPlugin.this.showParams();
            return EVENT_HANDLED;
        }

        public synchronized JaspiraEventHandlerCode saveobject(JaspiraEvent event) {
            VariablesPlugin.this.propertyBrowser.saveObject();
            return EVENT_HANDLED;
        }
    }
}

