/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model;

import java.util.List;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.generic.msgcontainer.StandardMsgContainer;
import org.openbp.common.util.observer.EventObserver;
import org.openbp.common.util.observer.EventObserverMgr;
import org.openbp.common.util.observer.ObserverEvent;
import org.openbp.core.CoreModule;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.ItemTypeDescriptor;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.modelmgr.ModelMgr;
import org.openbp.core.model.modelmgr.ModelNotificationService;
import org.openbp.core.remote.ClientSession;
import org.openbp.guiclient.model.ModelConnectorEvent;
import org.openbp.guiclient.remote.ServerConnection;
import org.openbp.swing.components.JMsgBox;

public final class ModelConnector {
    private final EventObserverMgr observerMgr = new EventObserverMgr();
    private static ModelConnector singletonInstance;
    private ModelMgr modelMgr;

    public static synchronized ModelConnector getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ModelConnector();
        }
        return singletonInstance;
    }

    private ModelConnector() {
        this.observerMgr.setSupportedEventTypes(ModelConnectorEvent.getSupportedEventTypes());
    }

    public void initialize(CoreModule coreModule) {
        this.modelMgr = coreModule.getModelMgr();
        StandardMsgContainer msgContainer = this.modelMgr.getMsgContainer();
        msgContainer.clearMsgs();
        this.modelMgr.readModels();
        this.modelMgr.initializeModels();
        String errMsg = msgContainer.toString();
        if (errMsg != null && !errMsg.equals("")) {
            msgContainer.clearMsgs();
            System.err.println(errMsg);
            System.err.println();
        }
        this.fireEvent(new ModelConnectorEvent("ModelLoaded"));
    }

    public StandardMsgContainer getMsgContainer() {
        return this.modelMgr != null ? this.modelMgr.getMsgContainer() : null;
    }

    public void showExceptionDialog(Throwable e, ModelObject o) {
        if (e != null) {
            String msg = MsgFormat.format((String)"Error while processing component or model $0:\n{1}.", (Object)o.getQualifier(), (Object)ExceptionUtil.getNestedMessage((Throwable)e));
            JMsgBox.show(null, (String)msg, (int)0x40040001);
        }
    }

    public boolean saveItem(Item item, boolean isNew) {
        try {
            Model model = item.getModel();
            if (item instanceof Model) {
                Model modelToUpdate = (Model)item;
                if (isNew) {
                    this.addModel(modelToUpdate);
                } else {
                    this.updateModel(modelToUpdate);
                }
            } else if (isNew) {
                this.addItem(model, item, true);
            } else {
                this.updateItem(item);
            }
        }
        catch (ModelException e) {
            this.showExceptionDialog(e, (ModelObject)item);
            return false;
        }
        return true;
    }

    public Model getModelByQualifier(ModelQualifier modelQualifier) {
        return this.modelMgr.getModelByQualifier(modelQualifier);
    }

    public Model getOptionalModelByQualifier(ModelQualifier modelQualifier) {
        return this.modelMgr.getOptionalModelByQualifier(modelQualifier);
    }

    public List getModels() {
        return this.modelMgr.getModels();
    }

    public synchronized void addModel(Model model) {
        this.modelMgr.addModel(model);
        this.fireEvent(new ModelConnectorEvent("ModelAdded", model.getQualifier()));
    }

    public synchronized void updateModel(Model model) {
        model.maintainReferences(5);
        this.modelMgr.updateModel(model);
        this.fireEvent(new ModelConnectorEvent("ModelUpdated", model.getQualifier()));
    }

    public synchronized void removeModel(Model model) {
        ModelQualifier qualifier = model.getQualifier();
        this.modelMgr.removeModel(model);
        this.fireEvent(new ModelConnectorEvent("ModelRemoved", qualifier));
    }

    public Item getItemByQualifier(ModelQualifier qualifier, boolean required) {
        return this.modelMgr.getItemByQualifier(qualifier, required);
    }

    public synchronized void addItem(Model model, Item item, boolean syncGlobalReferences) {
        item.setModel(model);
        this.checkDefaultProcess(item);
        if (syncGlobalReferences) {
            item.maintainReferences(5);
        }
        this.modelMgr.addItem(model, item, syncGlobalReferences);
        this.fireEvent(new ModelConnectorEvent("ItemAdded", item.getQualifier()));
    }

    public synchronized void updateItem(Item item) {
        this.checkDefaultProcess(item);
        item.maintainReferences(5);
        this.modelMgr.updateItem(item);
        this.fireEvent(new ModelConnectorEvent("ItemUpdated", item.getQualifier()));
    }

    public synchronized void removeItem(Item item) {
        ModelQualifier qualifier = item.getQualifier();
        this.modelMgr.removeItem(item);
        this.fireEvent(new ModelConnectorEvent("ItemRemoved", qualifier));
    }

    public synchronized void moveItem(Item item, ModelQualifier destinationQualifier) {
        ModelQualifier sourceQualifier = item.getQualifier();
        if (sourceQualifier.equals((Object)destinationQualifier)) {
            return;
        }
        this.modelMgr.moveItem(item, destinationQualifier);
        this.fireEvent(new ModelConnectorEvent("ItemRenamed", destinationQualifier, sourceQualifier));
    }

    public String[] getItemTypes(int mode) {
        return this.modelMgr.getItemTypes(mode);
    }

    public ItemTypeDescriptor[] getItemTypeDescriptors(int mode) {
        return this.modelMgr.getItemTypeDescriptors(mode);
    }

    public ItemTypeDescriptor getItemTypeDescriptor(String itemType) {
        return this.modelMgr.getItemTypeDescriptor(itemType);
    }

    private void checkDefaultProcess(Item item) {
        if (!(item instanceof ProcessItem)) {
            return;
        }
        ProcessItem process = (ProcessItem)item;
        if (!process.isDefaultProcess()) {
            return;
        }
        ProcessItem currentDefaultProcess = process.getModel().getDefaultProcess();
        if (currentDefaultProcess == null || currentDefaultProcess.getName().equals(process.getName())) {
            return;
        }
        currentDefaultProcess.setDefaultProcess(false);
        this.modelMgr.updateItem((Item)currentDefaultProcess);
        this.fireEvent(new ModelConnectorEvent("ItemUpdated", currentDefaultProcess.getQualifier()));
    }

    public void registerObserver(EventObserver observer, String[] eventTypes) {
        this.observerMgr.registerObserver(observer, eventTypes);
    }

    public void unregisterObserver(EventObserver observer) {
        this.observerMgr.unregisterObserver(observer);
    }

    public boolean suspendModelConnectorEvents() {
        return this.observerMgr.suspendObserverEvents();
    }

    public void resumeModelConnectorEvents() {
        this.observerMgr.resumeObserverEvents();
    }

    protected void fireEvent(ModelConnectorEvent event) {
        this.observerMgr.fireEvent((ObserverEvent)event);
        ModelNotificationService mns = (ModelNotificationService)ServerConnection.getInstance().lookupOptionalService(ModelNotificationService.class);
        if (mns != null) {
            try {
                ClientSession session = ServerConnection.getInstance().getSession();
                ModelQualifier qualifier = event.getQualifier();
                String eventType = event.getEventType();
                if (eventType == "ModelAdded" || eventType == "ItemAdded") {
                    mns.modelUpdated(session, qualifier, 1);
                } else if (eventType == "ModelUpdated" || eventType == "ItemUpdated") {
                    mns.modelUpdated(session, qualifier, 2);
                } else if (eventType == "ModelRemoved" || eventType == "ItemRemoved") {
                    mns.modelUpdated(session, qualifier, 4);
                } else if (eventType == "ModelRenamed" || eventType == "ItemRenamed") {
                    ModelQualifier prevQualifier = event.getPreviousQualifier();
                    mns.modelUpdated(session, prevQualifier, 4);
                    mns.modelUpdated(session, qualifier, 1);
                }
            }
            catch (ModelException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
    }
}

