/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemfilter;

import javax.swing.JComponent;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.guiclient.model.item.itemfilter.ItemFilter;
import org.openbp.guiclient.model.item.itemfilter.ItemFilterHolder;
import org.openbp.jaspira.plugin.Plugin;

public abstract class AbstractItemFilter
extends DisplayObjectImpl
implements ItemFilter {
    private boolean active;
    private Plugin plugin;
    private ItemFilterHolder filterHolder;
    private ResourceCollection resourceCollection;
    private MultiIcon icon;

    public AbstractItemFilter() {
        this.setName(this.getClass().getName());
        this.resourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("guiclient", this.getClass());
        this.setDisplayName(this.resourceCollection.getRequiredString("title"));
        this.setDescription(this.resourceCollection.getOptionalString("description"));
        this.icon = (MultiIcon)this.resourceCollection.getRequiredObject("icon");
    }

    protected void apply() {
        if (this.filterHolder != null) {
            this.filterHolder.apply(this);
        }
    }

    public ResourceCollection getItemFilterResource() {
        return this.resourceCollection;
    }

    @Override
    public MultiIcon getIcon() {
        return this.icon;
    }

    @Override
    public JComponent getConfigurationComponent() {
        return null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.apply();
        }
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public ItemFilterHolder getFilterManager() {
        return this.filterHolder;
    }

    @Override
    public void setFilterHolder(ItemFilterHolder filterHolder) {
        this.filterHolder = filterHolder;
        if (filterHolder != null && this.plugin == null) {
            this.setPlugin(filterHolder.getPlugin());
        }
    }
}

