/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.openbp.common.CollectionUtil;
import org.openbp.core.model.item.Item;
import org.openbp.guiclient.model.item.itemfilter.AbstractItemFilter;

public class ItemTextFilter
extends AbstractItemFilter {
    private String[] patternList;
    private JPanel configurationComponent;
    private JTextField textField;

    @Override
    public boolean acceptsItem(Item item) {
        if (this.patternList == null) {
            return true;
        }
        String name = item.getName();
        String description = item.getDescription();
        String displayName = item.getDisplayName();
        for (int i = 0; i < this.patternList.length; ++i) {
            String pattern = this.patternList[i];
            if (this.match(name, pattern) || this.match(description, pattern) || this.match(displayName, pattern)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JComponent getConfigurationComponent() {
        if (this.configurationComponent == null) {
            this.textField = new JTextField();
            this.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ItemTextFilter.this.processFilterSettings();
                }
            });
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ItemTextFilter.this.processFilterSettings();
                }
            });
            JLabel label = new JLabel(this.getItemFilterResource().getRequiredString("pattern"));
            label.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.configurationComponent = new JPanel(new BorderLayout());
            this.configurationComponent.add((Component)label, "West");
            this.configurationComponent.add(this.textField);
        }
        return this.configurationComponent;
    }

    @Override
    public boolean isActive() {
        return this.patternList != null;
    }

    @Override
    public void setActive(boolean active) {
        if (!active && this.patternList != null) {
            this.patternList = null;
            this.textField.setText(null);
            this.apply();
        }
    }

    void processFilterSettings() {
        this.patternList = null;
        String text = this.textField.getText();
        if (text.length() != 0) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(text);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                list.add(token.toLowerCase());
            }
            this.patternList = CollectionUtil.toStringArray(list);
        }
        this.apply();
    }

    public boolean match(String text, String pattern) {
        if (text == null) {
            return false;
        }
        int tl = text.length();
        int pl = pattern.length();
        int n = tl - pl;
        for (int i = 0; i <= n; ++i) {
            if (!text.regionMatches(true, i, pattern, 0, pl)) continue;
            return true;
        }
        return false;
    }
}

