/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemfinder;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.ItemTypeDescriptor;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.itemfinder.DataTypeFinder;
import org.openbp.guiclient.model.item.itemfinder.Finder;
import org.openbp.guiclient.model.item.itemfinder.FinderEngine;
import org.openbp.guiclient.model.item.itemfinder.ModelFinder;
import org.openbp.guiclient.model.item.itemfinder.ProcessEntryFinder;
import org.openbp.guiclient.model.item.itemfinder.ProcessFinder;

public class FinderEngineImpl
implements FinderEngine {
    private final Hashtable finderMapp = new Hashtable();

    public FinderEngineImpl() {
        this.registerFinder("Process", (Finder)new ProcessFinder());
        this.registerFinder("Type", (Finder)new DataTypeFinder());
        this.registerFinder("Model", (Finder)new ModelFinder());
        this.registerFinder(InitialNode.class, (Finder)new ProcessEntryFinder());
    }

    @Override
    public void registerFinder(String itemType, Finder finder) {
        this.finderMapp.put(itemType, finder);
    }

    @Override
    public void registerFinder(ItemTypeDescriptor itemType, Finder finder) {
        this.registerFinder(itemType.getItemType(), finder);
    }

    @Override
    public void registerFinder(Class modelObjectClass, Finder finder) {
        this.finderMapp.put(modelObjectClass, finder);
    }

    @Override
    public List createReferenceList(ModelObject core, List modelList) {
        List modelsToSearch = new ArrayList();
        modelsToSearch = modelList == null ? this.createTopLevelModelList() : modelList;
        Finder finder = this.getFinder(core);
        if (finder == null) {
            return null;
        }
        return this.findReferences(finder, core, modelsToSearch);
    }

    private Finder getFinder(ModelObject core) {
        Class<?> coreClass = core.getClass();
        Enumeration e = this.finderMapp.keys();
        while (e.hasMoreElements()) {
            Class finderClass;
            Object obj = e.nextElement();
            if (!(obj instanceof Class) || !(finderClass = (Class)obj).isAssignableFrom(coreClass)) continue;
            return (Finder)this.finderMapp.get(finderClass);
        }
        return (Finder)this.finderMapp.get(core.getQualifier().getItemType());
    }

    private List findReferences(Finder finder, ModelObject obj, List modelList) {
        if (modelList.size() == 0) {
            return null;
        }
        ArrayList modelObjects = new ArrayList();
        for (int i = 0; i < modelList.size(); ++i) {
            Model model = (Model)modelList.get(i);
            modelObjects.addAll(finder.findModelObjectInModel(obj, model));
        }
        return modelObjects.size() == 0 ? null : modelObjects;
    }

    private List createTopLevelModelList() {
        return ModelConnector.getInstance().getModels();
    }
}

