/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.model.item.itemtree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.type.DataMember;
import org.openbp.guiclient.model.item.itemtree.ItemTree;

public class DataMemberTree
extends ItemTree {
    public DataMemberTree() {
        this.setSelectionMode(1);
        this.setRootVisible(true);
        this.setShowGroups(false);
        this.setSupportedItemTypes(new String[]{"Type"});
        this.setSupportedObjectClasses(new Class[]{DataMember.class});
        this.setSelectableItemTypes(null);
        this.setSelectableObjectClasses(new Class[]{DataMember.class});
    }

    @Override
    public List getSelectedObjects() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<String> list = null;
        for (int i = 0; i < paths.length; ++i) {
            ModelObject object;
            ItemTree.ItemTreeNode node = (ItemTree.ItemTreeNode)((Object)paths[i].getLastPathComponent());
            if (!(node instanceof ItemTree.ModelObjectNode) || !this.isSelectable(object = ((ItemTree.ModelObjectNode)node).getModelObject())) continue;
            String memberPath = this.determineNodePath(node);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(memberPath);
        }
        return list;
    }

    @Override
    public ItemTree.ItemTreeNode findNodeByObject(Object object, ItemTree.ItemTreeNode node) {
        String nodePath = this.determineNodePath(node);
        if (nodePath != null && nodePath.equals(object)) {
            return node;
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            ItemTree.ItemTreeNode child = (ItemTree.ItemTreeNode)((Object)node.getChildAt(i));
            ItemTree.ItemTreeNode ret = this.findNodeByObject(object, child);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    protected String determineNodePath(ItemTree.ItemTreeNode node) {
        ItemTree.ItemTreeNode rootNode = (ItemTree.ItemTreeNode)((Object)((DefaultTreeModel)this.getModel()).getRoot());
        StringBuffer sb = new StringBuffer();
        while (node != rootNode) {
            if (node instanceof ItemTree.ModelObjectNode) {
                ModelObject object = ((ItemTree.ModelObjectNode)node).getModelObject();
                String name = object.getName();
                if (sb.length() == 0) {
                    sb.append(name);
                } else {
                    sb.insert(0, ModelQualifier.OBJECT_DELIMITER);
                    sb.insert(0, name);
                }
            }
            node = (ItemTree.ItemTreeNode)((Object)node.getParent());
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

