/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.objectvalidators;

import java.util.Iterator;
import org.openbp.common.generic.msgcontainer.StandardMsgContainer;
import org.openbp.core.model.ModelObject;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.objectvalidators.DisplayObjectValidator;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;

public class ModelObjectValidator
extends DisplayObjectValidator {
    @Override
    public boolean validateObject(Object editedObject, PropertyBrowser pb) {
        if (!(editedObject instanceof ModelObject)) {
            return true;
        }
        ModelObject mo = (ModelObject)editedObject;
        StandardMsgContainer msgContainer = ModelConnector.getInstance().getMsgContainer();
        msgContainer.clearMsgs();
        mo.maintainReferences(40);
        ModelObjectValidator.checkNameUniqueness(mo, pb);
        if (!this.displayMsgContainer()) {
            return false;
        }
        return super.validateObject(editedObject, pb);
    }

    public static void checkNameUniqueness(ModelObject editedObject, PropertyBrowser pb) {
        ModelObject object = (ModelObject)pb.getObject();
        ModelObject originalObject = (ModelObject)pb.getOriginalObject();
        Iterator it = object.getContainerIterator();
        if (it == null) {
            return;
        }
        String name = editedObject.getName();
        while (it.hasNext()) {
            ModelObject element = (ModelObject)it.next();
            if (element == editedObject || element == object || element == originalObject || !name.equals(element.getName())) continue;
            element.getModelMgr().getMsgContainer().addMsg((Object)editedObject, "An element having this name already exists.");
            return;
        }
    }
}

