/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.objectvalidators;

import java.util.ArrayList;
import java.util.List;
import org.openbp.core.model.ModelImpl;
import org.openbp.core.model.ModelImportPBContainer;
import org.openbp.core.model.ModelQualifier;
import org.openbp.guiclient.objectvalidators.ModelObjectValidator;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;

public class ModelValidator
extends ModelObjectValidator {
    @Override
    public boolean validateObject(Object editedObject, PropertyBrowser pb) {
        int n;
        boolean ret = true;
        ModelImpl model = (ModelImpl)editedObject;
        ArrayList<String> importList = null;
        List containers = model.getImportPBContainerList();
        if (containers != null && (n = containers.size()) > 0) {
            importList = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                ModelImportPBContainer container = (ModelImportPBContainer)containers.get(i);
                String name = container.getName();
                if (name == null) continue;
                name = ModelQualifier.normalizeModelName((String)name);
                if (model.getModelMgr().getOptionalModelByQualifier(ModelQualifier.constructModelQualifier((String)name)) == null) {
                    this.displayErrorMsg("Cannot resolve model '" + name + "'.");
                    ret = false;
                }
                importList.add(name);
            }
        }
        if (!ret) {
            return false;
        }
        model.setImportList(importList);
        model.setImportPBContainerList(null);
        model.setImportContainerListCreated(false);
        return super.validateObject(editedObject, pb);
    }
}

