/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.propertyeditors;

import java.io.File;
import javax.swing.JFileChooser;
import org.openbp.common.string.StringUtil;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.jaspira.propertybrowser.editor.standard.PathEditor;
import org.openbp.jaspira.propertybrowser.editor.standard.PathEditorCustomizer;

public class ImagePathEditorCustomizer
extends PathEditorCustomizer {
    @Override
    public boolean initializeChooser(PathEditor editor, JFileChooser chooser, String[] pathRef) {
        String path;
        String modelPath = this.determineModelPath(editor);
        if (modelPath != null) {
            chooser.setCurrentDirectory(new File(modelPath));
        }
        if ((path = pathRef[0]) != null && modelPath != null) {
            if ((path = StringUtil.absolutePathName((String)path)).startsWith(modelPath + "/")) {
                pathRef[0] = path.substring(modelPath.length() + 1);
            } else {
                String tmp = modelPath + "/" + path;
                if (new File(tmp).exists()) {
                    pathRef[0] = tmp;
                }
            }
        }
        return true;
    }

    @Override
    public boolean chooserInitialized(PathEditor editor, JFileChooser chooser, String[] pathRef) {
        return true;
    }

    @Override
    public boolean chooserClosed(PathEditor editor, JFileChooser chooser, String[] pathRef) {
        String path = pathRef[0];
        if (path != null) {
            String modelPath = this.determineModelPath(editor);
            if (StringUtil.indexOfIgnoreCase((String)(path = StringUtil.absolutePathName((String)path)), (int)0, (String)(modelPath + "/")) == 0) {
                pathRef[0] = path.substring(modelPath.length() + 1);
            }
        }
        return true;
    }

    private String determineModelPath(PathEditor editor) {
        Model model;
        Object editedObject = editor.getObject();
        if (editedObject instanceof ModelObject && (model = ((ModelObject)editedObject).getOwningModel()) != null) {
            return model.getModelPath();
        }
        return null;
    }
}

