/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.remote;

import java.util.Hashtable;
import java.util.Set;
import org.openbp.client.remote.RemoteServiceFactory;
import org.openbp.core.OpenBPException;
import org.openbp.core.remote.ClientConnectionInfo;
import org.openbp.core.remote.ClientLoginInfo;
import org.openbp.core.remote.ClientSession;
import org.openbp.core.remote.ClientSessionService;
import org.openbp.core.remote.InvalidSessionException;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.swing.components.JMsgBox;

public final class ServerConnection {
    private RemoteServiceFactory remoteServiceFactory;
    private ClientConnectionInfo connectionInfo;
    private ClientLoginInfo loginInfo;
    private ClientSessionService sessionService;
    private Hashtable serviceCache = new Hashtable();
    private ClientSession session;
    public static boolean disableTimersForDebug;
    private static ServerConnection singletonInstance;

    public static synchronized ServerConnection getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ServerConnection();
        }
        return singletonInstance;
    }

    private ServerConnection() {
    }

    public ClientSession getSession() {
        return this.session;
    }

    public ClientConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(ClientConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public ClientLoginInfo getLoginInfo() {
        return this.loginInfo;
    }

    public void setLoginInfo(ClientLoginInfo loginInfo) {
        this.loginInfo = loginInfo;
    }

    public void connect(boolean throwError) {
        try {
            this.disconnect();
            if (this.connectionInfo == null) {
                this.connectionInfo = new ClientConnectionInfo();
            }
            this.connectionInfo.loadFromProperties();
            if (this.connectionInfo.isEnabled()) {
                if (this.remoteServiceFactory == null) {
                    this.remoteServiceFactory = RemoteServiceFactory.getInstance();
                }
                this.remoteServiceFactory.setConnectionInfo(this.connectionInfo);
                this.sessionService = (ClientSessionService)this.remoteServiceFactory.getService(ClientSessionService.class);
                if (this.loginInfo != null) {
                    this.session = this.sessionService.createSession(this.loginInfo);
                    if (!disableTimersForDebug) {
                        new ClientHeartBeat(3).start();
                    }
                }
            }
        }
        catch (Exception e) {
            throw OpenBPException.wrap((Throwable)e);
        }
    }

    public void disconnect() {
        this.remoteServiceFactory = null;
        this.sessionService = null;
        this.session = null;
        this.serviceCache.clear();
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public Object lookupService(Class serviceCls) {
        return this.obtainService(serviceCls, true);
    }

    public Object lookupOptionalService(Class serviceCls) {
        return this.obtainService(serviceCls, false);
    }

    public Object obtainService(Class serviceCls, boolean throwError) {
        Object service;
        block7: {
            Object cacheContent = this.serviceCache.get(serviceCls.getName());
            if (cacheContent == Boolean.FALSE) {
                if (throwError) {
                    throw new OpenBPException("ServerConnection.Unvavailable", "Service not available, try server reconnect.");
                }
                return null;
            }
            service = cacheContent;
            if (service == null) {
                if (this.remoteServiceFactory == null) {
                    if (throwError) {
                        throw new OpenBPException("ServerConnection.Unvavailable", "Service not available, try server reconnect.");
                    }
                    return null;
                }
                try {
                    service = this.remoteServiceFactory.getService(serviceCls);
                    this.serviceCache.put(serviceCls.getName(), service);
                }
                catch (OpenBPException e) {
                    this.serviceCache.put(serviceCls.getName(), Boolean.FALSE);
                    if (!throwError) break block7;
                    throw new OpenBPException("ServerConnection.Unvavailable", "Error obtaining service " + serviceCls.getName() + ".", (Throwable)e);
                }
            }
        }
        return service;
    }

    void fireEventSet(Set eventSet) {
        for (String eventName : eventSet) {
            JaspiraEventMgr.fireGlobalEvent(eventName);
        }
    }

    void handleInvalidSession(Exception exception) {
        this.disconnect();
        String msg = "The connection to the OpenBP Server has been lost. Cause:\n\n{0}\n\nEither the server was shut down or the session timed out.\nMake sure that the server is running and press the Reload button to reconnect.";
        JMsgBox.showFormat(null, (String)msg, (Object)exception, (int)0x40040001);
        JaspiraEventMgr.fireGlobalEvent("debugger.client.connectionlost");
    }

    private class ClientHeartBeat
    extends Thread {
        private long interval;

        public ClientHeartBeat(int interval) {
            super("Server event poller");
            this.interval = interval * 1000;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (ServerConnection.this.session != null) {
                block6: {
                    try {
                        Set eventSet = ServerConnection.this.sessionService.getSessionEvents(ServerConnection.this.session);
                        if (eventSet == null) break block6;
                        ServerConnection.this.fireEventSet(eventSet);
                    }
                    catch (InvalidSessionException e) {
                        ServerConnection.this.handleInvalidSession((Exception)((Object)e));
                        break;
                    }
                    catch (OpenBPException e) {
                        ServerConnection.this.handleInvalidSession((Exception)((Object)e));
                        break;
                    }
                }
                try {
                    ClientHeartBeat.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

