/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.test;

import java.util.ArrayList;
import java.util.List;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.application.Application;
import org.openbp.common.dump.Dumper;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptorMgr;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.GUIClientModule;
import org.openbp.guiclient.model.ModelConnector;

public class TestClient {
    public TestClient() {
        try {
            GUIClientModule.getInstance().initialize();
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((String)"OpenBP client initialization error", (Throwable)e);
            System.exit(1);
        }
    }

    private void process() {
        try {
            String testMode = null;
            testMode = "Children";
            Dumper dumper = new Dumper();
            if (testMode.equals("Children")) {
                Model model = ModelConnector.getInstance().getModelByQualifier(ModelQualifier.constructModelQualifier((String)"AddressBookDemo"));
                ArrayList<Model> l = new ArrayList<Model>();
                l.add(model);
                TestClient.showObjectList(l);
            }
            if (testMode.equals("ObjectDescriptor")) {
                try {
                    ObjectDescriptor od = ObjectDescriptorMgr.getInstance().getDescriptor(ProcessItem.class, 1);
                    dumper.dump((Object)od);
                }
                catch (XMLDriverException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    System.exit(3);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((Throwable)e);
            System.exit(3);
        }
    }

    private static void showObjectList(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object o = list.get(i);
            if (!TestClient.canDisplay(o)) continue;
            System.out.println(o.toString());
            if (!(o instanceof ModelObject)) continue;
            List subObjects = ((ModelObject)o).getChildren();
            TestClient.showObjectList(subObjects);
        }
    }

    private static boolean canDisplay(Object o) {
        Class<?> cls = o.getClass();
        return Model.class.isAssignableFrom(cls) || ProcessItem.class.isAssignableFrom(cls) || InitialNode.class.isAssignableFrom(cls);
    }

    public static void main(String[] args) {
        try {
            Application.setArguments((String[])args);
            TestClient tc = new TestClient();
            tc.process();
            System.exit(0);
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((Throwable)e);
            System.exit(1);
        }
    }
}

