/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.application.Application;
import org.openbp.common.dump.Dumper;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.core.model.item.type.ComplexTypeItemImpl;
import org.openbp.core.model.item.type.DataMember;
import org.openbp.core.model.item.type.DataMemberImpl;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.core.model.item.type.SimpleTypeItemImpl;
import org.openbp.guiclient.GUIClientModule;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserImpl;
import org.openbp.jaspira.propertybrowser.SaveStrategy;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class TestPropertyBrowser {
    public TestPropertyBrowser() {
        try {
            GUIClientModule.getInstance().initialize();
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((String)"OpenBP client initialization error", (Throwable)e);
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel("org.openbp.swing.plaf.sky.SkyLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (InstantiationException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            Application.setArguments((String[])args);
            new TestPropertyBrowser();
            TestFrame frame = new TestFrame();
            frame.setVisible(true);
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((Throwable)e);
            System.exit(1);
        }
    }

    static class TestFrame
    extends JFrame
    implements SaveStrategy {
        private PropertyBrowserImpl propertyBrowser;
        private SimpleBorder errorBorder;
        private JScrollPane scrollPane;
        static boolean on;

        public TestFrame() {
            super("Property Browser Test");
            this.setBounds(100, 100, 600, 400);
            this.errorBorder = new SimpleBorder(2, 2, 2, 2);
            this.errorBorder.setWidth(2);
            this.errorBorder.setColor(Color.RED);
            this.propertyBrowser = new PropertyBrowserImpl(this, null);
            JPanel cp = (JPanel)this.getContentPane();
            cp.setLayout(new BorderLayout());
            this.scrollPane = new JScrollPane((Component)((Object)this.propertyBrowser));
            JButton btn = new JButton("Border on/off");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean bl = on = !on;
                    if (on) {
                        TestFrame.this.scrollPane.setBorder((Border)TestFrame.this.errorBorder);
                    } else {
                        TestFrame.this.scrollPane.setBorder(null);
                    }
                }
            });
            cp.add("East", btn);
            cp.add("Center", this.scrollPane);
            cp.add("South", new JTextField());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            Object o = this.createTestObject();
            try {
                this.propertyBrowser.setObject(o, true);
            }
            catch (XMLDriverException e) {
                e.printStackTrace();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }

        private Object createTestObject() {
            SimpleTypeItemImpl stringType = new SimpleTypeItemImpl();
            stringType.setJavaClass(String.class);
            stringType.setClassName(String.class.getName());
            ComplexTypeItemImpl type = new ComplexTypeItemImpl();
            type.setName("TestType");
            type.setDisplayName("Test Type");
            type.setDescription("A test data type object");
            DataMemberImpl member = new DataMemberImpl();
            member.setName("Member1");
            member.setDisplayName("Member 1");
            member.setDescription("Data member #1");
            member.setTypeName("String");
            member.setDataType((DataTypeItem)stringType);
            member.setRequired(true);
            type.addMember((DataMember)member);
            member = new DataMemberImpl();
            member.setName("Member2");
            member.setDisplayName("Member 2");
            member.setDescription("Data member #2");
            member.setTypeName("String");
            member.setDataType((DataTypeItem)stringType);
            type.addMember((DataMember)member);
            member = new DataMemberImpl();
            member.setName("Member3");
            member.setDisplayName("Member 3");
            member.setDescription("Data member #3");
            member.setTypeName("String");
            member.setDataType((DataTypeItem)stringType);
            type.addMember((DataMember)member);
            member = new DataMemberImpl();
            member.setName("Member4");
            member.setDisplayName("Member 4");
            member.setDescription("Data member #4");
            member.setTypeName("String");
            member.setDataType((DataTypeItem)stringType);
            type.addMember((DataMember)member);
            return type;
        }

        @Override
        public boolean executeSave(PropertyBrowser editor) {
            Object modObject = editor.getModifiedObject();
            Dumper dumper = new Dumper();
            dumper.dump(modObject);
            return true;
        }
    }
}

