/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.guiclient.util;

import org.openbp.common.generic.description.DisplayObject;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.activity.ActivityParam;
import org.openbp.core.model.item.activity.ActivityParamImpl;
import org.openbp.core.model.item.activity.ActivitySocket;
import org.openbp.core.model.item.activity.ActivitySocketImpl;
import org.openbp.core.model.item.type.DataTypeItem;

public class ActivityBuilderUtil {
    public static final int MAKESOCKET_ENTRY = 1;
    public static final int MAKESOCKET_DEFAULT = 2;
    public static final int MAKESOCKET_ARRANGE = 4;

    private ActivityBuilderUtil() {
    }

    public static boolean makeSocket(ActivityItem item, String socketName, int flags, ActivityParam[] newParamList) {
        boolean arrangeSocket;
        boolean update = false;
        ActivitySocket socket = item.getSocketByName(socketName);
        if (socket == null) {
            socket = new ActivitySocketImpl();
            socket.setName(socketName);
            item.addSocket(socket);
            update = true;
        }
        boolean entrySocket = (flags & 1) != 0;
        boolean defaultSocket = (flags & 2) != 0;
        boolean bl = arrangeSocket = (flags & 4) != 0;
        if (socket.isEntrySocket() != entrySocket) {
            socket.setEntrySocket(entrySocket);
            update = true;
        }
        if (socket.isDefaultSocket() != defaultSocket) {
            socket.setDefaultSocket(defaultSocket);
            update = true;
        }
        if (arrangeSocket && socket.getGeometry() != null) {
            socket.setGeometry(null);
        }
        if (newParamList != null) {
            for (int i = 0; i < newParamList.length; ++i) {
                ActivityParam newParam = newParamList[i];
                ActivityParam param = socket.getParamByName(newParam.getName());
                if (param != null) {
                    if (param.getDataType() == newParam.getDataType()) continue;
                    param.setDataType(newParam.getDataType());
                    update = true;
                    continue;
                }
                socket.addParam(newParam);
                update = true;
            }
        }
        return update;
    }

    public static boolean removeSocket(ActivityItem item, String socketName) {
        ActivitySocket socket = item.getSocketByName(socketName);
        if (socket != null) {
            item.removeSocket(socket);
            return true;
        }
        return false;
    }

    public static ActivityParam makeParam(String name, String displayName, String description, DataTypeItem type, boolean optional) {
        ActivityParamImpl param = new ActivityParamImpl();
        param.setName(name);
        param.setDisplayName(displayName);
        param.setDescription(description);
        param.setDataType(type);
        param.setOptional(optional);
        return param;
    }

    public static ActivityParam makeParam(DisplayObject dob, DataTypeItem type, boolean optional) {
        ActivityParamImpl param = new ActivityParamImpl();
        param.setName(dob.getName());
        param.setDisplayName(dob.getDisplayName());
        param.setDescription(dob.getDescription());
        param.setDataType(type);
        param.setOptional(optional);
        return param;
    }
}

