/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.openbp.common.CollectionUtil;
import org.openbp.common.CommonUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.listener.BeanListenerSupport;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionUtil;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.action.JaspiraMenu;
import org.openbp.jaspira.action.JaspiraMenuItem;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.action.JaspiraToolbarButton;
import org.openbp.jaspira.action.JaspiraToolbarCombo;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.Plugin;

public class JaspiraAction
extends DisplayObjectImpl
implements Action {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_DISABLED_ICON = "disabledicon";
    public static final String PROPERTY_SEQUENCE = "sequence";
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_PRIO = "prio";
    public static final String PROPERTY_SCOPE = "scope";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_MENU_PARENT = "menuparent";
    public static final String PROPERTY_TOOLBAR_PARENT = "toolbarparent";
    public static final String PROPERTY_PAGE_NAMES = "pagenames";
    public static final String PROPERTY_CONDITION = "condition";
    public static final String MENU_ROOT = "menuroot";
    public static final String TOOLBAR_ROOT = "toolbarroot";
    public static final String TYPE_ACTION = "action";
    public static final String TYPE_COMBO = "combo";
    public static final String TYPE_MENU = "menu";
    public static final String TYPE_GROUP = "group";
    public static final String KEY_SEQUENCE_DELIM = ",";
    public static final int DFLT_PRIORITY = 50;
    public static final String MNEMONIC_DELIMITER = "_";
    private ResourceCollection actionResourceCollection;
    private MultiIcon icon;
    private MultiIcon disabledIcon;
    private int mnemonicpos;
    private KeySequence[] keySequences;
    private boolean enabled = true;
    private boolean selected;
    private int priority;
    private String condition;
    private String type;
    private String[] pageNames;
    private transient SortedSet menuchildren;
    private transient SortedSet toolbarchildren;
    private transient Map values;
    private int scope;
    private int counter;
    private static Comparator priorityComparator = new PriorityComparator();
    private BeanListenerSupport listenerSupport;

    public JaspiraAction(Plugin owner, String name) {
        this(owner.getPluginResourceCollection(), name);
    }

    public JaspiraAction(ResourceCollection res, String name) {
        super(name);
        String pageNameStr;
        String keys;
        this.actionResourceCollection = res;
        ResourceCollectionUtil.loadDisplayObjectFromResource((DisplayObject)this, (ResourceCollection)res, (String)name);
        this.checkForMnemonic();
        this.icon = (MultiIcon)this.getActionProperty(PROPERTY_ICON);
        this.disabledIcon = (MultiIcon)this.getActionProperty(PROPERTY_DISABLED_ICON);
        this.enabled = this.getActionPropertyBoolean(PROPERTY_ENABLED, true);
        this.selected = this.getActionPropertyBoolean(PROPERTY_SELECTED, false);
        this.type = this.getActionPropertyString(PROPERTY_TYPE, TYPE_ACTION);
        this.priority = this.getActionPropertyInt(PROPERTY_PRIO, 50);
        this.condition = this.getActionPropertyString(PROPERTY_CONDITION);
        String scopeStr = this.getActionPropertyString(PROPERTY_SCOPE);
        this.scope = 0;
        if (scopeStr != null) {
            if (scopeStr.equals("application")) {
                this.scope = 0;
            } else if (scopeStr.equals("frame")) {
                this.scope = 1;
            } else if (scopeStr.equals("page")) {
                this.scope = 2;
            } else if (scopeStr.equals("plugin")) {
                this.scope = 3;
            } else {
                LogUtil.warn(this.getClass(), (String)"Invalid value for scope of action $0 in resource $1.", (Object)name, (Object)res.getErrorName());
            }
        }
        if ((keys = this.getActionPropertyString(PROPERTY_SEQUENCE)) != null) {
            StringTokenizer sto = new StringTokenizer(keys, KEY_SEQUENCE_DELIM);
            this.keySequences = new KeySequence[sto.countTokens()];
            int i = 0;
            while (sto.hasMoreTokens()) {
                this.keySequences[i] = new KeySequence(sto.nextToken());
                ++i;
            }
        }
        if ((pageNameStr = this.getActionPropertyString(PROPERTY_PAGE_NAMES)) != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(pageNameStr, ", ", false);
            while (st.hasMoreTokens()) {
                String pageName = st.nextToken();
                list.add(pageName);
            }
            this.pageNames = CollectionUtil.toStringArray(list);
        }
    }

    public JaspiraAction(String name, String displayName, String description, MultiIcon icon, KeySequence[] keySequences, int priority, String type) {
        super(name, displayName, description);
        this.icon = icon;
        this.keySequences = keySequences;
        this.priority = priority;
        this.type = type;
        this.checkForMnemonic();
    }

    public JaspiraAction(DisplayObject obj) {
        try {
            this.copyFrom(obj, 2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.priority = 50;
        this.type = TYPE_ACTION;
        this.checkForMnemonic();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.type.equals(TYPE_ACTION) || this.type.equals(TYPE_COMBO)) {
            VisiblePlugin focusedPlugin = PluginFocusMgr.getInstance().getFocusedPlugin();
            if (focusedPlugin != null) {
                focusedPlugin.fireEvent(new JaspiraActionEvent((Plugin)focusedPlugin, this.getName(), ae, this.scope));
            } else {
                JaspiraEventMgr.fireGlobalEvent(new JaspiraActionEvent(null, this.getName(), ae, this.scope));
            }
        }
    }

    public JComponent toComponent() {
        return null;
    }

    public JComponent toToolBarComponent() {
        return this.toToolBarComponent(null);
    }

    public JComponent toToolBarComponent(String currentPageName) {
        if (this.type.equals(TYPE_ACTION)) {
            return new JaspiraToolbarButton(this);
        }
        if (this.type.equals(TYPE_COMBO)) {
            return new JaspiraToolbarCombo(this);
        }
        if (this.toolbarchildren == null || this.toolbarchildren.isEmpty()) {
            return null;
        }
        JaspiraToolbar bar = null;
        for (JaspiraAction childAction : this.toolbarchildren) {
            if (childAction == null || currentPageName != null && !childAction.matchesPageName(currentPageName)) continue;
            if (bar == null) {
                bar = new JaspiraToolbar();
            }
            bar.add(childAction.toToolBarComponent(currentPageName));
        }
        return bar;
    }

    public JMenuItem toMenuItem() {
        return this.toMenuItem(null);
    }

    public JMenuItem toMenuItem(String currentPageName) {
        if (this.type.equals(TYPE_ACTION)) {
            return new JaspiraMenuItem(this);
        }
        if (this.type.equals(TYPE_MENU)) {
            if (this.menuchildren == null || this.menuchildren.isEmpty()) {
                return null;
            }
            JaspiraMenu menu = null;
            Iterator it = this.menuchildren.iterator();
            while (it.hasNext()) {
                JaspiraAction childAction = (JaspiraAction)it.next();
                if (childAction == null || currentPageName != null && !childAction.matchesPageName(currentPageName)) continue;
                if (childAction.getType().equals(TYPE_GROUP)) {
                    if (childAction.getMenuchildren() == null) continue;
                    for (JaspiraAction childAction2 : childAction.getMenuchildren()) {
                        if (currentPageName != null && !childAction2.matchesPageName(currentPageName)) continue;
                        JMenuItem menuItem = childAction2.toMenuItem(currentPageName);
                        if (menu == null) {
                            menu = new JaspiraMenu(this);
                        }
                        menu.add(menuItem);
                    }
                } else {
                    JMenuItem menuItem = childAction.toMenuItem(currentPageName);
                    if (menu == null) {
                        menu = new JaspiraMenu(this);
                    }
                    menu.add(menuItem);
                }
                if (!it.hasNext() || menu == null) continue;
                menu.addSeparator();
            }
            return menu;
        }
        return null;
    }

    public boolean matchesPageName(String currentPageName) {
        if (this.pageNames == null) {
            return true;
        }
        if (currentPageName != null) {
            for (int i = 0; i < this.pageNames.length; ++i) {
                if (!currentPageName.equals(this.pageNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void checkForMnemonic() {
        String title = this.getDisplayName();
        if (title == null) {
            this.mnemonicpos = -1;
            return;
        }
        this.mnemonicpos = title.indexOf(MNEMONIC_DELIMITER);
        if (this.mnemonicpos != -1) {
            this.setDisplayName(title.substring(0, this.mnemonicpos) + title.substring(this.mnemonicpos + 1));
        }
    }

    public int getMnemonicPos() {
        return this.mnemonicpos;
    }

    public boolean isMnemonic() {
        return this.mnemonicpos != -1;
    }

    public char getMnemonicChar() {
        if (this.isMnemonic()) {
            return this.getDisplayName().charAt(this.mnemonicpos);
        }
        return '\u0000';
    }

    public ResourceCollection getActionResource() {
        return this.actionResourceCollection;
    }

    public SortedSet getMenuchildren() {
        return this.menuchildren;
    }

    public void addMenuChild(JaspiraAction action) {
        if (this.menuchildren == null) {
            this.menuchildren = new TreeSet(priorityComparator);
        }
        this.menuchildren.add(action);
    }

    protected void removeMenuChild(JaspiraAction action) {
        if (this.menuchildren != null) {
            this.menuchildren.remove(action);
        }
    }

    public SortedSet getToolbarchildren() {
        return this.toolbarchildren;
    }

    public void addToolbarChild(JaspiraAction action) {
        if (this.toolbarchildren == null) {
            this.toolbarchildren = new TreeSet(priorityComparator);
        }
        this.toolbarchildren.add(action);
    }

    protected void removeToolbarChild(JaspiraAction action) {
        if (this.toolbarchildren != null) {
            this.toolbarchildren.remove(action);
        }
    }

    public String[] getPageNames() {
        return this.pageNames;
    }

    public void setPageNames(String[] pageNames) {
        this.pageNames = pageNames;
    }

    public String getType() {
        return this.type;
    }

    public MultiIcon getIcon() {
        return this.icon;
    }

    public void setIcon(MultiIcon icon) {
        if (this.icon != icon) {
            MultiIcon old = this.icon;
            this.icon = icon;
            this.firePropertyChange(PROPERTY_ICON, old, icon);
        }
    }

    public MultiIcon getDisabledIcon() {
        return this.disabledIcon;
    }

    public void setDisabledIcon(MultiIcon disabledIcon) {
        if (this.disabledIcon != disabledIcon) {
            MultiIcon old = this.disabledIcon;
            this.disabledIcon = disabledIcon;
            this.firePropertyChange(PROPERTY_DISABLED_ICON, old, this.icon);
        }
    }

    public KeySequence[] getKeySequences() {
        return this.keySequences;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            Boolean old = this.enabled;
            this.enabled = enabled;
            this.firePropertyChange(PROPERTY_ENABLED, old, enabled);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDisplayName(String displayName) {
        String oldValue = this.getDisplayName();
        if (!CommonUtil.equalsNull((Object)displayName, (Object)oldValue)) {
            super.setDisplayName(displayName);
            this.firePropertyChange(PROPERTY_DISPLAY_NAME, oldValue, displayName);
        }
    }

    public void setDescription(String description) {
        String oldValue = this.getDescription();
        if (!CommonUtil.equalsNull((Object)description, (Object)oldValue)) {
            super.setDescription(description);
            this.firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
        }
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            Boolean old = this.selected;
            this.selected = selected;
            this.firePropertyChange(PROPERTY_SELECTED, old, selected);
        }
        this.selected = selected;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getCondition() {
        return this.condition;
    }

    public int getCounter() {
        return this.counter;
    }

    public void increaseCounter() {
        ++this.counter;
    }

    public boolean decreaseCounter() {
        return --this.counter > 0;
    }

    @Override
    public Object getValue(String key) {
        if (this.values != null) {
            return this.values.get(key);
        }
        return null;
    }

    @Override
    public void putValue(String key, Object value) {
        if (this.values == null) {
            this.values = new HashMap();
        }
        Object oldValue = this.values.put(key, value);
        this.firePropertyChange(key, oldValue, value);
    }

    public void clearValues() {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public Object getActionProperty(String key) {
        Object value = this.getValue(key);
        if (value == null && this.actionResourceCollection != null) {
            StringBuffer sb = new StringBuffer();
            if (this.getName() != null) {
                sb.append(this.getName());
            }
            sb.append('.');
            sb.append(key);
            String propKey = sb.toString();
            value = this.actionResourceCollection.getOptionalObject(propKey);
        }
        return value;
    }

    public String getActionPropertyString(String key) {
        Object value = this.getActionProperty(key);
        if (value != null && !(value instanceof String)) {
            System.err.println("Action property " + this.getName() + "." + key + " is not a string.");
            return null;
        }
        return (String)value;
    }

    public String getActionPropertyString(String key, String dflt) {
        String value = this.getActionPropertyString(key);
        if (value == null) {
            value = dflt;
        }
        return value;
    }

    public boolean getActionPropertyBoolean(String key, boolean dflt) {
        Object value = this.getActionProperty(key);
        boolean ret = dflt;
        if (value != null) {
            if (value instanceof Boolean) {
                ret = (Boolean)value;
            } else if (value instanceof String) {
                String s = (String)value;
                if ("false".equals(s)) {
                    ret = false;
                } else if ("true".equals(s)) {
                    ret = false;
                } else {
                    System.err.println("Action property " + this.getName() + "." + key + " is not a boolean.");
                }
            } else {
                System.err.println("Action property " + this.getName() + "." + key + " is not a boolean.");
            }
        }
        return ret;
    }

    public int getActionPropertyInt(String key, int dflt) {
        Object value = this.getActionProperty(key);
        int ret = dflt;
        if (value != null) {
            if (value instanceof Integer) {
                ret = (Integer)value;
            } else if (value instanceof String) {
                try {
                    ret = Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Action property " + this.getName() + "." + key + " is not an integer.");
                }
            } else {
                System.err.println("Action property " + this.getName() + "." + key + " is not an integer.");
            }
        }
        return ret;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listenerSupport != null && this.listenerSupport.containsListeners(PropertyChangeListener.class) && !CommonUtil.equalsNull((Object)oldValue, (Object)newValue)) {
            this.listenerSupport.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new BeanListenerSupport();
        }
        this.listenerSupport.addWeakListener(PropertyChangeListener.class, (EventListener)listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(PropertyChangeListener.class, (EventListener)listener);
        }
    }

    private static class PriorityComparator
    implements Comparator {
        private PriorityComparator() {
        }

        public int compare(Object o1, Object o2) {
            String n2;
            JaspiraAction a1 = (JaspiraAction)o1;
            JaspiraAction a2 = (JaspiraAction)o2;
            int result = a1.getPriority() - a2.getPriority();
            if (result != 0) {
                return result;
            }
            String n1 = a1.getDisplayName();
            if (n1 == null) {
                n1 = a1.getName();
            }
            if ((n2 = a2.getDisplayName()) == null) {
                n2 = a2.getName();
            }
            return n1.compareTo(n2);
        }
    }
}

