/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import org.openbp.common.icon.FlexibleSize;
import org.openbp.common.icon.MultiIcon;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.swing.AdvancedAccelerator;

public class JaspiraMenuItem
extends JMenuItem
implements FlexibleSize,
PropertyChangeListener,
HierarchyListener,
AdvancedAccelerator {
    private JaspiraAction action;
    private MultiIcon icon;

    public JaspiraMenuItem(JaspiraAction action) {
        this.action = action;
        this.copyFromAction(null);
        action.addPropertyChangeListener(this);
        this.addActionListener(action);
        this.icon = action.getIcon();
        if (this.icon != null) {
            this.setIcon(this.icon.getIcon(16));
        }
    }

    private void copyFromAction(String propertyName) {
        if (propertyName == null || propertyName.equals("name")) {
            this.setActionCommand(this.action.getName());
        }
        if (propertyName == null || propertyName.equals("displayName")) {
            this.setText(this.action.getDisplayName());
        }
        if (propertyName == null || propertyName.equals("description")) {
            this.setToolTipText(this.action.getDescription());
        }
        if (propertyName == null || propertyName.equals("enabled")) {
            this.setEnabled(this.action.isEnabled());
        }
        if (propertyName == null || propertyName.equals("selected")) {
            this.setSelected(this.action.isSelected());
        }
        if (propertyName == null && this.action.isMnemonic()) {
            this.setMnemonic(this.action.getMnemonicChar());
            this.setDisplayedMnemonicIndex(this.action.getMnemonicPos());
        }
    }

    public String getAcceleratorString() {
        KeySequence[] ks = this.action.getKeySequences();
        if (ks != null && ks.length > 0) {
            return ks[0].toString();
        }
        return null;
    }

    public JaspiraAction getJaspiraAction() {
        return this.action;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (!this.isShowing()) {
            this.action.removePropertyChangeListener(this);
        } else {
            this.action.addPropertyChangeListener(this);
        }
    }

    public int getIconSize() {
        if (this.icon == null) {
            return 16;
        }
        return this.icon.getIconSize();
    }

    public void setIconSize(int size) {
        if (this.icon != null) {
            this.icon.setIconSize(size);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.copyFromAction(evt.getPropertyName());
    }
}

