/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action.keys;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.jaspira.action.keys.KeyTree;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.event.KeySequenceEvent;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugins.statusbar.StatusBarTextEvent;

public final class KeyMgr {
    public static final String ESCAPE = "escape";
    private static KeyMgr singleton;
    private static final Map keyCodes;
    private static final Map keyStrings;
    private KeyTree rootTree;
    private KeyTree currentTree;
    private Action resetAction;
    private Timer resetTimer;
    private List clients;
    private int updateSuspendLevel;
    private boolean performUpdate;

    private KeyMgr() {
        this.currentTree = this.rootTree = new KeyTree();
        this.clients = new ArrayList(4);
        this.resetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyMgr.this.resetTimer.stop();
                JaspiraEventMgr.fireGlobalEvent(new StatusBarTextEvent(null, null));
                KeyMgr.this.currentTree = KeyMgr.this.rootTree;
                KeyMgr.this.resetClients();
            }
        };
        this.resetTimer = new Timer(3000, this.resetAction);
    }

    public static int stringToKeyCode(String keyName) {
        Integer value = (Integer)keyCodes.get(keyName.toUpperCase());
        return value != null ? value : -1;
    }

    public static String keyCodeToString(int keyCode) {
        String result = (String)keyStrings.get(new Integer(keyCode));
        return result != null ? result.toUpperCase() : null;
    }

    public static synchronized KeyMgr getInstance() {
        if (singleton == null) {
            singleton = new KeyMgr();
        }
        return singleton;
    }

    public void install(JComponent c) {
        this.clients.add(c);
        new MultiInputMap(c);
        new MultiActionMap(c);
    }

    public void uninstall(JComponent c) {
        this.clients.remove(c);
        ((MultiActionMap)c.getActionMap()).uninstall(c);
        ((MultiInputMap)c.getInputMap(2)).uninstall();
    }

    public void suspendUpdate() {
        ++this.updateSuspendLevel;
    }

    public void resumeUpdate() {
        if (--this.updateSuspendLevel <= 0 && this.performUpdate) {
            this.resetClients();
            this.performUpdate = false;
        }
    }

    public void addSequences(Iterator sequences) {
        while (sequences.hasNext()) {
            KeySequence ks = (KeySequence)sequences.next();
            this.rootTree.addSequence(ks);
        }
        this.resetClients();
    }

    public void removeSequences(Iterator sequences) {
        while (sequences.hasNext()) {
            KeySequence ks = (KeySequence)sequences.next();
            this.rootTree.removeSequence(ks);
        }
        this.resetClients();
    }

    public void addSequence(KeySequence sequence) {
        this.rootTree.addSequence(sequence);
        this.resetClients();
    }

    public void removeSequence(KeySequence sequence) {
        this.rootTree.removeSequence(sequence);
        this.resetClients();
    }

    void resetClients() {
        if (this.updateSuspendLevel <= 0) {
            for (JComponent next : this.clients) {
                next.setInputMap(2, next.getInputMap(2));
            }
        } else {
            this.performUpdate = true;
        }
    }

    static {
        keyCodes = new HashMap();
        keyStrings = new HashMap();
        try {
            Field[] fields = KeyEvent.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.getName().startsWith("VK_")) continue;
                String name = field.getName().substring(3);
                Integer value = new Integer(field.getInt(null));
                keyCodes.put(name, value);
                keyStrings.put(value, name);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public class MultiActionMap
    extends ActionMap {
        private ActionMap parent;

        public MultiActionMap(JComponent component) {
            this.parent = component.getActionMap();
            if (this.parent != null) {
                this.parent = new ActionMap();
            }
            component.setActionMap(this);
        }

        public void uninstall(JComponent component) {
            ActionMap am = component.getActionMap();
            if (am instanceof MultiActionMap) {
                component.setActionMap(((MultiActionMap)am).parent);
            }
        }

        @Override
        public Action get(Object key) {
            if (key instanceof KeyTree) {
                return new KeyAction((KeyTree)key);
            }
            if (KeyMgr.ESCAPE.equals(key)) {
                return KeyMgr.this.resetAction;
            }
            return this.parent.get(key);
        }

        @Override
        public Object[] allKeys() {
            if (this.parent.size() == 0) {
                return KeyMgr.this.currentTree.subTrees();
            }
            if (!KeyMgr.this.currentTree.hasChildren()) {
                return this.keys();
            }
            HashSet<Object> set = new HashSet<Object>();
            KeyTree[] keys = KeyMgr.this.currentTree.subTrees();
            for (int i = keys.length - 1; i >= 0; --i) {
                set.add(keys[i]);
            }
            Object[] parentKeys = this.parent.keys();
            for (int i = parentKeys.length - 1; i >= 0; --i) {
                set.add(parentKeys[i]);
            }
            set.add(KeyMgr.ESCAPE);
            Object[] allKeys = new Object[set.size()];
            return set.toArray(allKeys);
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public ActionMap getParent() {
            return this.parent.getParent();
        }

        @Override
        public Object[] keys() {
            return this.parent.keys();
        }

        @Override
        public void put(Object key, Action action) {
            this.parent.put(key, action);
        }

        @Override
        public void remove(Object key) {
            this.parent.remove(key);
        }

        @Override
        public void setParent(ActionMap map) {
            this.parent.setParent(map);
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }

    public class MultiInputMap
    extends ComponentInputMap {
        private ComponentInputMap parent;

        public MultiInputMap(JComponent component) {
            super(component);
            this.parent = (ComponentInputMap)component.getInputMap(2);
            if (this.parent == null) {
                this.parent = new ComponentInputMap(component);
            }
            component.setInputMap(2, this);
        }

        public void uninstall() {
            JComponent component = this.getComponent();
            InputMap im = component.getInputMap(2);
            if (im instanceof MultiInputMap) {
                component.setInputMap(2, ((MultiInputMap)im).parent);
            }
        }

        @Override
        public Object get(KeyStroke keyStroke) {
            KeyTree value = KeyMgr.this.currentTree.getSubTree(keyStroke);
            if (value != null) {
                return value;
            }
            if (keyStroke.equals(KeyStroke.getKeyStroke(27, 0))) {
                return KeyMgr.ESCAPE;
            }
            return this.parent.get(keyStroke);
        }

        @Override
        public KeyStroke[] allKeys() {
            if (this.parent.size() == 0) {
                return KeyMgr.this.currentTree.keys();
            }
            if (!KeyMgr.this.currentTree.hasChildren()) {
                return this.parent.keys();
            }
            HashSet<KeyStroke> set = new HashSet<KeyStroke>();
            KeyStroke[] keys = KeyMgr.this.currentTree.keys();
            for (int i = keys.length - 1; i >= 0; --i) {
                set.add(keys[i]);
            }
            KeyStroke[] parentKeys = this.parent.keys();
            for (int i = parentKeys.length - 1; i >= 0; --i) {
                set.add(parentKeys[i]);
            }
            if (KeyMgr.this.currentTree != KeyMgr.this.rootTree) {
                set.add(KeyStroke.getKeyStroke(27, 0));
            }
            KeyStroke[] allKeys = new KeyStroke[set.size()];
            return set.toArray(allKeys);
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public JComponent getComponent() {
            return this.parent.getComponent();
        }

        @Override
        public InputMap getParent() {
            return this.parent.getParent();
        }

        @Override
        public KeyStroke[] keys() {
            return this.parent.keys();
        }

        @Override
        public void put(KeyStroke keyStroke, Object actionMapKey) {
            this.parent.put(keyStroke, actionMapKey);
        }

        @Override
        public void remove(KeyStroke key) {
            this.parent.remove(key);
        }

        @Override
        public void setParent(InputMap map) {
            this.parent.setParent(map);
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }

    public class KeyAction
    extends AbstractAction {
        private KeyTree tree;

        public KeyAction(KeyTree tree) {
            this.tree = tree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyMgr.this.currentTree = this.tree;
            KeySequence sequence = this.tree.getSequence();
            Plugin plugin = PluginFocusMgr.getInstance().getFocusedPlugin();
            if (plugin == null) {
                plugin = ApplicationBase.getInstance();
            }
            KeySequenceEvent event = new KeySequenceEvent(plugin, sequence, 1);
            plugin.fireEvent(event);
            if (!event.isConsumed()) {
                event = new KeySequenceEvent(plugin, sequence, 2);
                plugin.fireEvent(event);
            }
            if (KeyMgr.this.currentTree.hasChildren()) {
                if (KeyMgr.this.resetTimer.isRunning()) {
                    KeyMgr.this.resetTimer.restart();
                } else {
                    KeyMgr.this.resetTimer.start();
                }
                JaspiraEventMgr.fireGlobalEvent(new StatusBarTextEvent(null, sequence.toString()));
                KeyMgr.this.resetClients();
            } else {
                KeyMgr.this.resetAction.actionPerformed(e);
            }
        }
    }
}

