/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action.keys;

import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.openbp.jaspira.action.keys.KeyMgr;

public class KeySequence {
    public static final char SHORT_DELIM = '-';
    public static final String SHORT_SHIFT = "S";
    public static final String SHORT_CTRL = "C";
    public static final String SHORT_ALT = "A";
    public static final char LONG_DELIM = '+';
    public static final String LONG_SHIFT = "SHIFT";
    public static final String LONG_CTRL = "CTRL";
    public static final String LONG_ALT = "ALT";
    private String sequenceString;
    private KeyStroke[] keys;

    public KeySequence(String sequence) {
        if (sequence == null) {
            this.keys = new KeyStroke[0];
        } else {
            StringBuffer string = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(sequence);
            this.keys = new KeyStroke[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                if (i > 0) {
                    string.append(' ');
                }
                this.keys[i] = KeySequence.stringToKey(tok.nextToken());
                string.append(KeySequence.keyToString(this.keys[i], true));
                ++i;
            }
            this.sequenceString = string.toString();
        }
    }

    private KeySequence(KeySequence source, int start, int size) {
        StringBuffer string = new StringBuffer();
        this.keys = new KeyStroke[size];
        for (int i = 0; i < size; ++i) {
            if (string.length() > 0) {
                string.append(' ');
            }
            this.keys[i] = source.keys[i + start];
            string.append(KeySequence.keyToString(this.keys[i], true));
        }
        this.sequenceString = string.toString();
    }

    public int length() {
        return this.keys.length;
    }

    public KeyStroke getKeyAt(int n) {
        return this.keys[n];
    }

    public KeySequence getSubSequence(int n) {
        return new KeySequence(this, 0, n);
    }

    public KeySequence getSequenceTail() {
        return new KeySequence(this, 1, this.length() - 1);
    }

    public String toString() {
        return this.sequenceString;
    }

    public boolean equals(Object obj) {
        return obj instanceof KeySequence && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static KeyStroke stringToKey(String string) {
        String keyString;
        int index = string.lastIndexOf(45);
        int modifiers = 0;
        if (index != -1) {
            String modString = string.substring(0, index);
            if (modString.indexOf(SHORT_CTRL) != -1) {
                modifiers += 2;
            }
            if (modString.indexOf(SHORT_SHIFT) != -1) {
                ++modifiers;
            }
            if (modString.indexOf(SHORT_ALT) != -1) {
                modifiers += 8;
            }
            keyString = string.substring(index + 1);
        } else {
            keyString = string;
        }
        return KeyStroke.getKeyStroke(KeyMgr.stringToKeyCode(keyString), modifiers, true);
    }

    public static String keyToString(KeyStroke key, boolean longForm) {
        char delim = longForm ? (char)'+' : '-';
        StringBuffer result = new StringBuffer();
        int modifiers = key.getModifiers();
        if ((modifiers & 8) != 0) {
            result.append(longForm ? LONG_ALT : SHORT_ALT);
            result.append(delim);
        }
        if ((modifiers & 2) != 0) {
            result.append(longForm ? LONG_CTRL : SHORT_CTRL);
            result.append(delim);
        }
        if ((modifiers & 1) != 0) {
            result.append(longForm ? LONG_SHIFT : SHORT_SHIFT);
            result.append(delim);
        }
        result.append(KeyMgr.keyCodeToString(key.getKeyCode()));
        return result.toString();
    }
}

