/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.event;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventListener;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.plugin.EventModule;

public final class JaspiraEventMgr {
    private static JaspiraEventMgr singletonInstance;
    private Map nativePreTable = new HashMap();
    private Map foreignPreTable = new HashMap();
    private Map nativePostTable = new HashMap();
    private Map foreignPostTable = new HashMap();
    public static Comparator moduleComparator;

    private JaspiraEventMgr() {
    }

    public static synchronized JaspiraEventMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new JaspiraEventMgr();
        }
        return singletonInstance;
    }

    public static boolean fireGlobalEvent(JaspiraEvent je) {
        return ApplicationBase.getInstance().fireEvent(je);
    }

    public static boolean fireGlobalEvent(String eventname) {
        return ApplicationBase.getInstance().fireEvent(eventname);
    }

    public static boolean fireGlobalEvent(String eventname, Object data) {
        return ApplicationBase.getInstance().fireEvent(eventname, data);
    }

    public boolean preHandleEvent(JaspiraEvent je) {
        return this.handleEvent(je, this.nativePreTable, this.foreignPreTable);
    }

    public boolean postHandleEvent(JaspiraEvent je) {
        return this.handleEvent(je, this.nativePostTable, this.foreignPostTable);
    }

    private boolean handleEvent(JaspiraEvent je, Map nativeTable, Map foreignTable) {
        Iterator it;
        Set modules = (Set)nativeTable.get(je.getEventGroup());
        if (modules != null) {
            it = modules.iterator();
            while (it.hasNext()) {
                if (!((EventModule)it.next()).eventFired(je)) continue;
                return true;
            }
        }
        if ((modules = (Set)foreignTable.get(je.getEventName())) != null) {
            it = modules.iterator();
            while (it.hasNext()) {
                if (!((EventModule)it.next()).eventFired(je)) continue;
                return true;
            }
        }
        return false;
    }

    public void registerModule(EventModule module) {
        Map table = module.getModuleType() == 1 ? this.nativePreTable : this.nativePostTable;
        Set<EventModule> modules = (TreeSet<EventModule>)table.get(module.getName());
        if (modules == null) {
            modules = new TreeSet<EventModule>(moduleComparator);
            table.put(module.getName(), modules);
        }
        modules.add(module);
        table = module.getModuleType() == 1 ? this.foreignPreTable : this.foreignPostTable;
        List foreignEventNames = module.getForeignEventNames();
        if (foreignEventNames != null) {
            int n = foreignEventNames.size();
            for (int i = 0; i < n; ++i) {
                String eventName = (String)foreignEventNames.get(i);
                modules = (Set)table.get(eventName);
                if (modules == null) {
                    modules = new TreeSet(moduleComparator);
                    table.put(eventName, modules);
                }
                modules.add(module);
            }
        }
    }

    public void unregisterModule(EventModule module) {
        Map table = module.getModuleType() == 1 ? this.nativePreTable : this.nativePostTable;
        Set modules = (Set)table.get(module.getName());
        modules.remove(module);
        if (modules.isEmpty()) {
            table.remove(module.getName());
        }
        table = module.getModuleType() == 1 ? this.foreignPreTable : this.foreignPostTable;
        List foreignEventNames = module.getForeignEventNames();
        if (foreignEventNames != null) {
            int n = foreignEventNames.size();
            for (int i = 0; i < n; ++i) {
                String event = (String)foreignEventNames.get(i);
                modules = (Set)table.get(event);
                modules.remove(module);
                if (!modules.isEmpty()) continue;
                table.remove(event);
            }
        }
    }

    static {
        moduleComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = ((JaspiraEventListener)o1).getPriority() - ((JaspiraEventListener)o2).getPriority();
                return result != 0 ? result : o1.toString().compareTo(o2.toString());
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        };
    }
}

