/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openbp.common.icon.MultiIcon;
import org.openbp.jaspira.gui.interaction.CursorPrototype;

public class BasicCursorPrototype
implements CursorPrototype {
    private Image subTemplate;
    private Image superTemplate;
    private Point hotspot;
    private static final int CURSORSIZE = 32;

    public BasicCursorPrototype(Image subTemplate, Image superTemplate, Point hotspot) {
        this.subTemplate = subTemplate;
        this.superTemplate = superTemplate;
        this.hotspot = hotspot;
    }

    @Override
    public Cursor createCursor(MultiIcon icon) {
        BufferedImage buffer = new BufferedImage(32, 32, 6);
        Graphics g = ((Image)buffer).getGraphics();
        if (this.subTemplate != null) {
            g.drawImage(this.subTemplate, 0, 0, null);
        }
        if (icon != null) {
            Image image = ((ImageIcon)icon.getIcon(0)).getImage();
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            g.drawImage(image, 32 - w, 32 - h, null);
        }
        if (this.superTemplate != null) {
            g.drawImage(this.superTemplate, 0, 0, null);
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(buffer, this.hotspot, "custom");
    }
}

