/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.geom.RectangularShape;
import javax.swing.SwingUtilities;
import org.openbp.jaspira.gui.interaction.CursorPrototype;
import org.openbp.jaspira.gui.interaction.DragAwareRegion;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.swing.SwingUtil;

public class BasicDropRegion
implements DragAwareRegion {
    protected Object id;
    protected InteractionClient parent;
    private RectangularShape shape;
    private Color frameColor;
    private Stroke stroke;
    private Paint paint;
    private CursorPrototype cursor;
    private Shape overlay;
    protected Component origin;
    protected String toolTipText;

    public BasicDropRegion(Object id, InteractionClient parent, RectangularShape shape, Component origin) {
        this.id = id;
        this.parent = parent;
        this.shape = shape;
        this.origin = origin;
        this.shape.setFrame(SwingUtil.convertRectToGlassCoords((Rectangle)shape.getBounds(), (Component)origin));
    }

    public BasicDropRegion(Object id, InteractionClient parent, Component source) {
        this(id, parent, SwingUtilities.getLocalBounds(source), source);
    }

    @Override
    public boolean importData(Transferable data, Point p) {
        return this.parent.importData(this.id, data, p);
    }

    @Override
    public boolean canImport() {
        return true;
    }

    @Override
    public void draw(Graphics2D g) {
        Paint oldPaint = g.getPaint();
        if (this.paint != null) {
            g.setPaint(this.paint);
            g.fill(this.shape);
        }
        if (this.frameColor != null) {
            if (this.stroke == null) {
                this.stroke = new BasicStroke();
            }
            Stroke oldStroke = g.getStroke();
            g.setStroke(this.stroke);
            g.setColor(this.frameColor);
            g.draw(this.shape);
            g.setStroke(oldStroke);
        }
        g.setPaint(oldPaint);
    }

    @Override
    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    @Override
    public boolean reactsOn(int x, int y) {
        return this.shape.contains(x, y);
    }

    @Override
    public boolean dragEnter() {
        return false;
    }

    @Override
    public boolean dragExit() {
        return false;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public InteractionClient getParent() {
        return this.parent;
    }

    public void setParent(InteractionClient parent) {
        this.parent = parent;
    }

    public RectangularShape getShape() {
        return this.shape;
    }

    public void setShape(RectangularShape shape) {
        this.shape = shape;
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public CursorPrototype getCursor() {
        return this.cursor;
    }

    public void setCursor(CursorPrototype cursor) {
        this.cursor = cursor;
    }

    @Override
    public Shape getOverlay() {
        return this.overlay;
    }

    public void setOverlay(Shape overlay) {
        this.overlay = overlay;
    }

    public Component getOrigin() {
        return this.origin;
    }

    public void setOrigin(Component origin) {
        this.origin = origin;
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }
}

