/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.openbp.jaspira.gui.interaction.InteractionClient;

public class DropClientUtil {
    private DropClientUtil() {
    }

    public static List getAllDropRegions(InteractionClient client, List flavors, Transferable data, MouseEvent mouseEvent) {
        List regions;
        ArrayList result = null;
        List subClients = client.getSubClients();
        if (subClients != null) {
            int n = subClients.size();
            for (int i = 0; i < n; ++i) {
                InteractionClient subClient = (InteractionClient)subClients.get(i);
                List subRegions = subClient.getAllDropRegions(flavors, data, mouseEvent);
                if (subRegions == null) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.addAll(subRegions);
            }
        }
        if ((regions = client.getDropRegions(flavors, data, mouseEvent)) != null) {
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(regions);
        }
        return result;
    }

    public static List getAllImportersAt(InteractionClient client, Point p) {
        List importers;
        ArrayList result = null;
        List subClients = client.getSubClients();
        if (subClients != null) {
            int n = subClients.size();
            for (int i = 0; i < n; ++i) {
                InteractionClient subClient = (InteractionClient)subClients.get(i);
                List subImporters = subClient.getAllImportersAt(p);
                if (subImporters == null) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.addAll(subImporters);
            }
        }
        if ((importers = client.getImportersAt(p)) != null) {
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(importers);
        }
        return result;
    }

    public static void dragStarted(InteractionClient client, Transferable transferable) {
        List subClients = client.getSubClients();
        if (subClients != null) {
            int n = subClients.size();
            for (int i = 0; i < n; ++i) {
                InteractionClient subClient = (InteractionClient)subClients.get(i);
                subClient.dragStarted(transferable);
            }
        }
    }

    public static void dragEnded(InteractionClient client, Transferable transferable) {
        List subClients = client.getSubClients();
        if (subClients != null) {
            int n = subClients.size();
            for (int i = 0; i < n; ++i) {
                InteractionClient subClient = (InteractionClient)subClients.get(i);
                subClient.dragEnded(transferable);
            }
        }
    }
}

