/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.icon.MultiIcon;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.clipboard.ClipboardPlugin;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.JaspiraPageContainer;
import org.openbp.jaspira.gui.plugin.PluginDialog;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugin.ConfigMgr;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugins.AboutBoxPlugin;
import org.openbp.jaspira.plugins.PluginMgrPlugin;
import org.openbp.jaspira.plugins.statusbar.StatusBarTextEvent;
import org.openbp.jaspira.util.StandardFlavors;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;

public abstract class ApplicationBase
extends AbstractPlugin {
    private List frames;
    private static ApplicationBase singletonInstance;
    private static boolean isInitialized;

    public ApplicationBase() {
        singletonInstance = this;
        ConfigMgr.getInstance().initialize();
        this.initializePlugin();
        PluginMgr.getInstance().registerPlugin(this);
    }

    public static ApplicationBase getInstance() {
        if (singletonInstance == null) {
            throw new RuntimeException("ApplicationBase.getInstance (): The application base has not been instantiated yet!");
        }
        return singletonInstance;
    }

    public static boolean hasInstance() {
        return singletonInstance != null;
    }

    public static final boolean isInitialized() {
        return isInitialized;
    }

    @Override
    public void installPlugin() {
        this.frames = new ArrayList();
        this.installLookAndFeel();
        JMsgBox.setDefaultOwnerProvider((JMsgBox.DefaultOwnerProvider)new ActiveFrameProvider());
        FocusManager.setCurrentManager(PluginFocusMgr.getInstance());
        this.preInstallApplication();
        super.installPlugin();
        PluginMgr.getInstance().createInstance(ClipboardPlugin.class, (Plugin)this);
        this.postInstallApplication();
        this.fireEvent("global.init.completed");
        this.fireEvent(new StatusBarTextEvent(this, this.getPluginResourceCollection().getRequiredString("application.loaded")));
        isInitialized = true;
        this.fireEvent(new JaspiraEvent(this, "global.enviroment.rebuild", null, 2, 2, 2));
    }

    void shutdown() {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            ((JaspiraPageContainer)this.frames.get(i)).dispose();
        }
        System.exit(0);
    }

    protected void preInstallApplication() {
    }

    protected void postInstallApplication() {
    }

    protected void installLookAndFeel() {
        try {
            UIManager.setLookAndFeel("org.openbp.swing.plaf.sky.SkyLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (InstantiationException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    protected Class getAboutBoxClass() {
        return AboutBoxPlugin.class;
    }

    public JaspiraPageContainer addFrame(JaspiraPage page, Dimension d, int state, GraphicsConfiguration gc) {
        JaspiraPageContainer frame = new JaspiraPageContainer(this.getTitle(), gc);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ApplicationBase.this.fireEvent(new JaspiraEvent((JaspiraPageContainer)e.getWindow(), "global.frame.close"));
            }

            @Override
            public void windowActivated(WindowEvent e) {
                ApplicationBase.this.fireEvent(new JaspiraEvent((JaspiraPageContainer)e.getWindow(), "global.frame.activated"));
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                ApplicationBase.this.fireEvent(new JaspiraEvent((JaspiraPageContainer)e.getWindow(), "global.frame.deactivated"));
            }
        });
        MultiIcon multiIcon = this.getIcon();
        Icon icon = multiIcon.getIcon(32);
        BufferedImage buf = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = buf.getGraphics();
        icon.paintIcon(frame, g, 0, 0);
        frame.setIconImage(buf);
        this.frames.add(frame);
        frame.addPage(page);
        frame.pack();
        frame.setSize(d);
        frame.setExtendedState(state);
        SwingUtil.show((JFrame)frame);
        return frame;
    }

    public JaspiraPageContainer addFrame(JaspiraPage page, Dimension d, int state) {
        return this.addFrame(page, d, state, null);
    }

    public JaspiraPageContainer addFrame(JaspiraPage page) {
        return this.addFrame(page, Toolkit.getDefaultToolkit().getScreenSize(), 0);
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public JaspiraPage addPage(JaspiraPage page) {
        if (this.frames.isEmpty()) {
            this.addFrame(page);
        } else {
            this.getActiveFrame().addPage(page);
        }
        return page;
    }

    public void showPage(JaspiraPage page) {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            JaspiraPageContainer frame = (JaspiraPageContainer)this.frames.get(i);
            if (!frame.containsPage(page)) continue;
            frame.setPageActive(page);
            frame.toFront();
        }
    }

    public boolean hasFrameForGraphicsConfiguration(GraphicsConfiguration gc) {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            JaspiraPageContainer frame = (JaspiraPageContainer)this.frames.get(i);
            if (gc != frame.getGraphicsConfiguration()) continue;
            return true;
        }
        return false;
    }

    public JaspiraPageContainer getActiveFrame() {
        Window win = FocusManager.getCurrentManager().getActiveWindow();
        if (win instanceof JaspiraPageContainer) {
            return (JaspiraPageContainer)win;
        }
        if (this.frames.size() > 0) {
            return (JaspiraPageContainer)this.frames.get(0);
        }
        return null;
    }

    public VisiblePlugin getActivePlugin() {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            JaspiraPageContainer frame = (JaspiraPageContainer)this.frames.get(i);
            if (!frame.isFocused()) continue;
            return frame.getActivePlugin();
        }
        return null;
    }

    public void buildMenus() {
        int n = this.frames.size();
        for (int i = 0; i < n; ++i) {
            ((JaspiraPageContainer)this.frames.get(i)).buildMenu();
        }
    }

    public void showStatusText(String text) {
        this.fireEvent(new StatusBarTextEvent(this, text));
    }

    public JaspiraPage getPage() {
        return null;
    }

    private static class ActiveFrameProvider
    implements JMsgBox.DefaultOwnerProvider {
        private ActiveFrameProvider() {
        }

        public Component getDefaultOwner() {
            return ApplicationBase.getInstance().getActiveFrame();
        }
    }

    public class PageInteractionEvents
    extends InteractionModule {
        @Override
        public JaspiraEventHandlerCode popup(final InteractionEvent ie) {
            if (!ie.isDataFlavorSupported(StandardFlavors.JASPIRA_PAGE)) {
                return EVENT_IGNORED;
            }
            JaspiraAction group = new JaspiraAction("popup.page", null, null, null, null, 1, "group");
            group.addMenuChild(new JaspiraAction(ApplicationBase.this, "frame.openinframe"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JaspiraPage page = (JaspiraPage)ie.getSafeTransferData(StandardFlavors.JASPIRA_PAGE);
                    if (page != null) {
                        JaspiraPageContainer frame = (JaspiraPageContainer)page.getWindow();
                        frame.openInNewFrame(page);
                    }
                }
            });
            ie.add(group);
            return EVENT_HANDLED;
        }
    }

    public class MenuInteractionEvents
    extends InteractionModule {
        @Override
        public int getPriority() {
            return 99;
        }

        public JaspiraEventHandlerCode exit(JaspiraActionEvent je) {
            ApplicationBase.this.fireEvent("global.application.exit");
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode pluginmanageropen(JaspiraActionEvent je) {
            PluginMgrPlugin plugin = new PluginMgrPlugin();
            plugin.initializePlugin();
            plugin.installPlugin();
            PluginDialog dialog = new PluginDialog((Frame)ApplicationUtil.getActiveWindow(), (VisiblePlugin)plugin, null, true);
            SwingUtil.show((JDialog)dialog);
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode openaboutbox(JaspiraActionEvent ie) {
            VisiblePlugin plugin = PluginMgr.getInstance().createVisibleInstance(ApplicationBase.this.getAboutBoxClass(), (Plugin)ApplicationBase.this);
            PluginDialog dialog = new PluginDialog((Frame)ApplicationUtil.getActiveWindow(), plugin, null, true);
            SwingUtil.show((JDialog)dialog);
            return EVENT_CONSUMED;
        }
    }

    public class CloseEvents
    extends EventModule {
        @Override
        public String getName() {
            return "global";
        }

        public JaspiraEventHandlerCode global_application_exit(JaspiraEvent je) {
            if (ApplicationBase.this.requestClose()) {
                ApplicationBase.this.shutdown();
            }
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode global_frame_close(JaspiraEvent je) {
            if (ApplicationBase.this.frames.size() == 1) {
                this.global_application_exit(new JaspiraEvent(ApplicationBase.this, "global.application.exit"));
            } else {
                JaspiraPageContainer source = (JaspiraPageContainer)je.getSource();
                ApplicationBase.this.frames.remove(source);
                JaspiraPageContainer target = (JaspiraPageContainer)ApplicationBase.this.frames.get(0);
                Iterator it = source.getPages().iterator();
                while (it.hasNext()) {
                    target.addPage((JaspiraPage)it.next());
                }
                source.dispose();
            }
            return EVENT_CONSUMED;
        }
    }
}

