/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.gui.plugin.JaspiraPageContainer;
import org.openbp.jaspira.gui.plugin.PluginContainer;
import org.openbp.jaspira.gui.plugin.PluginDivider;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;

public abstract class JaspiraPage
extends AbstractVisiblePlugin
implements PluginContainer {
    private PluginDivider divider;
    protected WeakReference focusedPluginRef;

    @Override
    public String toString() {
        String s = super.toString();
        Iterator it = this.getPlugins().iterator();
        while (it.hasNext()) {
            s = s + "\nContained plugin:" + it.next();
        }
        return s;
    }

    @Override
    protected void initializeComponents() {
        this.setPluginDivider(new PluginDivider());
        this.layoutDefaultContent();
        this.setupKeyBindings();
    }

    @Override
    protected void pluginUninstalled() {
        Iterator it = this.getPlugins().iterator();
        while (it.hasNext()) {
            PluginMgr.getInstance().removeInstance((Plugin)it.next());
        }
    }

    public void layoutDefaultContent() {
    }

    public void setPluginDivider(PluginDivider divider) {
        this.divider = divider;
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)((Object)divider));
    }

    public PluginDivider getPluginDivider() {
        return this.divider;
    }

    public Window getWindow() {
        return SwingUtilities.getWindowAncestor(this.getPluginComponent());
    }

    @Override
    public void addPlugin(VisiblePlugin p) {
        this.divider.addPlugin(p);
    }

    @Override
    public void removePlugin(VisiblePlugin p) {
        this.divider.removePlugin(p);
        this.divider.revalidate();
    }

    @Override
    public List getPlugins() {
        return this.divider.getPlugins();
    }

    @Override
    public List getVisiblePlugins() {
        return this.divider.getVisiblePlugins();
    }

    @Override
    public VisiblePlugin getActivePlugin() {
        return this.divider.getActivePlugin();
    }

    @Override
    public PluginContainer getParentContainer() {
        Window w = SwingUtilities.getWindowAncestor(this.getPluginComponent());
        if (w != null && w instanceof JaspiraPageContainer) {
            return (JaspiraPageContainer)w;
        }
        return null;
    }

    @Override
    public void showPlugin(boolean changePage) {
        Window w;
        if (changePage && !this.getPluginComponent().isShowing() && (w = SwingUtilities.getWindowAncestor(this.getPluginComponent())) != null) {
            if (w instanceof JaspiraPageContainer) {
                ((JaspiraPageContainer)w).setPageActive(this);
            }
            w.toFront();
        }
    }

    @Override
    public void sliceContainer(PluginContainer toInsert, PluginContainer currentContainer, String constraint) {
        if (this.divider.getOrientation() == 1) {
            if ("south".equals(constraint)) {
                this.divider.insertContainerAt(toInsert, -1);
            } else if ("north".equals(constraint)) {
                this.divider.insertContainerAt(toInsert, 0);
            } else if ("west".equals(constraint)) {
                PluginDivider sub = new PluginDivider(0);
                sub.addClient((Component)((Object)toInsert));
                sub.addClient((Component)((Object)this.divider));
                this.setPluginDivider(sub);
            } else if ("east".equals(constraint)) {
                PluginDivider sub2 = new PluginDivider(0);
                sub2.addClient((Component)((Object)this.divider));
                sub2.addClient((Component)((Object)toInsert));
                this.setPluginDivider(sub2);
            }
        } else if ("east".equals(constraint)) {
            this.divider.insertContainerAt(toInsert, -1);
        } else if ("west".equals(constraint)) {
            this.divider.insertContainerAt(toInsert, 0);
        } else if ("north".equals(constraint)) {
            PluginDivider sub = new PluginDivider(1);
            sub.addClient((Component)((Object)toInsert));
            sub.addClient((Component)((Object)this.divider));
            this.setPluginDivider(sub);
        } else if ("south".equals(constraint)) {
            PluginDivider sub2 = new PluginDivider(1);
            sub2.addClient((Component)((Object)this.divider));
            sub2.addClient((Component)((Object)toInsert));
            this.setPluginDivider(sub2);
        }
    }

    @Override
    public Component getPluginFocusComponent() {
        VisiblePlugin p;
        Component comp = super.getPluginFocusComponent();
        if (comp == null && this.focusedPluginRef != null && (p = (VisiblePlugin)this.focusedPluginRef.get()) != null && p != this) {
            comp = p.getPluginFocusComponent();
        }
        return comp;
    }

    public void setFocusedPlugin(VisiblePlugin plugin) {
        if (plugin != null) {
            if (plugin == this) {
                List plugins;
                this.focusedPluginRef = null;
                if (this.getPluginFocusComponent() == null && (plugins = this.getVisiblePlugins()) != null && plugins.size() > 0) {
                    plugin = (VisiblePlugin)plugins.get(0);
                }
            }
            this.focusedPluginRef = plugin != null ? new WeakReference<VisiblePlugin>(plugin) : null;
        } else {
            this.focusedPluginRef = null;
        }
    }

    public void restoreFocus() {
        boolean hasRestored = false;
        if (this.focusedPluginRef != null) {
            VisiblePlugin p = (VisiblePlugin)this.focusedPluginRef.get();
            if (p != null && p.getPluginHolder() != null) {
                p.focusPlugin();
                hasRestored = true;
            } else {
                this.focusedPluginRef = null;
            }
        }
        if (!hasRestored) {
            FocusManager.getCurrentManager().focusNextComponent(this.getPluginComponent());
        }
    }

    public void advanceFocus(boolean forward, boolean visibleOnly) {
        List plugins;
        int currentIndex = -1;
        List list = plugins = visibleOnly ? this.getVisiblePlugins() : this.getPlugins();
        if (plugins == null) {
            return;
        }
        int n = plugins.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            VisiblePlugin plugin = (VisiblePlugin)plugins.get(i);
            if (!plugin.isPluginFocused()) continue;
            currentIndex = i;
        }
        int newIndex = currentIndex;
        if (forward) {
            if (++newIndex >= n) {
                newIndex = 0;
            }
        } else if (--newIndex < 0) {
            newIndex = n - 1;
        }
        if (newIndex != currentIndex) {
            VisiblePlugin vp = (VisiblePlugin)plugins.get(newIndex);
            vp.focusPlugin();
        }
    }

    protected void setupKeyBindings() {
        InputMap inputmap = this.getContentPane().getInputMap(1);
        ActionMap actionmap = this.getContentPane().getActionMap();
        inputmap.put(KeyStroke.getKeyStroke(122, 0), "NextVisiblePlugin");
        actionmap.put("NextVisiblePlugin", new CycleAction(true, true));
        inputmap.put(KeyStroke.getKeyStroke(122, 1), "PrevVisiblePlugin");
        actionmap.put("PrevVisiblePlugin", new CycleAction(false, true));
        inputmap.put(KeyStroke.getKeyStroke(123, 0), "NextPlugin");
        actionmap.put("NextPlugin", new CycleAction(true, false));
        inputmap.put(KeyStroke.getKeyStroke(123, 1), "PrevPlugin");
        actionmap.put("PrevPlugin", new CycleAction(false, false));
    }

    class CycleAction
    extends AbstractAction {
        private boolean forward;
        private boolean visibleOnly;

        public CycleAction(boolean forward, boolean visibleOnly) {
            this.forward = forward;
            this.visibleOnly = visibleOnly;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JaspiraPage.this.advanceFocus(this.forward, this.visibleOnly);
        }
    }
}

