/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.PluginHolder;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;

public class PluginDialog
extends JDialog
implements PluginHolder {
    private VisiblePlugin plugin;
    private String returnPageId;
    private JaspiraToolbar mainToolbar;
    protected WeakReference focusedPlugin;

    public PluginDialog(Frame owner, VisiblePlugin plugin, String returnPageId, boolean modal, GraphicsConfiguration gc) {
        super(owner, plugin.getTitle(), modal, gc);
        VisiblePlugin p;
        this.init(plugin, returnPageId);
        if (modal && (p = PluginFocusMgr.getInstance().getFocusedPlugin()) != null) {
            this.focusedPlugin = new WeakReference<VisiblePlugin>(p);
        }
    }

    public PluginDialog(Frame owner, VisiblePlugin plugin, String returnPageId, boolean modal) {
        this(owner, plugin, returnPageId, modal, owner != null ? owner.getGraphicsConfiguration() : null);
    }

    public PluginDialog(Frame owner, VisiblePlugin plugin, String returnPageId) {
        this(owner, plugin, returnPageId, false);
    }

    public PluginDialog(Dialog owner, VisiblePlugin plugin, String returnPageId, boolean modal, GraphicsConfiguration gc) {
        super(owner, plugin.getTitle(), modal, gc);
        this.init(plugin, returnPageId);
    }

    public PluginDialog(Dialog owner, VisiblePlugin plugin, String returnPageId, boolean modal) {
        this(owner, plugin, returnPageId, modal, owner.getGraphicsConfiguration());
    }

    public PluginDialog(Dialog owner, VisiblePlugin plugin, String returnPageId) {
        this(owner, plugin, returnPageId, false);
    }

    public PluginDialog(VisiblePlugin plugin, String returnPageId) {
        this((Frame)null, plugin, returnPageId, false, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    public PluginDialog(VisiblePlugin plugin) {
        this((Frame)null, plugin, null, false, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    protected void init(VisiblePlugin plugin, String returnPageId) {
        this.plugin = plugin;
        this.returnPageId = returnPageId;
        plugin.setPluginHolder(this);
        JComponent comp = plugin.getPluginComponent();
        this.getContentPane().add(comp);
        this.buildToolBar();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PluginDialog.this.close();
            }
        });
    }

    protected void buildToolBar() {
        if (this.mainToolbar != null) {
            this.getContentPane().remove(this.mainToolbar);
        }
        this.mainToolbar = new JaspiraToolbar();
        this.mainToolbar.setFloatable(false);
        JaspiraToolbar toolbar = this.plugin.createToolbar();
        if (toolbar != null) {
            this.mainToolbar.add((Component)toolbar, "West");
        }
        this.getContentPane().add((Component)this.mainToolbar, "North");
    }

    public void close() {
        Plugin page;
        this.dispose();
        if (this.returnPageId != null && (page = PluginMgr.getInstance().getPlugin(this.returnPageId)) != null) {
            this.plugin.setPluginHolder(this.plugin.getPluginPanel());
            this.plugin.getPluginPanel().initTitleBar();
            ((JaspiraPage)page).addPlugin(this.plugin);
            return;
        }
        PluginMgr.getInstance().removeInstance(this.plugin);
        if (this.focusedPlugin != null) {
            VisiblePlugin p = (VisiblePlugin)this.focusedPlugin.get();
            if (p != null && p.getPluginHolder() != null) {
                PluginFocusMgr.getInstance().resetFocusCache();
                p.focusPlugin();
            }
            this.focusedPlugin = null;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(visible);
    }

    @Override
    public void showHolder(boolean changePage) {
        this.toFront();
    }

    @Override
    public void updateHolder(boolean fullRebuild) {
        if (fullRebuild || this.mainToolbar == null) {
            this.buildToolBar();
        }
        this.setTitle(this.plugin.getTitle());
    }

    @Override
    public void unlinkHolder() {
        this.dispose();
    }
}

