/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.gui.interaction.DropClientUtil;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.interaction.JaspiraTransferHandler;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.PluginContainer;
import org.openbp.jaspira.gui.plugin.TabbedPluginContainer;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.swing.components.JMultiSplitPane;

public class PluginDivider
extends JMultiSplitPane
implements PluginContainer,
InteractionClient {
    public PluginDivider() {
        this.setTransferHandler(new JaspiraTransferHandler());
    }

    public PluginDivider(int orientation) {
        super(orientation);
        this.setTransferHandler(new JaspiraTransferHandler());
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"plugins");
    }

    @Override
    public void addPlugin(VisiblePlugin p) {
        this.addContainer(new TabbedPluginContainer(p));
    }

    public void addContainer(PluginContainer pc) {
        this.insertContainerAt(pc, -1);
    }

    public void insertContainerAt(PluginContainer pc, int slot) {
        this.addClient((Component)((Object)pc), slot);
        this.linkToPage(pc);
    }

    @Override
    public void sliceContainer(PluginContainer toInsert, PluginContainer currentContainer, String constraint) {
        if (this.getOrientation() == 0) {
            if ("south".equals(constraint)) {
                this.addClientAfter((Component)((Object)currentContainer), (Component)((Object)toInsert));
            } else if ("north".equals(constraint)) {
                this.addClientBefore((Component)((Object)currentContainer), (Component)((Object)toInsert));
            } else if ("west".equals(constraint)) {
                PluginDivider sub = new PluginDivider(1);
                sub.addClient((Component)((Object)toInsert));
                this.replaceClient((Component)((Object)currentContainer), (Component)((Object)sub));
                sub.addClient((Component)((Object)currentContainer));
            } else if ("east".equals(constraint)) {
                PluginDivider sub2 = new PluginDivider(1);
                sub2.addClient((Component)((Object)toInsert));
                this.replaceClient((Component)((Object)currentContainer), (Component)((Object)sub2));
                sub2.addClient((Component)((Object)currentContainer), 0);
            }
        } else if ("east".equals(constraint)) {
            this.addClientAfter((Component)((Object)currentContainer), (Component)((Object)toInsert));
        } else if ("west".equals(constraint)) {
            this.addClientBefore((Component)((Object)currentContainer), (Component)((Object)toInsert));
        } else if ("north".equals(constraint)) {
            PluginDivider sub = new PluginDivider(0);
            sub.addClient((Component)((Object)toInsert));
            this.replaceClient((Component)((Object)currentContainer), (Component)((Object)sub));
            sub.addClient((Component)((Object)currentContainer));
        } else if ("south".equals(constraint)) {
            PluginDivider sub2 = new PluginDivider(0);
            sub2.addClient((Component)((Object)toInsert));
            this.replaceClient((Component)((Object)currentContainer), (Component)((Object)sub2));
            sub2.addClient((Component)((Object)currentContainer), 0);
        }
        this.linkToPage(toInsert);
    }

    @Override
    public void removePlugin(VisiblePlugin p) {
        this.removeClient(p.getPluginPanel());
    }

    private void linkToPage(PluginContainer pc) {
        JaspiraPage page = this.getPage();
        if (page != null) {
            Iterator it = pc.getPlugins().iterator();
            while (it.hasNext()) {
                ((Plugin)it.next()).setParentPlugin(page);
            }
        }
    }

    @Override
    public VisiblePlugin getActivePlugin() {
        return null;
    }

    @Override
    public PluginContainer getParentContainer() {
        VisiblePlugin plugin = AbstractVisiblePlugin.getPluginFromComponentHierarchy((Component)((Object)this));
        if (plugin != null) {
            return (JaspiraPage)plugin;
        }
        return null;
    }

    @Override
    public List getPlugins() {
        ArrayList result = new ArrayList();
        Component[] comps = this.getClients();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof PluginContainer)) continue;
            result.addAll(((PluginContainer)((Object)comps[i])).getPlugins());
        }
        return result;
    }

    @Override
    public List getVisiblePlugins() {
        ArrayList result = new ArrayList();
        Component[] comps = this.getClients();
        for (int i = 0; i < comps.length; ++i) {
            List l;
            if (!(comps[i] instanceof PluginContainer) || (l = ((PluginContainer)((Object)comps[i])).getVisiblePlugins()) == null) continue;
            result.addAll(l);
        }
        return result;
    }

    @Override
    public JaspiraPage getPage() {
        PluginContainer parent = this.getParentContainer();
        return parent != null ? parent.getPage() : null;
    }

    @Override
    public void dragStarted(Transferable transferable) {
        DropClientUtil.dragStarted(this, transferable);
    }

    @Override
    public void dragEnded(Transferable transferable) {
        DropClientUtil.dragEnded(this, transferable);
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public final List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return DropClientUtil.getAllDropRegions(this, flavors, data, mouseEvent);
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return DropClientUtil.getAllImportersAt(this, p);
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        return false;
    }

    @Override
    public List getSubClients() {
        ArrayList<Component> result = null;
        Component[] comps = this.getClients();
        for (int i = 0; i < comps.length; ++i) {
            if (result == null) {
                result = new ArrayList<Component>();
            }
            result.add(comps[i]);
        }
        return result;
    }
}

