/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;

public final class PluginFocusMgr
extends DefaultFocusManager {
    private static PluginFocusMgr singletonInstance;
    protected WeakReference lastPluginRef;

    public static synchronized PluginFocusMgr getInstance() {
        FocusManager focusMgr = FocusManager.getCurrentManager();
        if (focusMgr instanceof PluginFocusMgr) {
            return (PluginFocusMgr)focusMgr;
        }
        if (singletonInstance == null) {
            singletonInstance = new PluginFocusMgr();
        }
        return singletonInstance;
    }

    private PluginFocusMgr() {
    }

    @Override
    public boolean dispatchEvent(AWTEvent e) {
        VisiblePlugin plugin;
        if (e instanceof FocusEvent && (plugin = AbstractVisiblePlugin.getPluginFromComponentHierarchy((Component)e.getSource())) != null) {
            this.changeFocus(plugin);
        }
        return super.dispatchEvent(e);
    }

    public void changeFocus(VisiblePlugin plugin) {
        VisiblePlugin lastPlugin = null;
        if (this.lastPluginRef != null) {
            lastPlugin = (VisiblePlugin)this.lastPluginRef.get();
        }
        if (plugin != lastPlugin) {
            this.lastPluginRef = new WeakReference<VisiblePlugin>(plugin);
            if (lastPlugin != null) {
                lastPlugin.firePluginFocusLost();
            }
            plugin.firePluginFocusGained();
            JaspiraPage page = plugin.getPage();
            if (page != null) {
                page.setFocusedPlugin(plugin);
            }
        }
    }

    public VisiblePlugin getFocusedPlugin() {
        VisiblePlugin lastPlugin = null;
        if (this.lastPluginRef != null && (lastPlugin = (VisiblePlugin)this.lastPluginRef.get()) != null) {
            return lastPlugin;
        }
        VisiblePlugin plugin = ApplicationBase.getInstance().getActivePlugin();
        if (plugin != null) {
            return plugin;
        }
        return null;
    }

    public void resetFocusCache() {
        this.lastPluginRef = null;
    }
}

