/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.gui.interaction.BasicDragReactor;
import org.openbp.jaspira.gui.interaction.BasicDropRegion;
import org.openbp.jaspira.gui.interaction.BasicDropRegionId;
import org.openbp.jaspira.gui.interaction.DragInitiator;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.jaspira.gui.interaction.DropClientUtil;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.interaction.RectangleSegment;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.PluginContainer;
import org.openbp.jaspira.gui.plugin.PluginDivider;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.PluginHolder;
import org.openbp.jaspira.gui.plugin.PluginPanel;
import org.openbp.jaspira.gui.plugin.PluginTransferable;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugin.PluginState;
import org.openbp.jaspira.util.StandardFlavors;
import org.openbp.swing.plaf.sky.ShadowBorder;

public class TabbedPluginContainer
extends JPanel
implements PluginContainer,
InteractionClient,
DragOrigin,
ChangeListener {
    public static final NumberAction[] numberActions = new NumberAction[10];
    private static VisiblePlugin emptyPlugin;
    private List plugins;
    protected JTabbedPane tabbedPane;
    private boolean solid;
    private boolean alwaysTabs;
    private boolean preventFocusOnSelectionChange;

    public TabbedPluginContainer() {
        super(new BorderLayout());
        this.setBorder((Border)new ShadowBorder());
        this.plugins = new ArrayList(4);
        this.initKeySupport();
    }

    public TabbedPluginContainer(VisiblePlugin plugin) {
        this();
        this.addPlugin(plugin);
    }

    public TabbedPluginContainer(PluginState state) {
        this();
        this.addPlugin(PluginMgr.getInstance().createVisibleInstance(state, null));
    }

    @Override
    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"plugins");
    }

    private void initKeySupport() {
        ActionMap am = this.getActionMap();
        InputMap im = this.getInputMap(1);
        for (int i = 0; i < 10; ++i) {
            Integer next = new Integer(i);
            am.put(next, numberActions[i]);
            im.put(KeyStroke.getKeyStroke("control released " + i), next);
        }
    }

    protected void createTabPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(3);
            DragInitiator.makeDraggable(this.tabbedPane, this);
            this.tabbedPane.addChangeListener(this);
        }
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setSolid(boolean solid) {
        if (this.solid != solid) {
            this.solid = solid;
            this.synchronizeComponents(null, true);
        }
    }

    public boolean isAlwaysTabs() {
        return this.alwaysTabs;
    }

    public void setAlwaysTabs(boolean alwaysTabs) {
        if (this.alwaysTabs != alwaysTabs) {
            this.alwaysTabs = alwaysTabs;
            this.synchronizeComponents(null, true);
        }
    }

    public void addContainer(PluginContainer pc) {
        for (VisiblePlugin plugin : pc.getPlugins()) {
            this.addPlugin(plugin);
        }
    }

    @Override
    public void addPlugin(VisiblePlugin p) {
        this.addPlugin(p, true);
    }

    public void addPlugin(VisiblePlugin p, boolean activateplugin) {
        if (p == null) {
            return;
        }
        JaspiraPage page = this.getPage();
        if (page != null) {
            p.setParentPlugin(page);
        }
        this.plugins.add(p);
        this.synchronizeComponents(activateplugin ? p : null, true);
    }

    public void addPlugin(VisiblePlugin p, int slot) {
        if (slot == -1) {
            this.addPlugin(p);
            return;
        }
        JaspiraPage page = this.getPage();
        if (page != null) {
            p.setParentPlugin(page);
        }
        this.plugins.add(slot, p);
        this.synchronizeComponents(p, true);
    }

    @Override
    public void sliceContainer(PluginContainer toInsert, PluginContainer currentContainer, String constraint) {
        this.getParentContainer().sliceContainer(toInsert, currentContainer, constraint);
    }

    @Override
    public void removePlugin(VisiblePlugin p) {
        this.plugins.remove(p);
        this.synchronizeComponents(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeComponents(VisiblePlugin pluginToActivate, boolean preventFocusChange) {
        boolean oldPreventFocusOnSelectionChange = this.preventFocusOnSelectionChange;
        this.preventFocusOnSelectionChange = preventFocusChange;
        try {
            Component containerComponent = this.getComponentCount() > 0 ? this.getComponent(0) : null;
            int nPlugins = this.plugins.size();
            if (nPlugins == 0) {
                PluginContainer parent;
                this.preventFocusOnSelectionChange = true;
                if (this.tabbedPane != null) {
                    this.tabbedPane.removeAll();
                }
                if (!this.solid && (parent = this.getParentContainer()) instanceof PluginDivider) {
                    ((PluginDivider)parent).removeClient(this);
                    this.focusParent();
                    return;
                }
                PluginPanel emptyPanel = emptyPlugin.getPluginPanel();
                if (containerComponent != emptyPanel) {
                    this.removeAll();
                    this.add(emptyPanel);
                    this.repaint();
                }
                this.focusParent();
                return;
            }
            if (nPlugins == 1 && !this.alwaysTabs) {
                PluginPanel pluginPanel;
                if (this.tabbedPane != null) {
                    this.tabbedPane.removeAll();
                }
                if (containerComponent != (pluginPanel = ((VisiblePlugin)this.plugins.get(0)).getPluginPanel())) {
                    this.removeAll();
                    this.add(pluginPanel);
                    this.repaint();
                }
                this.setSelectedPlugin(pluginPanel.getPlugin());
                return;
            }
            this.createTabPane();
            int oldIndex = this.tabbedPane.getSelectedIndex();
            for (int iTab = 0; iTab < this.tabbedPane.getTabCount(); ++iTab) {
                PluginPanel pp = (PluginPanel)this.tabbedPane.getComponentAt(iTab);
                VisiblePlugin plugin = pp.getPlugin();
                if (this.plugins.contains(plugin)) continue;
                this.tabbedPane.remove(pp);
            }
            for (int iPlugin = 0; iPlugin < nPlugins; ++iPlugin) {
                PluginPanel ppTab;
                VisiblePlugin plugin = (VisiblePlugin)this.plugins.get(iPlugin);
                PluginPanel pp = plugin.getPluginPanel();
                PluginPanel pluginPanel = ppTab = iPlugin < this.tabbedPane.getTabCount() ? (PluginPanel)this.tabbedPane.getComponentAt(iPlugin) : null;
                if (ppTab == pp) continue;
                this.tabbedPane.insertTab(plugin.getTitle(), plugin.getIcon().getIcon(16), pp, plugin.getDescription(), iPlugin);
            }
            if (containerComponent != this.tabbedPane) {
                this.removeAll();
                this.add(this.tabbedPane);
            }
            if (pluginToActivate == null) {
                pluginToActivate = oldIndex < 0 ? (VisiblePlugin)this.plugins.get(0) : (oldIndex >= nPlugins ? (VisiblePlugin)this.plugins.get(nPlugins - 1) : (VisiblePlugin)this.plugins.get(oldIndex));
            }
            this.setSelectedPlugin(pluginToActivate);
            this.repaint();
        }
        finally {
            this.preventFocusOnSelectionChange = oldPreventFocusOnSelectionChange;
        }
    }

    private void focusParent() {
        VisiblePlugin parentPlugin = AbstractVisiblePlugin.getPluginFromComponentHierarchy(this);
        if (parentPlugin != null) {
            parentPlugin.focusPlugin();
        }
    }

    @Override
    public PluginContainer getParentContainer() {
        Container c;
        for (c = this.getParent(); !(c instanceof PluginDivider) && c != null; c = c.getParent()) {
        }
        return (PluginDivider)((Object)c);
    }

    public VisiblePlugin getSelectedPlugin() {
        PluginPanel pp;
        if (this.tabbedPane != null && this.tabbedPane.getTabCount() > 0 && (pp = (PluginPanel)this.tabbedPane.getSelectedComponent()) != null) {
            return pp.getPlugin();
        }
        return this.plugins.size() > 0 ? (VisiblePlugin)this.plugins.get(0) : null;
    }

    public void setSelectedPlugin(VisiblePlugin plugin) {
        if (this.getNumberOfPlugins() > 1) {
            boolean oldPreventFocusOnSelectionChange = this.preventFocusOnSelectionChange;
            this.preventFocusOnSelectionChange = true;
            this.tabbedPane.setSelectedComponent(plugin.getPluginPanel());
            this.preventFocusOnSelectionChange = oldPreventFocusOnSelectionChange;
        }
    }

    public int getNumberOfPlugins() {
        return this.plugins.size();
    }

    @Override
    public List getPlugins() {
        return this.plugins;
    }

    @Override
    public List getVisiblePlugins() {
        VisiblePlugin p = this.getSelectedPlugin();
        if (p != null) {
            ArrayList<VisiblePlugin> l = new ArrayList<VisiblePlugin>(1);
            l.add(p);
            return l;
        }
        return null;
    }

    @Override
    public VisiblePlugin getActivePlugin() {
        return this.getSelectedPlugin();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        VisiblePlugin p;
        if (!this.preventFocusOnSelectionChange && (p = this.getSelectedPlugin()) != null) {
            p.focusPlugin();
        }
    }

    @Override
    public void dragStarted(Transferable transferable) {
        DropClientUtil.dragStarted(this, transferable);
    }

    @Override
    public void dragEnded(Transferable transferable) {
        DropClientUtil.dragEnded(this, transferable);
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
        int index;
        if ("tabs".equals(regionId) && (index = this.tabbedPane.indexAtLocation(p.x, p.y)) != -1) {
            boolean oldPreventFocusOnSelectionChange = this.preventFocusOnSelectionChange;
            this.preventFocusOnSelectionChange = true;
            this.tabbedPane.setSelectedIndex(index);
            this.preventFocusOnSelectionChange = oldPreventFocusOnSelectionChange;
            ApplicationBase.getInstance().getActiveFrame().getDragDropPane().regionsInvalidated();
        }
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        ArrayList<BasicDropRegion> result = new ArrayList<BasicDropRegion>();
        if (this.tabbedPane != null && this.tabbedPane.getTabCount() > 0) {
            Rectangle shape = SwingUtilities.getLocalBounds(this.tabbedPane);
            int height = this.tabbedPane.getSelectedComponent().getBounds().height;
            shape.y += height;
            shape.height -= height;
            BasicDragReactor region = new BasicDragReactor("tabs", this, shape, this.tabbedPane, 1000L);
            result.add(region);
        }
        if (flavors.contains(StandardFlavors.PLUGIN) || flavors.contains(StandardFlavors.PLUGIN_STATE)) {
            BasicDropRegion region = new BasicDropRegion(REGION_NORTH, this, new RectangleSegment(this, 15, "north"), this);
            region.setFrameColor(Color.BLACK);
            region.setPaint(Color.GREEN);
            result.add(region);
            region = new BasicDropRegion(REGION_SOUTH, this, new RectangleSegment(this, 15, "south"), this);
            region.setFrameColor(Color.BLACK);
            region.setPaint(Color.GREEN);
            result.add(region);
            region = new BasicDropRegion(REGION_WEST, this, new RectangleSegment(this, 15, "west"), this);
            region.setFrameColor(Color.BLACK);
            region.setPaint(Color.GREEN);
            result.add(region);
            region = new BasicDropRegion(REGION_EAST, this, new RectangleSegment(this, 15, "east"), this);
            region.setFrameColor(Color.BLACK);
            region.setPaint(Color.GREEN);
            result.add(region);
        }
        return result;
    }

    @Override
    public final List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return DropClientUtil.getAllDropRegions(this, flavors, data, mouseEvent);
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return DropClientUtil.getAllImportersAt(this, p);
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        if (regionId instanceof BasicDropRegionId) {
            try {
                VisiblePlugin plugin = null;
                if (data.isDataFlavorSupported(StandardFlavors.PLUGIN)) {
                    plugin = (VisiblePlugin)data.getTransferData(StandardFlavors.PLUGIN);
                    PluginHolder holder = plugin.getPluginHolder();
                    if (holder != null) {
                        TabbedPluginContainer currentContainer;
                        if (holder instanceof PluginPanel && (currentContainer = ((PluginPanel)holder).getTabbedContainer()) == this) {
                            return false;
                        }
                        holder.unlinkHolder();
                    }
                } else if (data.isDataFlavorSupported(StandardFlavors.PLUGIN_STATE)) {
                    PluginState state = (PluginState)data.getTransferData(StandardFlavors.PLUGIN_STATE);
                    plugin = PluginMgr.getInstance().createVisibleInstance(state, null);
                }
                if (plugin != null) {
                    TabbedPluginContainer pc = new TabbedPluginContainer(plugin);
                    String constraint = ((BasicDropRegionId)regionId).getConstraint();
                    if (constraint == null || "center".equals(constraint)) {
                        this.addContainer(pc);
                    } else {
                        this.sliceContainer(pc, this, constraint);
                    }
                    PluginFocusMgr.getInstance().resetFocusCache();
                    plugin.focusPlugin();
                    return true;
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    @Override
    public List getSubClients() {
        VisiblePlugin plugin = this.getActivePlugin();
        if (plugin != null) {
            return Collections.singletonList(plugin.getPluginPanel());
        }
        return null;
    }

    public void updateContainer(boolean fullRebuild) {
        if (this.tabbedPane != null) {
            int count = this.tabbedPane.getTabCount();
            for (int i = 0; i < count; ++i) {
                PluginPanel pp = (PluginPanel)this.tabbedPane.getComponentAt(i);
                this.tabbedPane.setTitleAt(i, pp.getSubTitle());
                if (!fullRebuild) continue;
                this.tabbedPane.setIconAt(i, pp.getIcon().getIcon(16));
            }
        }
    }

    @Override
    public JaspiraPage getPage() {
        PluginContainer parent = this.getParentContainer();
        return parent != null ? parent.getPage() : null;
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public void dropAccepted(Transferable t) {
    }

    @Override
    public void dropCanceled(Transferable t) {
    }

    @Override
    public void dropPerformed(Transferable t) {
    }

    @Override
    public Transferable getTranferableAt(Point p) {
        VisiblePlugin plugin = this.getSelectedPlugin();
        if (plugin != null && plugin.canDrag()) {
            return new PluginTransferable(plugin);
        }
        return null;
    }

    @Override
    public MultiIcon getDragImage() {
        VisiblePlugin plugin = this.getSelectedPlugin();
        if (plugin != null) {
            return plugin.getIcon();
        }
        return null;
    }

    int getSelectedTab() {
        int n = 0;
        if (this.tabbedPane != null && (n = this.tabbedPane.getSelectedIndex()) < 0) {
            n = 0;
        }
        return n;
    }

    void setSelectedTab(int tab) {
        if (this.tabbedPane == null) {
            return;
        }
        int max = this.getNumberOfPlugins();
        if (max <= 1) {
            return;
        }
        if (tab < 0) {
            tab = max - 1;
        } else if (tab >= max) {
            tab = 0;
        }
        this.tabbedPane.setSelectedIndex(tab);
    }

    static {
        TabbedPluginContainer.numberActions[0] = new NumberAction(9);
        for (int i = 1; i < 10; ++i) {
            TabbedPluginContainer.numberActions[i] = new NumberAction(i - 1);
        }
        emptyPlugin = new AbstractVisiblePlugin(){

            @Override
            protected void initializeResources() {
            }

            @Override
            protected void initializeComponents() {
            }

            @Override
            public boolean canDrag() {
                return false;
            }

            @Override
            public String getResourceCollectionContainerName() {
                return null;
            }
        };
    }

    public static class NumberAction
    extends AbstractAction {
        private int number;

        NumberAction(int number) {
            this.number = number;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedPluginContainer tpc = (TabbedPluginContainer)e.getSource();
            tpc.setSelectedTab(this.number);
        }
    }

    public static class ChangeAction
    extends AbstractAction {
        private int offset;

        ChangeAction(int offset) {
            this.offset = offset;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedPluginContainer tpc = (TabbedPluginContainer)e.getSource();
            tpc.setSelectedTab(tpc.getSelectedTab() + this.offset);
        }
    }
}

