/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraToolbarButton;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.PasswordDialog;

public class PasswordWidget
extends OptionWidget {
    private JPanel panel;
    private String password;
    private JLabel passwordField;
    private ResourceCollection resourceCollection;

    public PasswordWidget(Option option, ResourceCollection resourceCollection) {
        super(option);
        this.resourceCollection = resourceCollection;
        this.panel = new JPanel(new BorderLayout());
        JLabel heading = this.createHeading();
        if (heading != null) {
            this.panel.add((Component)heading, "West");
        }
        this.passwordField = new JLabel();
        this.passwordField.setHorizontalTextPosition(2);
        this.passwordField.setHorizontalAlignment(2);
        JPanel pwfPane = new JPanel(new BorderLayout());
        pwfPane.add((Component)this.passwordField, "West");
        pwfPane.setOpaque(false);
        this.panel.add((Component)pwfPane, "Center");
        Box btnPane = Box.createHorizontalBox();
        JaspiraToolbarButton setPWBtn = new JaspiraToolbarButton(new PWAction(resourceCollection, "passwordwidget.newbtn"));
        setPWBtn.setIconSize(12);
        btnPane.add(setPWBtn);
        JaspiraToolbarButton removePWBtn = new JaspiraToolbarButton(new JaspiraAction(resourceCollection, "passwordwidget.removebtn"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PasswordWidget.this.setValue(null);
                PasswordWidget.this.notifyOptionMgrOfOptionChange();
            }
        });
        removePWBtn.setIconSize(12);
        btnPane.add(removePWBtn);
        this.panel.add((Component)btnPane, "East");
    }

    @Override
    public Object getValue() {
        return this.password;
    }

    @Override
    public void setValue(Object o) {
        String string = this.password = o == null ? null : o.toString();
        if (this.password == null || this.password.trim().length() == 0) {
            this.passwordField.setText(this.resourceCollection.getRequiredString("passwordwidget.inactive"));
        } else {
            this.passwordField.setText(this.resourceCollection.getRequiredString("passwordwidget.active"));
        }
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.panel;
    }

    private class PWAction
    extends JaspiraAction {
        private ResourceCollection resourceCollection;

        private PWAction(ResourceCollection resourceCollection, String name) {
            super(resourceCollection, name);
            this.resourceCollection = resourceCollection;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            PasswordDialog dialog = new PasswordDialog((Dialog)PasswordWidget.this.panel.getTopLevelAncestor(), true, this.resourceCollection);
            SwingUtil.show((JDialog)dialog);
            if (dialog.isCancelled()) {
                return;
            }
            PasswordWidget.this.setValue(dialog.getPassword());
            PasswordWidget.this.notifyOptionMgrOfOptionChange();
        }
    }
}

