/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.propertybrowser.ObjectChangeListener;
import org.openbp.jaspira.propertybrowser.PropertyBrowserImpl;

public class PropertyBrowserWidget
extends OptionWidget
implements ObjectChangeListener {
    private JScrollPane scrollPane;
    private PropertyBrowserImpl propertyBrowser;
    private int expandLevels;

    public PropertyBrowserWidget(Option option, ResourceCollection resourceCollection, int expandLevels) {
        super(option);
        this.expandLevels = expandLevels;
        this.propertyBrowser = new PropertyBrowserImpl(null, resourceCollection);
        this.propertyBrowser.setPreferredScrollableViewportSize(new Dimension(100, 200));
        this.propertyBrowser.addObjectChangeListener(this);
        this.scrollPane = new JScrollPane((Component)((Object)this.propertyBrowser));
    }

    @Override
    public void objectChanged(Object original, Object modified) {
        this.notifyOptionMgrOfOptionChange();
    }

    public void setSize(Dimension dimension) {
        this.propertyBrowser.setPreferredScrollableViewportSize(dimension);
    }

    @Override
    public Object getValue() {
        Object retVal = this.propertyBrowser.getModifiedObject();
        if (retVal == null) {
            retVal = this.propertyBrowser.getObject();
        }
        return retVal;
    }

    @Override
    public void setValue(Object o) {
        try {
            this.propertyBrowser.setObject(o, false);
            this.propertyBrowser.expandTreeLevels(true, this.expandLevels);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        catch (XMLDriverException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.scrollPane;
    }
}

