/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugin;

import org.openbp.common.application.Application;
import org.openbp.common.commandline.CommandLineParser;
import org.openbp.common.commandline.CommandLineParserException;
import org.openbp.common.setting.PropertyFileProvider;
import org.openbp.common.setting.SettingProvider;
import org.openbp.common.setting.SettingUtil;

public final class ConfigMgr {
    private PropertyFileProvider provider;
    private String configResourceName;
    public static final String STD_CONFIG_FILE = "config";
    private static ConfigMgr singletonInstance;

    public static synchronized ConfigMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ConfigMgr();
        }
        return singletonInstance;
    }

    private ConfigMgr() {
    }

    public String getConfigResourceName() {
        return this.configResourceName;
    }

    public void setConfigResourceName(String configResourceName) {
        this.configResourceName = configResourceName;
    }

    public void initialize() {
        String[] args;
        boolean first = false;
        if (this.provider == null) {
            this.provider = new PropertyFileProvider();
            this.provider.setReadonly(true);
            first = true;
        } else {
            this.provider.clear();
        }
        if (this.getConfigResourceName() != null) {
            this.readPropertyResource(this.getConfigResourceName(), false);
        }
        if ((args = Application.getArguments()) != null) {
            CommandLineParser cp = new CommandLineParser();
            cp.setAcceptUnknownOptions(true);
            cp.addRepeatableOption("propertyFile", "Name of a property resource containing configuration information");
            cp.addRepeatableOption("property", "Configuration property value");
            try {
                String[] propertyKeys;
                cp.parse(args);
                String[] propertyFiles = cp.getRepeatableOption("propertyFile");
                if (propertyFiles != null) {
                    for (int i = 0; i < propertyFiles.length; ++i) {
                        String file = propertyFiles[i];
                        this.readPropertyResource(file, true);
                    }
                }
                if ((propertyKeys = cp.getRepeatableOption("property")) != null) {
                    for (int i = 0; i < propertyKeys.length; ++i) {
                        String prop = propertyKeys[i];
                        String key = null;
                        String value = "true";
                        int index = prop.indexOf("=");
                        if (index > 0) {
                            key = prop.substring(0, index);
                            value = prop.substring(index + 1);
                        } else {
                            key = prop;
                        }
                        this.setValue(key, value);
                    }
                }
            }
            catch (CommandLineParserException e) {
                System.err.println(e.getMessage());
                System.err.println("");
                cp.printUsageAndExit();
            }
        }
        if (first) {
            SettingUtil.getStandardResolver().addProvider("ConfigMgr", (SettingProvider)this.provider, 200);
        }
    }

    public void readPropertyResource(String propertyResourceName, boolean mandatory) {
        this.provider.setPropertyResourceName(propertyResourceName);
        this.provider.setMandatory(mandatory);
        this.provider.loadSettings();
    }

    public boolean evaluate(String cond) {
        if (cond == null) {
            return true;
        }
        return this.isDefined(cond);
    }

    public boolean isDefined(String key) {
        String value = this.getValue(key);
        return value != null && !value.equals("false") && !value.equals("no") && !value.equals("null");
    }

    public String getValue(String key) {
        return SettingUtil.getStringSetting((String)key);
    }

    public void setValue(String key, String value) {
        this.provider.setSetting(key, (Object)value);
    }
}

