/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.classloader.XClassLoader;
import org.openbp.common.classloader.XClassLoaderConfiguration;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.setting.SettingUtil;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.ConfigMgr;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginProfile;
import org.openbp.jaspira.plugin.PluginState;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class PluginMgr {
    public static final int PLUGIN_NOT_LOADED = 0;
    public static final int PLUGIN_CLASS_LOADED = 1;
    public static final int PLUGIN_HAS_INSTANCES = 2;
    public static final int PLUGIN_LOAD_FAILED = -1;
    private static PluginMgr singletonInstance = new PluginMgr();
    private Map pluginClasses = new HashMap();
    private transient ClassLoader classloader;

    private PluginMgr() {
    }

    public static synchronized PluginMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new PluginMgr();
        }
        return singletonInstance;
    }

    public Plugin getPlugin(String uniqueId) {
        String classname = uniqueId.substring(0, uniqueId.indexOf("@"));
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(classname);
        if (entry != null) {
            return entry.getPluginInstance(uniqueId);
        }
        return null;
    }

    public Plugin createInstance(String classname, Plugin parent) {
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(classname);
        if (entry == null) {
            entry = new PluginEntry(classname);
            this.pluginClasses.put(classname, entry);
        }
        return entry.createInstance(parent);
    }

    public Plugin createInstance(PluginProfile profile, ClassLoader pluginClassLoader, Plugin parent) {
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(profile.getClassName());
        if (entry == null) {
            entry = new PluginEntry(profile);
            entry.setPluginClassLoader(pluginClassLoader);
            this.pluginClasses.put(profile.getClassName(), entry);
        }
        return entry.createInstance(parent);
    }

    public Plugin createInstance(Class cls, Plugin parent) {
        return this.createInstance(cls.getName(), parent);
    }

    public Plugin createInstance(PluginState state, Plugin parent) {
        String classname = state.getPluginClassName();
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(classname);
        if (entry == null) {
            entry = new PluginEntry(classname);
            this.pluginClasses.put(classname, entry);
        }
        return entry.createInstance(state, parent);
    }

    public VisiblePlugin createVisibleInstance(String classname, Plugin parent) {
        return (VisiblePlugin)this.createInstance(classname, parent);
    }

    public VisiblePlugin createVisibleInstance(Class cls, Plugin parent) {
        return (VisiblePlugin)this.createInstance(cls, parent);
    }

    public VisiblePlugin createVisibleInstance(PluginState state, Plugin parent) {
        return (VisiblePlugin)this.createInstance(state, parent);
    }

    public Plugin createCopy(Plugin source) {
        return this.createInstance(source.getPluginState(), source.getParentPlugin());
    }

    public void registerPlugin(Plugin plugin) {
        String classname = plugin.getClass().getName();
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(classname);
        if (entry == null) {
            entry = new PluginEntry(classname);
            this.pluginClasses.put(classname, entry);
        }
        entry.addInstance(plugin, null);
    }

    public boolean removeInstance(String uniqueId) {
        return this.removeInstance(this.getPlugin(uniqueId));
    }

    public boolean removeInstance(Plugin plugin) {
        if (plugin == null) {
            return true;
        }
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(plugin.getClass().getName());
        if (entry != null) {
            return entry.removeInstance(plugin);
        }
        return true;
    }

    public Iterator getPluginInstances(String classname) {
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(classname);
        return entry != null ? entry.getPluginInstances() : EmptyIterator.getInstance();
    }

    public Plugin getPluginInstance(String classname) {
        Iterator it;
        PluginEntry entry = (PluginEntry)this.pluginClasses.get(classname);
        if (entry != null && (it = entry.getPluginInstances()).hasNext()) {
            return (Plugin)it.next();
        }
        return null;
    }

    public List getPluginInstances() {
        ArrayList list = new ArrayList();
        for (PluginEntry entry : this.pluginClasses.values()) {
            Iterator it2 = entry.getPluginInstances();
            while (it2.hasNext()) {
                list.add(it2.next());
            }
        }
        return list;
    }

    ClassLoader getClassLoader() {
        if (this.classloader == null) {
            this.classloader = this.getClass().getClassLoader();
        }
        return this.classloader;
    }

    public void loadCustomPlugins(String settingName) {
        String strList = SettingUtil.getStringSetting((String)settingName, null);
        if (strList != null) {
            StringTokenizer st = new StringTokenizer(strList, " ,");
            while (st.hasMoreTokens()) {
                String pluginClassName = st.nextToken();
                if (pluginClassName.length() == 0) continue;
                try {
                    this.createInstance(pluginClassName, (Plugin)ApplicationBase.getInstance());
                }
                catch (Exception e) {
                    LogUtil.error(this.getClass(), (String)"Error loading custom plugin $0.", (Object)pluginClassName, (Object)e);
                    ExceptionUtil.printTrace((Throwable)e);
                }
            }
        }
    }

    public void loadPluginsFromResource() {
        XMLDriver xmlDriver = XMLDriver.getInstance();
        try {
            Class[] profileClasses = new Class[]{PluginProfile.class};
            xmlDriver.loadMappings(profileClasses);
        }
        catch (XMLDriverException e) {
            ExceptionUtil.printTrace((Throwable)e);
            return;
        }
        ResourceMgr resMgr = ResourceMgr.getDefaultInstance();
        String resourcePattern = "plugin/*/*.plugin.xml";
        Resource[] resources = null;
        try {
            resources = resMgr.findResources(resourcePattern);
        }
        catch (ResourceMgrException e) {
            return;
        }
        for (int i = 0; i < resources.length; ++i) {
            PluginProfile profile = null;
            try {
                profile = (PluginProfile)xmlDriver.deserializeResource(PluginProfile.class, resources[i]);
            }
            catch (XMLDriverException e) {
                LogUtil.error(this.getClass(), (String)"Error reading plugin profile $0.", (Object)resources[i].getDescription(), (Object)((Object)e));
                continue;
            }
            String pluginName = profile.getName();
            if (pluginName == null) {
                pluginName = profile.getClassName();
            }
            LogUtil.info(this.getClass(), (String)"Loading plugin $0.", (Object)pluginName);
            try {
                ClassLoader pluginClassLoader = this.obtainPluginClassLoader(resources[i], pluginName);
                this.createInstance(profile, pluginClassLoader, ApplicationBase.getInstance());
                continue;
            }
            catch (Throwable t) {
                LogUtil.error(this.getClass(), (String)"Error loading custom plugin $0.", (Object)resources[i].getDescription(), (Object)t);
            }
        }
    }

    private ClassLoader obtainPluginClassLoader(Resource r, String pluginName) {
        ClassLoader cl = this.getClassLoader();
        if (r instanceof FileSystemResource) {
            XClassLoaderConfiguration config = new XClassLoaderConfiguration();
            config.setName("Plugin '" + pluginName + "' class loader");
            config.setParentClassLoader(cl);
            config.setLoggingEnabled(false);
            FilenameFilter fnf = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            };
            File pluginDir = null;
            try {
                pluginDir = r.getFile().getParentFile();
                File[] jars = pluginDir.listFiles(fnf);
                for (int i = 0; i < jars.length; ++i) {
                    config.addRepository(jars[i].getAbsolutePath());
                    LogUtil.info(this.getClass(), (String)"Loading repository for plugin $0: $1.", (Object)pluginName, (Object)jars[i]);
                }
                cl = new XClassLoader(config);
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
        return cl;
    }

    protected class PluginEntry {
        private String pluginClassName;
        private ClassLoader pluginClassLoader;
        private PluginProfile profile;
        protected transient Class pluginClass;
        protected Map instances;
        protected int status;

        public PluginEntry(String pluginClassName) {
            this.pluginClassName = pluginClassName;
            this.status = 0;
        }

        public PluginEntry(PluginProfile profile) {
            this.profile = profile;
            this.pluginClassName = profile.getClassName();
            this.status = 0;
        }

        public String getPluginClassName() {
            return this.pluginClassName;
        }

        public ClassLoader getPluginClassLoader() {
            if (this.pluginClassLoader != null) {
                return this.pluginClassLoader;
            }
            return PluginMgr.this.getClassLoader();
        }

        public void setPluginClassLoader(ClassLoader pluginClassLoader) {
            this.pluginClassLoader = pluginClassLoader;
        }

        private Class getPluginClass() {
            if (this.pluginClass == null && this.status != -1) {
                try {
                    ClassLoader cl = this.getPluginClassLoader();
                    this.pluginClass = cl.loadClass(this.pluginClassName);
                    this.status = 1;
                }
                catch (ClassNotFoundException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    this.status = -1;
                }
            }
            return this.pluginClass;
        }

        public Plugin getPluginInstance(String uniqueId) {
            return (Plugin)this.instances.get(uniqueId);
        }

        public Iterator getPluginInstances() {
            return this.instances == null ? EmptyIterator.getInstance() : this.instances.values().iterator();
        }

        public Plugin createInstance(PluginState state, Plugin parent) {
            Plugin instance = this.createInstance(parent);
            if (instance != null) {
                instance.setPluginState(state);
            }
            return instance;
        }

        public Plugin createInstance(Plugin parent) {
            Class appClass = this.getPluginClass();
            Plugin plugin = null;
            if (appClass != null) {
                try {
                    ClassLoader cl = this.getPluginClassLoader();
                    plugin = (Plugin)ReflectUtil.instantiate((Class)appClass, (ClassLoader)cl, Plugin.class, (String)"plugin");
                    if (!ConfigMgr.getInstance().evaluate(plugin.getCondition())) {
                        return null;
                    }
                    if (this.profile != null && plugin instanceof AbstractPlugin) {
                        ((AbstractPlugin)plugin).initializeFromPluginProfile(this.profile);
                    }
                    plugin.initializePlugin();
                    this.status = 2;
                    this.addInstance(plugin, parent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.status = -1;
                }
            }
            return plugin;
        }

        public void addInstance(Plugin plugin, Plugin parent) {
            if (this.instances == null) {
                this.instances = new HashMap();
            }
            if (this.instances.isEmpty()) {
                plugin.installFirstPlugin();
            }
            plugin.installPlugin();
            this.instances.put(plugin.getUniqueId(), plugin);
            plugin.setParentPlugin(parent);
        }

        public boolean removeInstance(Plugin plugin) {
            if (this.instances.get(plugin.getUniqueId()) != null) {
                VisiblePlugin vp;
                plugin.setParentPlugin(null);
                if (plugin instanceof VisiblePlugin && (vp = (VisiblePlugin)plugin).getPluginHolder() != null) {
                    vp.getPluginHolder().unlinkHolder();
                }
                plugin.uninstallPlugin();
                this.instances.remove(plugin.getUniqueId());
                if (this.instances.size() == 0) {
                    plugin.uninstallLastPlugin();
                    this.status = 1;
                }
            }
            return this.instances.isEmpty();
        }
    }
}

