/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.swing.components.treetable.DefaultTableCellRenderer;

public class PluginMgrPlugin
extends AbstractVisiblePlugin {
    private static final Dimension MINIMUMSIZE = new Dimension(800, 600);

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.standard";
    }

    @Override
    protected void initializeComponents() {
        JTable pluginTable = new JTable(new PluginTableModel());
        TableColumnModel cmodel = pluginTable.getColumnModel();
        cmodel.getColumn(0).setMinWidth(100);
        cmodel.getColumn(1).setMinWidth(200);
        cmodel.getColumn(2).setMinWidth(20);
        cmodel.getColumn(2).setMaxWidth(80);
        pluginTable.setRowHeight(20);
        pluginTable.setDefaultRenderer(Plugin.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 0) {
                    Plugin plugin = (Plugin)value;
                    JLabel label = (JLabel)comp;
                    label.setIcon(plugin.getIcon().getIcon(16));
                    label.setText(plugin.getTitle());
                }
                return comp;
            }
        });
        JPanel cp = this.getContentPane();
        cp.add(new JScrollPane(pluginTable));
        cp.setMinimumSize(MINIMUMSIZE);
        cp.setPreferredSize(MINIMUMSIZE);
    }

    public class PluginTableModel
    implements TableModel {
        private Set pluginset;

        public PluginTableModel() {
            this.pluginset = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Plugin)o1).getTitle().compareTo(((Plugin)o2).getTitle());
                }

                @Override
                public boolean equals(Object arg0) {
                    return false;
                }
            });
            this.pluginset.addAll(PluginMgr.getInstance().getPluginInstances());
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return Plugin.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return PluginMgrPlugin.this.getPluginResourceCollection().getRequiredString("plugintable.header.title");
                }
                case 1: {
                    return PluginMgrPlugin.this.getPluginResourceCollection().getRequiredString("plugintable.header.description");
                }
            }
            return PluginMgrPlugin.this.getPluginResourceCollection().getRequiredString("plugintable.header.ui");
        }

        @Override
        public int getRowCount() {
            return this.pluginset.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Iterator it = this.pluginset.iterator();
            for (int i = 0; i < row; ++i) {
                it.next();
            }
            Plugin plugin = (Plugin)it.next();
            switch (column) {
                case 0: {
                    return plugin;
                }
                case 1: {
                    return plugin.getDescription();
                }
            }
            return plugin.getUniqueId().substring(plugin.getClassName().length() + 1);
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
        }

        @Override
        public void addTableModelListener(TableModelListener listener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener listener) {
        }
    }
}

