/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugins.errordialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.markup.HTMLEscapeHelper;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JStandardDialog;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class ErrorDialog
extends JStandardDialog {
    public static String KEY_BUTTON_CLOSE = "errordialog.close";
    public static String KEY_TITLE = "errordialog.title";
    public static String KEY_BUTTON_DETAILS_TEXT = "errordialog.button.detail.text";
    public static String KEY_NO_MESSAGE = "errordialog.nomessage";
    static String DEFAULT_BUTTON_CLOSE = "Close";
    static String DEFAULT_TITLE = "Error dialog";
    static String DEFAULT_NO_MESSAGE = "No error message available";
    static String DEFAULT_BUTTON_DETAILS = "Details";
    static final int DEFAULT_WIDTH = 600;
    static final int REGULAR_HEIGHT = 200;
    static final int DETAIL_HEIGHT = 400;
    private String message;
    private Throwable throwable;
    private String stackTraceString;
    private JPanel detailPanel;
    private boolean detailsInitialized;
    private JToggleButton detailButton;
    private static ResourceCollection resourceCollection;

    public static JDialog showDialog(JFrame frame, boolean modal, String message, Throwable t) {
        return ErrorDialog.showDialog(frame, modal, message, t, null);
    }

    public static JDialog showDialog(JFrame frame, boolean modal, String message, String exceptionString) {
        return ErrorDialog.showDialog(frame, modal, message, null, exceptionString);
    }

    static JDialog showDialog(JFrame frame, boolean modal, String message, Throwable t, String exceptionString) {
        ErrorDialog ed = new ErrorDialog(frame, modal);
        ed.setMessage(message);
        if (t != null) {
            ed.setThrowable(t);
        }
        if (exceptionString != null) {
            ed.setStackTraceString(exceptionString);
        }
        ed.initialize();
        ed.setLocationRelativeTo(frame);
        SwingUtil.show((JDialog)((Object)ed));
        return ed;
    }

    public static void setResourceCollection(ResourceCollection resourceArg) {
        resourceCollection = resourceArg;
    }

    public ErrorDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
    }

    void setMessage(String message) {
        this.message = message;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.stackTraceString = ExceptionUtil.getNestedTrace((Throwable)throwable);
    }

    void setStackTraceString(String stacktrace) {
        this.stackTraceString = stacktrace;
    }

    public void initialize() {
        this.setTitle(resourceCollection.getOptionalString(KEY_TITLE, DEFAULT_TITLE));
        this.getOkBtn().setText(resourceCollection.getOptionalString(KEY_BUTTON_CLOSE, DEFAULT_BUTTON_CLOSE));
        this.getCancelBtn().setVisible(false);
        JPanel buttonPanel = this.getBtnPane();
        this.detailButton = new JToggleButton();
        String text = resourceCollection.getOptionalString(KEY_BUTTON_DETAILS_TEXT, DEFAULT_BUTTON_DETAILS);
        this.detailButton.setText(text);
        this.detailButton.addActionListener(new DetailActionListener());
        buttonPanel.add((Component)this.detailButton, 1);
        this.createCenterPanel();
        this.pack();
    }

    private void createCenterPanel() {
        JPanel pane = new JPanel();
        this.getMainPane().add((Component)pane, "Center");
        pane.setBorder(new EmptyBorder(5, 5, 5, 5));
        pane.setBackground(this.getMainPane().getBackground());
        BoxLayout layout = new BoxLayout(pane, 1);
        pane.setLayout(layout);
        Dimension size = new Dimension(600, 200);
        pane.setMinimumSize(size);
        pane.setPreferredSize(size);
        StringBuffer buf = new StringBuffer(200);
        if (this.message != null) {
            buf.append(this.message);
            buf.append("\n\n");
        }
        if (this.throwable != null && this.throwable.getMessage() != null) {
            buf.append(this.throwable.getMessage());
        } else if (this.stackTraceString != null) {
            String s = this.stackTraceString;
            if (s.startsWith("java.lang.")) {
                int pos = this.stackTraceString.indexOf(10);
                if (pos > 0) {
                    s = this.stackTraceString.substring(0, pos);
                }
            } else {
                int pos1 = this.stackTraceString.indexOf(58) + 2;
                int pos2 = this.stackTraceString.indexOf("\tat", pos1);
                if (pos1 >= 10 && pos2 > 0 && pos1 < pos2) {
                    s = this.stackTraceString.substring(pos1, pos2);
                }
            }
            buf.append(s);
        }
        if (buf.length() == 0) {
            buf.append(resourceCollection.getOptionalString(KEY_NO_MESSAGE, DEFAULT_NO_MESSAGE));
        }
        int lines = 0;
        for (int i = buf.length() - 1; i >= 0; --i) {
            if (buf.charAt(i) != '\n') continue;
            ++lines;
        }
        Box messageBox = Box.createHorizontalBox();
        Icon icon = (Icon)UIManager.get("OptionPane.warningIcon");
        String s = buf.toString();
        s = HTMLEscapeHelper.htmlescape((String)s);
        JLabel label = new JLabel("<html>" + s + "<br></html>");
        label.setBorder(new EmptyBorder(10, 10, 10, 10));
        label.setIcon(icon);
        label.setIconTextGap(15);
        label.setVerticalAlignment(1);
        label.setVerticalTextPosition(1);
        if (lines > 5) {
            messageBox.add(new JScrollPane(label));
        } else {
            messageBox.add(label);
        }
        messageBox.add(Box.createHorizontalGlue());
        pane.add(messageBox);
        this.detailPanel = new JPanel();
        this.detailPanel.setVisible(false);
        pane.add(this.detailPanel);
    }

    private class DetailActionListener
    implements ActionListener {
        private DetailActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean showDetails;
            boolean bl = showDetails = !((JToggleButton)e.getSource()).isSelected();
            if (!showDetails && !ErrorDialog.this.detailsInitialized) {
                ErrorDialog.this.detailPanel.setLayout(new BorderLayout());
                ErrorDialog.this.detailPanel.setBorder((Border)SimpleBorder.getStandardBorder());
                JTextArea stackTrace = new JTextArea();
                JScrollPane scrollPane = new JScrollPane(stackTrace);
                scrollPane.getViewport().setViewPosition(new Point(0, 0));
                ErrorDialog.this.detailPanel.add((Component)scrollPane, "Center");
                stackTrace.setEditable(false);
                stackTrace.setText(ErrorDialog.this.stackTraceString);
                ErrorDialog.this.detailsInitialized = true;
            }
            showDetails = !showDetails;
            ErrorDialog.this.detailPanel.setVisible(showDetails);
            JPanel panel = (JPanel)ErrorDialog.this.getContentPane();
            Dimension size = panel.getSize();
            if (size.width < 1) {
                size.width = 1;
            }
            size.height = showDetails ? 400 : 200;
            panel.setPreferredSize(size);
            ErrorDialog.this.pack();
        }
    }
}

