/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugins.statusbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugins.statusbar.StatusBarComponentEvent;
import org.openbp.jaspira.plugins.statusbar.StatusBarTextEvent;
import org.openbp.swing.SwingUtil;

public class StatusBarPlugin
extends AbstractVisiblePlugin {
    private static final Dimension MIN_SIZE = new Dimension(20, 22);
    private static final Dimension MIN_TEXT_SIZE = new Dimension(200, 20);
    private static final Dimension MAX_TEXT_SIZE = new Dimension(20000, 20);
    private static final Dimension MIN_PROGRESS_SIZE = new Dimension(200, 20);
    private static final int TEXT_TIME = 5000;
    private static final int BUSY_TIME = 20000;
    private JLabel text;
    private Timer textTimer;
    private Timer busyTimer;
    private Window window;
    private JProgressBar progressBar;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.standard";
    }

    @Override
    protected void initializeComponents() {
        JPanel cp = this.getContentPane();
        cp.setLayout(new BoxLayout(cp, 2));
        cp.setBorder(new StatusBarBorder());
        cp.setMinimumSize(MIN_SIZE);
        cp.setMaximumSize(MIN_SIZE);
        cp.setPreferredSize(MIN_SIZE);
        cp.add(Box.createHorizontalStrut(3));
        this.text = new JLabel();
        this.text.setMinimumSize(MIN_TEXT_SIZE);
        this.text.setPreferredSize(MAX_TEXT_SIZE);
        cp.add(this.text);
        cp.add(Box.createHorizontalStrut(10));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.progressBar.setMinimumSize(MIN_PROGRESS_SIZE);
        this.progressBar.setMaximumSize(MIN_PROGRESS_SIZE);
        this.progressBar.setPreferredSize(MIN_PROGRESS_SIZE);
        cp.add(this.progressBar);
        cp.add(Box.createHorizontalStrut(1));
    }

    public Window getWindow() {
        if (this.window == null) {
            this.window = SwingUtilities.getWindowAncestor(this.getPluginComponent());
        }
        return this.window;
    }

    protected void updateStatusBar() {
    }

    protected void startTextTimer() {
        if (this.textTimer == null) {
            this.textTimer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StatusBarPlugin.this.text != null) {
                        StatusBarPlugin.this.text.setText(null);
                    }
                }
            });
            this.textTimer.start();
        } else if (this.textTimer.isRunning()) {
            this.textTimer.restart();
        } else {
            this.textTimer.start();
        }
    }

    protected void startBusyTimer() {
        if (this.busyTimer == null) {
            this.busyTimer = new Timer(20000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StatusBarPlugin.this.progressBar.setIndeterminate(false);
                    StatusBarPlugin.this.progressBar.setValue(0);
                    SwingUtil.waitCursorOff((Component)StatusBarPlugin.this.getPluginComponent());
                }
            });
            this.busyTimer.start();
        } else if (this.busyTimer.isRunning()) {
            this.busyTimer.restart();
        } else {
            this.busyTimer.start();
        }
    }

    public static class StatusBarBorder
    extends AbstractBorder {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.gray);
            g.drawRect(x + 1, y + 1, width - 2, height - 2);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "statusbar";
        }

        @Override
        public int getModuleType() {
            return 1;
        }

        public JaspiraEventHandlerCode updatetext(StatusBarTextEvent event) {
            if (StatusBarPlugin.this.text != null && event != null) {
                StatusBarPlugin.this.text.setText(event.getText());
                StatusBarPlugin.this.updateStatusBar();
            }
            StatusBarPlugin.this.startTextTimer();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode busy(JaspiraEvent je) {
            StatusBarPlugin.this.progressBar.setIndeterminate(true);
            StatusBarPlugin.this.updateStatusBar();
            StatusBarPlugin.this.startBusyTimer();
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode unbusy(JaspiraEvent je) {
            StatusBarPlugin.this.progressBar.setIndeterminate(false);
            StatusBarPlugin.this.progressBar.setValue(0);
            StatusBarPlugin.this.updateStatusBar();
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode step(JaspiraEvent je) {
            StatusBarPlugin.this.progressBar.setIndeterminate(false);
            StatusBarPlugin.this.progressBar.setValue((int)(((Float)je.getObject()).floatValue() * 100.0f));
            StatusBarPlugin.this.updateStatusBar();
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode managecomponent(StatusBarComponentEvent event) {
            JPanel cp = StatusBarPlugin.this.getContentPane();
            switch (event.getOperation()) {
                case 1: {
                    cp.add(event.getNewComponent());
                    return EVENT_CONSUMED;
                }
                case 2: {
                    cp.remove(event.getOldComponent());
                    return EVENT_CONSUMED;
                }
            }
            cp.remove(event.getOldComponent());
            cp.add(event.getNewComponent());
            return EVENT_CONSUMED;
        }
    }
}

