/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.common.CollectionUtil;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.propertybrowser.CollectionDescriptor;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.common.string.TextUtil;
import org.openbp.common.util.CopyUtil;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraPopupMenu;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.jaspira.gui.StdIcons;
import org.openbp.jaspira.gui.clipboard.ClipboardMgr;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.propertybrowser.ObjectChangeListener;
import org.openbp.jaspira.propertybrowser.ObjectValidator;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserEvent;
import org.openbp.jaspira.propertybrowser.PropertyBrowserListener;
import org.openbp.jaspira.propertybrowser.PropertyBrowserModel;
import org.openbp.jaspira.propertybrowser.SaveStrategy;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;
import org.openbp.jaspira.propertybrowser.nodes.AbstractNode;
import org.openbp.jaspira.propertybrowser.nodes.CollectionNode;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;
import org.openbp.swing.components.treetable.DefaultTableCellEditor;
import org.openbp.swing.components.treetable.DefaultTableCellRenderer;
import org.openbp.swing.components.treetable.DefaultTreeCellRenderer;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.TreeTableModel;
import org.openbp.swing.components.treetable.resize.ColumnSizeConstraint;
import org.openbp.swing.components.treetable.resize.RatioConstraint;

public class PropertyBrowserImpl
extends JTreeTable
implements PropertyBrowser,
MouseListener,
TreeSelectionListener,
FocusListener {
    private Object object;
    private Object modifiedObject;
    private Object originalObject;
    private boolean isObjectNew;
    private String[] visibleMembers;
    private List objectChangeListenerList;
    private SaveStrategy saveStrategy;
    private EventListenerList editListenerList;
    private MultiIcon rootIcon;
    private ResourceCollection resourceCollection;
    private boolean saveImmediately;
    private boolean showTooltips;
    private static PropertyCellEditor propertyCellEditor;
    private static PropertyCellRenderer propertyCellRenderer;
    private JaspiraAction[] actions;
    private static final int NACTIONS = 7;
    private static final int ACTION_INDEX_ADD = 0;
    private static final int ACTION_INDEX_COPY = 1;
    private static final int ACTION_INDEX_CUT = 2;
    private static final int ACTION_INDEX_PASTE = 3;
    private static final int ACTION_INDEX_REMOVE = 4;
    private static final int ACTION_INDEX_MOVEUP = 5;
    private static final int ACTION_INDEX_MOVEDOWN = 6;
    private PropertyEditor currentPE;
    private AbstractNode currentNode;
    private boolean objectModified;
    private boolean saveDisabled;
    private boolean performingSave;
    private static final Color tableBackground;
    private static final Color tableForeground;
    private static final Color tableSelectionBackground;
    private static final Color tableSelectionForeground;

    public PropertyBrowserImpl(SaveStrategy saveStrategy, ResourceCollection resourceCollection) {
        super((TreeTableModel)new PropertyBrowserModel());
        if (resourceCollection == null) {
            resourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("jaspira", this.getClass());
        }
        this.resourceCollection = resourceCollection;
        this.setTableHeader(null);
        PropertyBrowserModel model = (PropertyBrowserModel)((Object)this.getModel());
        model.setPropertyBrowser(this);
        model.setResourceCollection(resourceCollection);
        this.saveStrategy = saveStrategy;
        if (propertyCellRenderer == null) {
            propertyCellRenderer = new PropertyCellRenderer();
        }
        this.setDefaultRenderer(PropertyEditor.class, (TableCellRenderer)((Object)propertyCellRenderer));
        if (propertyCellEditor == null) {
            propertyCellEditor = new PropertyCellEditor();
        }
        this.setDefaultEditor(PropertyEditor.class, (TableCellEditor)((Object)propertyCellEditor));
        this.getTree().setCellRenderer((javax.swing.tree.TreeCellRenderer)((Object)new TreeCellRenderer(this)));
        this.getTree().getSelectionModel().addTreeSelectionListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.setRootVisible(false);
        this.setRowSelectionAllowed(false);
        RatioConstraint csc = new RatioConstraint(new int[]{1, 2}, true);
        csc.setMinimumOfColumn(200, 1, (JTreeTable)this);
        this.setColumnSizeConstraint((ColumnSizeConstraint)csc);
        this.createActions();
        this.processSelection(null);
    }

    private void createActions() {
        this.actions = new JaspiraAction[7];
        this.actions[0] = new JaspiraAction(this.resourceCollection, "propertybrowser.addelement"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final AbstractNode newPos = PropertyBrowserImpl.this.addNewNode();
                if (newPos != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PropertyBrowserImpl.this.selectNode(newPos, 1, 1);
                                }
                            });
                        }
                    });
                }
            }
        };
        this.actions[1] = new JaspiraAction(this.resourceCollection, "propertybrowser.copyelement"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PropertyBrowserImpl.this.copyNode();
                PropertyBrowserImpl.this.updateActionState();
            }
        };
        this.actions[2] = new JaspiraAction(this.resourceCollection, "propertybrowser.cutelement"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PropertyBrowserImpl.this.copyNode();
                AbstractNode newPos = PropertyBrowserImpl.this.removeNode();
                if (newPos != null) {
                    PropertyBrowserImpl.this.selectNode(newPos, 0, 0);
                }
                PropertyBrowserImpl.this.updateActionState();
            }
        };
        this.actions[3] = new JaspiraAction(this.resourceCollection, "propertybrowser.pasteelement"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final AbstractNode newPos = PropertyBrowserImpl.this.pasteNode();
                if (newPos != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PropertyBrowserImpl.this.selectNode(newPos, 1, 1);
                                }
                            });
                        }
                    });
                }
            }
        };
        this.actions[4] = new JaspiraAction(this.resourceCollection, "propertybrowser.removeelement"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AbstractNode newPos = PropertyBrowserImpl.this.removeNode();
                if (newPos != null) {
                    PropertyBrowserImpl.this.selectNode(newPos, 0, 0);
                }
            }
        };
        this.actions[5] = new JaspiraAction(this.resourceCollection, "propertybrowser.moveelementup"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PropertyBrowserImpl.this.moveNodeUp();
            }
        };
        this.actions[6] = new JaspiraAction(this.resourceCollection, "propertybrowser.moveelementdown"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PropertyBrowserImpl.this.moveNodeDown();
            }
        };
        this.setupActionKeys();
    }

    protected void setupActionKeys() {
        InputMap focusInputMap = new InputMap();
        focusInputMap.setParent(SwingUtilities.getUIInputMap((JComponent)((Object)this), 0));
        InputMap focusAncestorInputMap = new InputMap();
        focusAncestorInputMap.setParent(SwingUtilities.getUIInputMap((JComponent)((Object)this), 1));
        ActionMap actionMap = new ActionMap();
        actionMap.setParent(SwingUtilities.getUIActionMap((JComponent)((Object)this)));
        for (int i = 0; i < this.actions.length; ++i) {
            JaspiraAction action = this.actions[i];
            KeySequence[] sequences = action.getKeySequences();
            if (sequences == null) continue;
            for (int is = 0; is < sequences.length; ++is) {
                KeySequence sequence = sequences[is];
                if (sequence.length() != 1) continue;
                String actionId = "OE" + i;
                KeyStroke ks = sequence.getKeyAt(0);
                focusInputMap.put(ks, actionId);
                focusAncestorInputMap.put(ks, actionId);
                actionMap.put(actionId, action);
            }
        }
        SwingUtilities.replaceUIInputMap((JComponent)((Object)this), 0, focusInputMap);
        SwingUtilities.replaceUIInputMap((JComponent)((Object)this), 1, focusAncestorInputMap);
        SwingUtilities.replaceUIActionMap((JComponent)((Object)this), actionMap);
    }

    @Override
    public void setObject(Object object, boolean isObjectNew) throws XMLDriverException, CloneNotSupportedException {
        this.setObject(object, null, isObjectNew, null, null);
    }

    @Override
    public void setObject(Object object, boolean isObjectNew, ObjectNode rootNode) throws XMLDriverException, CloneNotSupportedException {
        this.setObject(object, null, isObjectNew, null, rootNode);
    }

    @Override
    public void setObject(Object object, boolean isObjectNew, MultiIcon rootIcon) throws XMLDriverException, CloneNotSupportedException {
        this.setObject(object, null, isObjectNew, rootIcon);
    }

    @Override
    public void setObject(Object object, Object modifiedObject, boolean isObjectNew, MultiIcon rootIcon) throws XMLDriverException, CloneNotSupportedException {
        this.setObject(object, modifiedObject, isObjectNew, rootIcon, null);
    }

    @Override
    public void setObject(Object object, Object modifiedObject, boolean isObjectNew, MultiIcon rootIcon, ObjectNode rootNode) throws XMLDriverException, CloneNotSupportedException {
        if (!this.saveObject()) {
            return;
        }
        this.object = object;
        if (object != null && modifiedObject == null) {
            modifiedObject = CopyUtil.copyObject((Object)object, (int)1, null);
        }
        this.modifiedObject = modifiedObject;
        this.isObjectNew = isObjectNew;
        this.setRootIcon(rootIcon);
        PropertyBrowserModel model = (PropertyBrowserModel)((Object)this.getModel());
        model.setVisibleMembers(this.visibleMembers);
        model.setObject(modifiedObject, rootNode);
        this.currentRow = -1;
        this.currentCol = -1;
        this.currentNode = null;
        this.processSelection(null);
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Object getModifiedObject() {
        if (this.objectModified) {
            return this.modifiedObject;
        }
        return null;
    }

    @Override
    public Object getOriginalObject() {
        return this.originalObject;
    }

    @Override
    public void setOriginalObject(Object originalObject) {
        this.originalObject = originalObject;
    }

    @Override
    public boolean isObjectNew() {
        return this.isObjectNew;
    }

    @Override
    public void setObjectNew(boolean isObjectNew) {
        this.isObjectNew = isObjectNew;
    }

    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    public void setSaveStrategy(SaveStrategy saveStrategy) {
        this.saveStrategy = saveStrategy;
    }

    @Override
    public boolean isObjectModified() {
        return this.objectModified;
    }

    @Override
    public void setObjectModified(boolean objectModified) {
        JaspiraAction action;
        this.objectModified = objectModified;
        this.saveDisabled = false;
        if (!this.saveImmediately && (action = ActionMgr.getInstance().getAction("standard.file.save")) != null) {
            action.setEnabled(objectModified);
        }
    }

    public void disableSave() {
        this.saveDisabled = true;
    }

    public void enableSave() {
        this.saveDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveObject() {
        if (this.performingSave || this.saveDisabled) {
            return false;
        }
        try {
            ObjectValidator validator;
            this.performingSave = true;
            if (this.currentPE != null && !this.currentPE.saveProperty()) {
                boolean bl = false;
                return bl;
            }
            if (this.getModifiedObject() == null) {
                boolean bl = true;
                return bl;
            }
            if (!this.objectModified || this.saveStrategy == null) {
                boolean bl = true;
                return bl;
            }
            ObjectNode root = (ObjectNode)((PropertyBrowserModel)((Object)this.getModel())).getRoot();
            if (root != null && (validator = root.getValidator()) != null && !validator.validateObject(this.modifiedObject, this)) {
                this.saveDisabled = true;
                boolean bl = false;
                return bl;
            }
            boolean saved = this.saveStrategy.executeSave(this);
            if (saved) {
                this.setObjectModified(false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.performingSave = false;
        }
    }

    @Override
    public boolean reset() {
        try {
            Object object = this.getObject();
            this.setObjectModified(false);
            this.setObject(object, null, this.isObjectNew, null);
            this.fireObjectChanged();
            return true;
        }
        catch (XMLDriverException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (CloneNotSupportedException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        return false;
    }

    public AbstractNode addNewNode() {
        if (this.currentNode == null) {
            return null;
        }
        CollectionNode cdn = this.currentNode.getAssociatedCollectionNode();
        if (cdn == null) {
            return null;
        }
        AbstractNode objectNode = cdn == this.currentNode ? this.currentNode : this.currentNode.getObjectNode();
        TreePath path = this.getPathByNode((TreeNode)((Object)cdn));
        this.expandPath(path);
        AbstractNode newNode = cdn.addNewNodeAfter(objectNode, null);
        if (newNode != null) {
            path = this.getPathByNode((TreeNode)((Object)newNode));
            this.expandPath(path);
            if (this.saveImmediately) {
                this.fireObjectModified();
                this.saveObject();
            }
        }
        this.firePropertyBrowserEvent(new PropertyBrowserEvent(7, this, newNode));
        return newNode;
    }

    public AbstractNode removeNode() {
        if (this.currentNode == null) {
            return null;
        }
        AbstractNode newCurrentNode = this.currentNode;
        if (this.currentNode instanceof CollectionNode) {
            String msg = this.resourceCollection.getRequiredString("propertybrowser.removeall");
            int result = JMsgBox.show(null, (String)msg, (int)0x100000C);
            if (result != 4) {
                return null;
            }
            ((CollectionNode)this.currentNode).removeAllNodes();
            this.firePropertyBrowserEvent(new PropertyBrowserEvent(10, this, this.currentNode));
        } else {
            CollectionNode cdn = this.currentNode.getAssociatedCollectionNode();
            if (cdn == null) {
                return null;
            }
            ObjectNode objectNode = this.currentNode.getObjectNode();
            newCurrentNode = cdn.removeNode(objectNode);
            this.firePropertyBrowserEvent(new PropertyBrowserEvent(10, this, objectNode));
        }
        if (this.saveImmediately) {
            this.fireObjectModified();
            this.saveObject();
        }
        return newCurrentNode;
    }

    public void copyNode() {
        if (!(this.currentNode instanceof ObjectNode)) {
            return;
        }
        ObjectNode on = (ObjectNode)this.currentNode;
        Object o = on.getObject();
        BasicTransferable transferable = new BasicTransferable(o);
        ClipboardMgr.getInstance().addEntry(transferable);
        this.firePropertyBrowserEvent(new PropertyBrowserEvent(8, this, on));
    }

    public AbstractNode pasteNode() {
        Transferable transferable = ClipboardMgr.getInstance().getCurrentEntry();
        if (transferable == null) {
            return null;
        }
        CollectionNode cdn = this.currentNode.getAssociatedCollectionNode();
        if (cdn == null) {
            return null;
        }
        CollectionDescriptor cd = cdn.getCollectionDescriptor();
        Class elementClass = cd.getSafeTypeClass();
        DataFlavor elementFlavor = new DataFlavor(elementClass, elementClass.getName());
        Object o = null;
        try {
            o = transferable.getTransferData(elementFlavor);
            o = CopyUtil.copyObject((Object)o, (int)2, null);
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        AbstractNode objectNode = cdn == this.currentNode ? this.currentNode : this.currentNode.getObjectNode();
        TreePath path = this.getPathByNode((TreeNode)((Object)cdn));
        this.expandPath(path);
        AbstractNode newNode = cdn.addNewNodeAfter(objectNode, o);
        this.firePropertyBrowserEvent(new PropertyBrowserEvent(9, this, newNode));
        if (newNode != null) {
            path = this.getPathByNode((TreeNode)((Object)newNode));
            this.expandPath(path);
            if (this.saveImmediately) {
                this.fireObjectModified();
                this.saveObject();
            }
        }
        return newNode;
    }

    protected void moveNodeUp() {
        if (this.currentNode == null) {
            return;
        }
        CollectionNode cdn = this.currentNode.getAssociatedCollectionNode();
        if (cdn == null) {
            return;
        }
        ObjectNode objectNode = this.currentNode.getObjectNode();
        cdn.moveNodeUp(objectNode);
        if (this.saveImmediately) {
            this.fireObjectModified();
            this.saveObject();
        }
        this.selectCell(this.currentRow, this.currentCol);
    }

    protected void moveNodeDown() {
        if (this.currentNode == null) {
            return;
        }
        CollectionNode cdn = this.currentNode.getAssociatedCollectionNode();
        if (cdn == null) {
            return;
        }
        ObjectNode objectNode = this.currentNode.getObjectNode();
        cdn.moveNodeDown(objectNode);
        if (this.saveImmediately) {
            this.fireObjectModified();
            this.saveObject();
        }
        this.selectCell(this.currentRow, this.currentCol);
    }

    public void selectNode(AbstractNode node, int rowOffset, int column) {
        TreePath path = this.getPathByNode((TreeNode)((Object)node));
        if (path != null) {
            int row = this.getTree().getRowForPath(path) + rowOffset;
            if (column < 0) {
                column = this.getSelectedColumn();
            }
            this.selectCell(row, column);
        }
    }

    public void changeSelection(int newRow, int newCol, boolean toggle, boolean extend) {
        if (this.currentPE != null) {
            this.currentPE.resetComponentDisplay();
        }
        super.changeSelection(newRow, newCol, toggle, extend);
        AbstractNode node = (AbstractNode)this.getNodeByRow(newRow);
        this.firePropertyBrowserEvent(new PropertyBrowserEvent(2, this, node));
    }

    @Override
    public void handleKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.handleEscape();
            e.consume();
            return;
        }
        super.handleKeyEvent(e);
    }

    protected void processCommand(int command) {
        if (command == 16) {
            this.handleEscape();
            return;
        }
        super.processCommand(command);
    }

    protected void handleEscape() {
        Dialog dialog;
        if (this.isObjectModified()) {
            this.reset();
        }
        if ((dialog = SwingUtil.getDialog((Component)((Object)this))) != null) {
            dialog.dispatchEvent(new WindowEvent(dialog, 201));
        }
    }

    public ResourceCollection getPropertyBrowserResource() {
        return this.resourceCollection;
    }

    private void setRootIcon(MultiIcon icon) {
        this.rootIcon = icon;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.setDefaultEditor(PropertyEditor.class, null);
        } else {
            this.setDefaultEditor(PropertyEditor.class, (TableCellEditor)((Object)propertyCellEditor));
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.getDefaultEditor(PropertyEditor.class) == null;
    }

    @Override
    public boolean isSaveImmediately() {
        return this.saveImmediately;
    }

    @Override
    public void setSaveImmediately(boolean saveImmediately) {
        this.saveImmediately = saveImmediately;
    }

    public boolean isShowTooltips() {
        return this.showTooltips;
    }

    public void setShowTooltips(boolean showTooltips) {
        this.showTooltips = showTooltips;
    }

    @Override
    public String[] getVisibleMembers() {
        return this.visibleMembers;
    }

    @Override
    public void setVisibleMembers(String[] visibleMembers) {
        this.visibleMembers = visibleMembers;
    }

    public JaspiraAction getAddAction() {
        return this.actions[0];
    }

    public JaspiraAction getCopyAction() {
        return this.actions[1];
    }

    public JaspiraAction getCutAction() {
        return this.actions[2];
    }

    public JaspiraAction getPasteAction() {
        return this.actions[3];
    }

    public JaspiraAction getRemoveAction() {
        return this.actions[4];
    }

    public JaspiraAction getMoveUpAction() {
        return this.actions[5];
    }

    public JaspiraAction getMoveDownAction() {
        return this.actions[6];
    }

    public TreePath getPathByNode(TreeNode treeNode) {
        ArrayList<AbstractNode> list = new ArrayList<AbstractNode>();
        for (AbstractNode node = (AbstractNode)((Object)treeNode); node != null; node = (AbstractNode)((Object)node.getParent())) {
            list.add(0, node);
        }
        Object[] elements = CollectionUtil.toArray(list, Object.class);
        return new TreePath(elements);
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.processSelection(event.getPath());
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getTree().getSelectionCount() == 0) {
            this.selectCell(0, 0);
        }
        if (this.getTree().getSelectionCount() == 0) {
            this.processSelection(null);
        } else {
            this.processSelection(this.getTree().getSelectionPath());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    protected void processSelection(TreePath path) {
        this.currentNode = path != null ? (AbstractNode)path.getLastPathComponent() : null;
        this.updateActionState();
    }

    protected void updateActionState() {
        Transferable transferable;
        CollectionNode cdn = this.currentNode != null ? this.currentNode.getAssociatedCollectionNode() : null;
        this.actions[0].setEnabled(cdn != null && cdn.allowsNodeAddition());
        this.actions[1].setEnabled(this.currentNode instanceof ObjectNode);
        this.actions[2].setEnabled(cdn != null && cdn.allowsNodeRemoval() && cdn.getChildCount() > 0 && this.currentNode instanceof ObjectNode);
        boolean canPaste = false;
        if (cdn != null && cdn.allowsNodeAddition() && (transferable = ClipboardMgr.getInstance().getCurrentEntry()) != null) {
            CollectionDescriptor cd = cdn.getCollectionDescriptor();
            Class elementClass = cd.getSafeTypeClass();
            DataFlavor elementFlavor = new DataFlavor(elementClass, elementClass.getName());
            canPaste = transferable.isDataFlavorSupported(elementFlavor);
        }
        this.actions[3].setEnabled(canPaste);
        this.actions[4].setEnabled(cdn != null && cdn.allowsNodeRemoval() && cdn.getChildCount() > 0 && (this.currentNode instanceof CollectionNode || this.currentNode instanceof ObjectNode));
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        if (cdn != null && cdn != this.currentNode && cdn.allowsNodeReordering()) {
            ObjectNode objectNode = this.currentNode.getObjectNode();
            int index = cdn.getChildIndex(objectNode);
            int n = cdn.getChildCount();
            canMoveUp = n > 1 && index > 0;
            canMoveDown = n > 1 && index < n - 1;
        }
        this.actions[5].setEnabled(canMoveUp);
        this.actions[6].setEnabled(canMoveDown);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getButton() == 3) {
            final Point point = event.getPoint();
            this.currentNode = (AbstractNode)this.getNodeByPoint(point);
            if (this.currentNode == null) {
                return;
            }
            this.selectNode(this.currentNode, 0, -1);
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPopupMenu contextMenu = PropertyBrowserImpl.this.createContextMenu();
                    if (contextMenu != null) {
                        contextMenu.show((Component)((Object)PropertyBrowserImpl.this), point.x, point.y);
                    }
                }
            });
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected JPopupMenu createContextMenu() {
        boolean actionEnabled = false;
        for (int i = 0; i < this.actions.length; ++i) {
            if (!this.actions[i].isEnabled()) continue;
            actionEnabled = true;
            break;
        }
        if (!actionEnabled) {
            return null;
        }
        JaspiraPopupMenu menu = new JaspiraPopupMenu();
        boolean needSeparator = false;
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i].isEnabled()) {
                if (needSeparator) {
                    menu.add(new JSeparator());
                    needSeparator = false;
                }
                menu.add(this.actions[i].toMenuItem());
            }
            if (i != 0 && i != 3 && i != 4) continue;
            needSeparator = true;
        }
        return menu;
    }

    @Override
    public void addPropertyBrowserListener(PropertyBrowserListener listener) {
        if (this.editListenerList == null) {
            this.editListenerList = new EventListenerList();
        } else if (SwingUtil.containsListener((EventListenerList)this.editListenerList, PropertyBrowserListener.class, (EventListener)listener)) {
            return;
        }
        this.editListenerList.add(PropertyBrowserListener.class, listener);
    }

    @Override
    public void removePropertyBrowserListener(PropertyBrowserListener listener) {
        if (this.editListenerList != null) {
            this.editListenerList.remove(PropertyBrowserListener.class, listener);
        }
    }

    @Override
    public void firePropertyBrowserEvent(PropertyBrowserEvent e) {
        this.defaultHandlePropertyBrowserEvent(e);
        if (this.editListenerList != null) {
            Object[] listeners = this.editListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PropertyBrowserListener.class) continue;
                ((PropertyBrowserListener)listeners[i + 1]).handlePropertyBrowserEvent(e);
            }
        }
    }

    public void defaultHandlePropertyBrowserEvent(PropertyBrowserEvent event) {
        PropertyEditor pe = event.propertyEditor;
        switch (event.eventType) {
            case 5: {
                this.fireObjectModified();
                break;
            }
            case 3: {
                this.currentPE = pe;
                this.saveDisabled = false;
                break;
            }
            case 4: {
                if (!pe.saveProperty()) {
                    return;
                }
                this.currentPE = null;
                if (!this.objectModified || !this.saveImmediately) break;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PropertyBrowserImpl.this.saveObject();
                    }
                });
            }
        }
    }

    public void fireObjectModified() {
        this.setObjectModified(true);
        this.fireObjectChanged();
    }

    public void fireObjectChanged() {
        if (this.objectChangeListenerList != null) {
            for (ObjectChangeListener listener : this.objectChangeListenerList) {
                listener.objectChanged(this.getObject(), this.getModifiedObject());
            }
        }
    }

    public void addObjectChangeListener(ObjectChangeListener listener) {
        if (this.objectChangeListenerList == null) {
            this.objectChangeListenerList = new ArrayList();
        }
        this.objectChangeListenerList.add(listener);
    }

    public void removeObjectChangeListener(ObjectChangeListener listener) {
        if (this.objectChangeListenerList == null) {
            return;
        }
        this.objectChangeListenerList.remove(listener);
    }

    static {
        tableBackground = UIManager.getColor("Table.background");
        tableForeground = UIManager.getColor("Table.foreground");
        tableSelectionBackground = UIManager.getColor("Table.selectionBackground");
        tableSelectionForeground = UIManager.getColor("Table.selectionForeground");
    }

    public class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        public TreeCellRenderer(JTreeTable treeTable) {
            super(treeTable);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                String tooltip;
                MultiIcon icon = null;
                if (row == 0 && tree.isRootVisible()) {
                    icon = PropertyBrowserImpl.this.rootIcon;
                } else if (!leaf) {
                    icon = expanded ? StdIcons.openFolderIcon : StdIcons.closedFolderIcon;
                }
                ((JLabel)c).setIcon((Icon)icon);
                if (value instanceof AbstractNode) {
                    value = ((AbstractNode)value).getColumnValue(0);
                }
                if (PropertyBrowserImpl.this.isShowTooltips() && value instanceof DescriptionObject && (tooltip = ((DescriptionObject)value).getDescription()) != null) {
                    ((JLabel)c).setToolTipText(TextUtil.convertToHTML((String[])new String[]{tooltip}, (boolean)false, (int)-1, (int)50));
                }
            }
            return c;
        }
    }

    public static class PropertyCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof PropertyEditor)) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            PropertyEditor pe = (PropertyEditor)value;
            JComponent component = pe.getPropertyComponent();
            if (component == null) {
                return super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            }
            ((PropertyBrowser)((Object)table)).configureSubComponent(component);
            int defaultHeight = table.getRowHeight();
            Dimension ps = component.getPreferredSize();
            if (ps.height < defaultHeight) {
                ps.height = defaultHeight;
                component.setPreferredSize(ps);
            }
            if (component instanceof JCheckBox) {
                if (isSelected || hasFocus) {
                    component.setBackground(tableSelectionBackground);
                    component.setForeground(tableSelectionForeground);
                } else {
                    component.setBackground(tableBackground);
                    component.setForeground(tableForeground);
                }
            }
            return component;
        }
    }

    public static class PropertyCellEditor
    extends DefaultTableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof PropertyEditor) {
                PropertyEditor pe = (PropertyEditor)value;
                this.setValue(value);
                JComponent component = pe.getPropertyComponent();
                if (component != null) {
                    ((PropertyBrowser)((Object)table)).configureSubComponent(component);
                    if (component instanceof JCheckBox) {
                        component.setBackground(tableSelectionBackground);
                        component.setForeground(tableSelectionForeground);
                    }
                }
                return component;
            }
            return null;
        }
    }
}

