/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.propertybrowser.NodeStructureMgr;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserImpl;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;
import org.openbp.jaspira.propertybrowser.nodes.AbstractNode;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;
import org.openbp.swing.components.treetable.SimpleTreeTableModel;
import org.openbp.swing.components.treetable.TreeTableModel;

public class PropertyBrowserModel
extends SimpleTreeTableModel {
    private static String[] columnHeaders;
    private PropertyBrowserImpl propertyBrowser;
    private String[] visibleMembers;

    public PropertyBrowserModel() {
        super(null);
        columnHeaders = new String[2];
    }

    public PropertyBrowserModel(ResourceCollection resourceCollection) {
        this();
        this.setResourceCollection(resourceCollection);
    }

    public void setResourceCollection(ResourceCollection resourceCollection) {
        if (resourceCollection != null) {
            PropertyBrowserModel.columnHeaders[0] = resourceCollection.getOptionalString("propertybrowser.header.columnproperty", "Property");
            PropertyBrowserModel.columnHeaders[1] = resourceCollection.getOptionalString("propertybrowser.header.columnvalue", "Value");
        }
    }

    public String[] getVisibleMembers() {
        return this.visibleMembers;
    }

    public void setVisibleMembers(String[] visibleMembers) {
        this.visibleMembers = visibleMembers;
    }

    public void setObject(Object object) {
        this.setObject(object, null);
    }

    public void setObject(Object object, ObjectNode rootNode) {
        ObjectNode oldRoot = (ObjectNode)this.getRoot();
        if (oldRoot != null) {
            oldRoot.setPropertyBrowser(null);
            oldRoot.setObject(null);
        }
        if (object != null) {
            if (rootNode == null) {
                rootNode = NodeStructureMgr.getInstance().createEditorStructureFor(object.getClass());
            }
            if (rootNode != null) {
                rootNode.filterPropertyNodes(this.visibleMembers);
                rootNode.setPropertyBrowser(this.propertyBrowser);
                rootNode.setObject(object);
            }
            this.setRoot(rootNode);
            if (rootNode != null) {
                this.performDefaultExpansion(rootNode);
            }
        } else {
            this.setRoot(null);
        }
    }

    public PropertyBrowser getPropertyBrowser() {
        return this.propertyBrowser;
    }

    public void setPropertyBrowser(PropertyBrowserImpl propertyBrowser) {
        this.propertyBrowser = propertyBrowser;
    }

    public boolean isCellEditable(int row, int column) {
        if (this.getColumnClass(column) == TreeTableModel.class) {
            return true;
        }
        return this.getColumnClass(column) == PropertyEditor.class;
    }

    public boolean isCellSelectable(int row, int column) {
        return this.isCellEditable(row, column);
    }

    public int getColumnCount() {
        return columnHeaders.length;
    }

    public String getColumnName(int column) {
        return columnHeaders[column];
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return TreeTableModel.class;
            }
            case 1: {
                return PropertyEditor.class;
            }
        }
        return Object.class;
    }

    protected void performDefaultExpansion(AbstractNode node) {
        if (node.shouldExpand()) {
            if (node.getParent() != null) {
                TreePath parentPath = this.propertyBrowser.getPathByNode(node.getParent());
                if (!this.propertyBrowser.getTree().isExpanded(parentPath)) {
                    return;
                }
            }
            TreePath path = this.propertyBrowser.getPathByNode((TreeNode)((Object)node));
            this.propertyBrowser.expandPath(path);
        }
        if (node.getChildCount() >= 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                AbstractNode n = (AbstractNode)e.nextElement();
                this.performDefaultExpansion(n);
            }
        }
    }

    public void structureChanged(AbstractNode node) {
        this.fireNodeStructureChanged((TreeNode)((Object)node));
    }
}

