/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.nodes;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.openbp.common.CollectionUtil;
import org.openbp.common.generic.Copyable;
import org.openbp.common.util.iterator.EmptyEnumeration;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserImpl;
import org.openbp.jaspira.propertybrowser.PropertyBrowserModel;
import org.openbp.jaspira.propertybrowser.nodes.CollectionNode;
import org.openbp.jaspira.propertybrowser.nodes.GroupNode;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;
import org.openbp.jaspira.propertybrowser.nodes.PropertyNode;
import org.openbp.swing.components.treetable.TreeTableNode;

public abstract class AbstractNode
implements TreeTableNode,
Cloneable,
Copyable {
    protected Vector children;
    private int lastHeight;
    protected AbstractNode parentNode;
    protected Object object;
    protected PropertyBrowserImpl propertyBrowser;

    public Object clone() throws CloneNotSupportedException {
        AbstractNode clone = (AbstractNode)super.clone();
        clone.copyFrom(this, 2);
        return clone;
    }

    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        AbstractNode src = (AbstractNode)source;
        this.children = null;
        this.lastHeight = 0;
        this.parentNode = null;
        this.object = null;
        this.propertyBrowser = null;
        if (src.children != null) {
            Enumeration originalChildren = src.children();
            while (originalChildren.hasMoreElements()) {
                AbstractNode element = (AbstractNode)originalChildren.nextElement();
                this.add((AbstractNode)element.clone());
            }
        } else {
            this.children = null;
        }
    }

    public void reload() {
        this.setPropertyBrowser(this.propertyBrowser);
        this.setObject(this.object);
    }

    public boolean representsProperty(String propertyName) {
        return false;
    }

    public void remove() {
        AbstractNode parent = (AbstractNode)((Object)this.getParent());
        if (parent != null && parent.children != null) {
            parent.children.remove(this);
            if (parent.children.size() > 0) {
                if (this.propertyBrowser != null) {
                    ((PropertyBrowserModel)((Object)this.propertyBrowser.getModel())).fireNodeRemoved((TreeNode)((Object)parent));
                }
            } else {
                parent.remove();
            }
        }
    }

    public AbstractNode findNodeForProperty(String propertyName) {
        if (this.representsProperty(propertyName)) {
            return this;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            AbstractNode childNode = (AbstractNode)((Object)this.getChildAt(i));
            AbstractNode result = childNode.findNodeForProperty(propertyName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void reloadProperty(String propertyName) {
        AbstractNode propertyNode;
        ObjectNode on = this.getObjectNode();
        if (on != null && (propertyNode = on.findNodeForProperty(propertyName)) != null) {
            propertyNode.reload();
        }
    }

    public void filterPropertyNodes(String[] visibleMembers) {
        if (visibleMembers == null) {
            return;
        }
        Iterator it = this.getPropertyNodes();
        while (it.hasNext()) {
            AbstractNode node = (AbstractNode)it.next();
            boolean found = false;
            for (int i = 0; i < visibleMembers.length; ++i) {
                if (!node.representsProperty(visibleMembers[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            node.remove();
        }
    }

    public int getLastHeight() {
        return this.lastHeight;
    }

    public void setLastHeight(int height) {
        this.lastHeight = height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    public boolean isLeaf() {
        if (this.children == null) {
            return true;
        }
        return this.children.size() <= 0;
    }

    public TreeNode getChildAt(int childIndex) {
        return this.children == null ? null : (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children == null ? -1 : this.children.size();
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public int getIndex(TreeNode node) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (!this.children.get(i).equals(node)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public Enumeration children() {
        return this.children == null ? EmptyEnumeration.getInstance() : this.children.elements();
    }

    public Iterator getPropertyNodes() {
        ArrayList<AbstractNode> list = new ArrayList<AbstractNode>();
        for (int i = 0; i < this.children.size(); ++i) {
            AbstractNode node = (AbstractNode)this.children.get(i);
            if (node instanceof GroupNode) {
                Iterator groupPropertyNodes = node.getPropertyNodes();
                CollectionUtil.addAll(list, (Iterator)groupPropertyNodes);
                continue;
            }
            if (!(node instanceof PropertyNode) && !(node instanceof CollectionNode) && (!(node instanceof ObjectNode) || ((ObjectNode)node).getPropertyDescriptor() == null)) continue;
            list.add(node);
        }
        return list.iterator();
    }

    protected void add(AbstractNode node) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(node);
        node.setParent(this);
    }

    protected void add(int index, AbstractNode node) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(index, node);
        node.setParent(this);
    }

    public void setParent(AbstractNode node) {
        this.parentNode = node;
    }

    public boolean shouldExpand() {
        if (this.isLeaf()) {
            return false;
        }
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                AbstractNode child = (AbstractNode)this.children.get(i);
                if (!child.shouldExpand()) continue;
                return true;
            }
        }
        return false;
    }

    public ObjectNode getObjectNode() {
        for (Object node = this; node != null; node = node.getParent()) {
            if (!(node instanceof ObjectNode)) continue;
            return (ObjectNode)node;
        }
        return null;
    }

    public CollectionNode getAssociatedCollectionNode() {
        for (Object node = this; node != null; node = node.getParent()) {
            if (!(node instanceof CollectionNode)) continue;
            return (CollectionNode)node;
        }
        return null;
    }

    public void setObject(Object object) {
        this.object = object;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((AbstractNode)this.children.get(i)).setObject(object);
            }
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void setPropertyBrowser(PropertyBrowserImpl propertyBrowser) {
        this.propertyBrowser = propertyBrowser;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((AbstractNode)this.children.get(i)).setPropertyBrowser(propertyBrowser);
            }
        }
    }

    public PropertyBrowser getPropertyBrowser() {
        return this.propertyBrowser;
    }
}

