/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.openbp.cockpit.CockpitAboutBox;
import org.openbp.cockpit.SplashScreen;
import org.openbp.cockpit.generator.GeneratorMgr;
import org.openbp.cockpit.generator.GeneratorPlugin;
import org.openbp.cockpit.itemeditor.ItemOpenDispatcherPlugin;
import org.openbp.cockpit.itemeditor.NodeItemEditor;
import org.openbp.cockpit.itemeditor.StandardItemEditor;
import org.openbp.cockpit.modeler.ModelerOptionPlugin;
import org.openbp.cockpit.modeler.ModelerPage;
import org.openbp.cockpit.modeler.figures.process.DecisionNodeFigure;
import org.openbp.cockpit.modeler.figures.process.FinalNodeFigure;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.ForkNodeFigure;
import org.openbp.cockpit.modeler.figures.process.InitialNodeFigure;
import org.openbp.cockpit.modeler.figures.process.JoinNodeFigure;
import org.openbp.cockpit.modeler.figures.process.MergeNodeFigure;
import org.openbp.cockpit.modeler.figures.process.MultiSocketNodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.PlaceholderNodeFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementFigureRegistry;
import org.openbp.cockpit.modeler.figures.process.TextElementFigure;
import org.openbp.cockpit.modeler.figures.process.WaitStateNodeFigure;
import org.openbp.cockpit.modeler.figures.process.WorkflowEndNodeFigure;
import org.openbp.cockpit.modeler.figures.process.WorkflowNodeFigure;
import org.openbp.cockpit.modeler.skins.SkinMgr;
import org.openbp.cockpit.modeler.skins.SkinPlugin;
import org.openbp.cockpit.plugins.association.AssociationPlugin;
import org.openbp.cockpit.plugins.association.ExternalAssociationPlugin;
import org.openbp.cockpit.plugins.commandline.CommandLinePlugin;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.application.Application;
import org.openbp.common.generic.propertybrowser.ObjectDescriptorMgr;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.common.rc.ResourceCollectionUtil;
import org.openbp.common.resource.FileResourceProvider;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceProvider;
import org.openbp.common.setting.SettingUtil;
import org.openbp.core.CoreModule;
import org.openbp.core.OpenBPException;
import org.openbp.core.model.Association;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.activity.JavaActivityItem;
import org.openbp.core.model.item.process.ActivityNode;
import org.openbp.core.model.item.process.ControlLink;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.DecisionNode;
import org.openbp.core.model.item.process.FinalNode;
import org.openbp.core.model.item.process.ForkNode;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.JoinNode;
import org.openbp.core.model.item.process.MergeNode;
import org.openbp.core.model.item.process.PlaceholderNode;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.SubprocessNode;
import org.openbp.core.model.item.process.TextElement;
import org.openbp.core.model.item.process.VisualNode;
import org.openbp.core.model.item.process.WaitStateNode;
import org.openbp.core.model.item.process.WebServiceNode;
import org.openbp.core.model.item.process.WorkflowEndNode;
import org.openbp.core.model.item.process.WorkflowNode;
import org.openbp.core.model.item.visual.VisualItem;
import org.openbp.core.remote.ClientLoginInfo;
import org.openbp.guiclient.GUIClientModule;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.ItemEditorRegistry;
import org.openbp.guiclient.plugins.displayobject.DisplayObjectPlugin;
import org.openbp.guiclient.plugins.server.ServerConnectionPlugin;
import org.openbp.guiclient.remote.ServerConnection;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugin.ConfigMgr;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugins.errordialog.ErrorDialogPlugin;
import org.openbp.jaspira.propertybrowser.NodeStructureMgr;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;
import org.springframework.core.io.ResourceLoader;

public class Cockpit
extends ApplicationBase {
    private static SplashScreen splashScreen;
    public static boolean disableTimersForDebug;
    private static final Class[] objectClassPreloads;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    @Override
    protected void preInstallApplication() {
        if (disableTimersForDebug) {
            ServerConnection.disableTimersForDebug = true;
        }
        super.preInstallApplication();
        String resourceDir = SettingUtil.getStringSetting((String)"openbp.cockpit.resource.dir");
        if (resourceDir != null) {
            ResourceLoader loader = ResourceMgr.getDefaultInstance().getResourceLoader();
            FileResourceProvider rp = new FileResourceProvider(51, loader, resourceDir);
            ResourceMgr.getDefaultInstance().getResourceResolver().addProvider((ResourceProvider)rp);
        }
        PluginMgr.getInstance().createInstance(ServerConnectionPlugin.class, (Plugin)this);
        this.registerItemEditors();
        this.registerFigureClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postInstallApplication() {
        PluginMgr pm;
        block7: {
            super.postInstallApplication();
            pm = PluginMgr.getInstance();
            GUIClientModule.getInstance().initialize();
            ModelConnector.getInstance().initialize(GUIClientModule.getInstance());
            this.initCustomDescriptors();
            DisplayObjectPlugin.getInstance();
            SkinMgr.getInstance().load();
            pm.createInstance(ErrorDialogPlugin.class, (Plugin)this);
            ServerConnection connection = ServerConnection.getInstance();
            connection.setLoginInfo(new ClientLoginInfo("Anonymous", null));
            try {
                connection.connect(true);
            }
            catch (OpenBPException e) {
                int response;
                if (SettingUtil.getBooleanSetting((String)"openbp.cockpit.connectionwarning.hide", (boolean)false)) break block7;
                if (splashScreen != null) {
                    splashScreen.setVisible(false);
                }
                if (((response = JMsgBox.show(null, (String)this.getPluginResourceCollection().getRequiredString("connectionerror.title"), (String)ResourceCollectionUtil.formatMsg((ResourceCollection)this.getPluginResourceCollection(), (String)"connectionerror.description", (Object[])new Object[]{connection.getConnectionInfo().getRmiServerHost(), new Integer(connection.getConnectionInfo().getRmiServerPort()), e.getMessage()}), (int)0x210201)) & 0x200) == 0) break block7;
                SettingUtil.setBooleanSetting((String)"openbp.cockpit.connectionwarning.hide", (boolean)true);
                SettingUtil.saveSettings(null);
            }
        }
        ApplicationUtil.waitCursorOn();
        try {
            this.addPage((JaspiraPage)pm.createInstance(ModelerPage.class, (Plugin)this));
            pm.createInstance(GeneratorPlugin.class, (Plugin)this);
            pm.createInstance(ModelerOptionPlugin.class, (Plugin)this);
            pm.createInstance(SkinPlugin.class, (Plugin)this);
            pm.createInstance(ItemOpenDispatcherPlugin.class, (Plugin)this);
            pm.createInstance(CommandLinePlugin.class, (Plugin)this);
            pm.createInstance(ExternalAssociationPlugin.class, (Plugin)this);
            pm.createInstance(AssociationPlugin.class, (Plugin)this);
            PluginMgr.getInstance().loadCustomPlugins("openbp.cockpit.plugins.global");
            PluginMgr.getInstance().loadPluginsFromResource();
        }
        finally {
            ApplicationUtil.waitCursorOff();
        }
        JaspiraAction action = this.getAction("standard.file.save");
        if (action != null) {
            action.setEnabled(false);
        }
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        System.out.println("OpenBP cockpit startup complete");
    }

    @Override
    protected Class getAboutBoxClass() {
        return CockpitAboutBox.class;
    }

    private void registerItemEditors() {
        ItemEditorRegistry registry = ItemEditorRegistry.getInstance();
        StandardItemEditor standardItemEditor = new StandardItemEditor();
        NodeItemEditor nodeItemEditor = new NodeItemEditor();
        registry.registerItemEditor("Activity", nodeItemEditor);
        registry.registerItemEditor("Placeholder", nodeItemEditor);
        registry.registerItemEditor("Process", nodeItemEditor);
        registry.registerItemEditor("Type", standardItemEditor);
        registry.registerItemEditor("Model", standardItemEditor);
        registry.registerItemEditor("Visual", nodeItemEditor);
    }

    private void registerFigureClasses() {
        ProcessElementFigureRegistry registry = ProcessElementFigureRegistry.getInstance();
        registry.registerFigure(DecisionNodeFigure.class, DecisionNode.class);
        registry.registerFigure(FinalNodeFigure.class, FinalNode.class);
        registry.registerFigure(FlowConnection.class, ControlLink.class);
        registry.registerFigure(ForkNodeFigure.class, ForkNode.class);
        registry.registerFigure(InitialNodeFigure.class, InitialNode.class);
        registry.registerFigure(JoinNodeFigure.class, JoinNode.class);
        registry.registerFigure(MergeNodeFigure.class, MergeNode.class);
        registry.registerFigure(ParamConnection.class, DataLink.class);
        registry.registerFigure(PlaceholderNodeFigure.class, PlaceholderNode.class);
        registry.registerFigure(TextElementFigure.class, TextElement.class);
        registry.registerFigure(WaitStateNodeFigure.class, WaitStateNode.class);
        registry.registerFigure(WorkflowEndNodeFigure.class, WorkflowEndNode.class);
        registry.registerFigure(WorkflowNodeFigure.class, WorkflowNode.class);
        registry.registerFigure(MultiSocketNodeFigure.class, ActivityNode.class);
        registry.registerFigure(MultiSocketNodeFigure.class, SubprocessNode.class);
        registry.registerFigure(MultiSocketNodeFigure.class, VisualNode.class);
        registry.registerFigure(MultiSocketNodeFigure.class, WebServiceNode.class);
    }

    private void initCustomDescriptors() {
        ObjectDescriptorMgr.getInstance().setCustomDescriptorResourcePath("codsets");
        this.loadCustomDescriptors();
    }

    private void loadCustomDescriptors() {
        NodeStructureMgr.getInstance().clearCache();
        String customDescriptorSetName = SettingUtil.getStringSetting((String)"openbp.cockpit.codset");
        try {
            ObjectDescriptorMgr.getInstance().loadCustomDescriptorSet(customDescriptorSetName);
            this.fireEvent("plugin.propertybrowser.refresh");
        }
        catch (XMLDriverException e) {
            JMsgBox.show(null, (String)e.getMessage(), (int)262144);
        }
    }

    public void displayRestartHint() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String msg = Cockpit.this.getPluginResourceCollection().getRequiredString("warning.restartoption");
                JMsgBox.show(null, (String)msg, (int)131072);
            }
        });
    }

    protected void performPreload() {
        this.showStatusText(this.getPluginResourceCollection().getRequiredString("progress.loadingwizards"));
        GeneratorMgr.getInstance();
        this.showStatusText(this.getPluginResourceCollection().getRequiredString("progress.loadingobjectdescriptors"));
        NodeStructureMgr nsm = NodeStructureMgr.getInstance();
        for (int i = 0; i < objectClassPreloads.length; ++i) {
            Class cls = objectClassPreloads[i];
            nsm.loadNodeStructureFor(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CoreModule.determineRootDir();
            Application.setArguments((String[])args);
            Application.initialize();
            Application.registerPropertyResource((String)"OpenBP-Cockpit.properties", (int)80, (boolean)false);
            Application.registerPropertyResource((String)"OpenBP-User.properties", (int)90, (boolean)true);
            ConfigMgr.getInstance().setConfigResourceName("OpenBP-Cockpit-Config.properties");
            Cockpit.addResourceCollectionTextReplacement("openbp.application.name");
            Cockpit.addResourceCollectionTextReplacement("openbp.application.title");
            Cockpit.addResourceCollectionTextReplacement("openbp.cockpit.title");
            String applicationName = SettingUtil.getMandatoryStringSetting((String)"openbp.application.name");
            String resourceName = "rc/images/application/" + applicationName + "Splash.png";
            if (!SettingUtil.getBooleanSetting((String)"openbp.application.nosplash", (boolean)false)) {
                try {
                    ResourceMgr resourceMgr = ResourceMgr.getDefaultInstance();
                    byte[] imageData = resourceMgr.loadByteResource(resourceName);
                    ImageIcon image = new ImageIcon(imageData);
                    splashScreen = new SplashScreen(image);
                    splashScreen.setLocationRelativeTo(null);
                    SwingUtil.show((JWindow)((Object)splashScreen));
                    SwingUtil.waitCursorOn((Component)((Object)splashScreen));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            new Cockpit();
        }
        catch (Exception e) {
            if (splashScreen != null) {
                splashScreen.dispose();
            }
            ExceptionUtil.printTrace((Throwable)e);
            System.exit(1);
        }
        finally {
            if (splashScreen != null) {
                splashScreen.dispose();
            }
        }
    }

    private static void addResourceCollectionTextReplacement(String key) {
        String value = SettingUtil.getStringSetting((String)key, (String)key);
        ResourceCollectionMgr.getDefaultInstance().addResourceVariable("$(" + key + ")", value);
    }

    static {
        disableTimersForDebug = false;
        objectClassPreloads = new Class[]{Model.class, JavaActivityItem.class, ProcessItem.class, VisualItem.class};
    }

    public class HelpEvents
    extends EventModule {
        @Override
        public String getName() {
            return "cockpit";
        }

        public JaspiraEventHandlerCode cockpit_help_manual(JaspiraActionEvent je) {
            this.openGuide("pdf/OpenBP-Manual.pdf");
            return EVENT_CONSUMED;
        }

        public JaspiraEventHandlerCode cockpit_help_javaapi(JaspiraActionEvent je) {
            this.openGuide("api/index.html");
            return EVENT_CONSUMED;
        }

        private void openGuide(String name) {
            String path = Application.getRootDir() + "/" + "doc" + "/" + name;
            boolean pdf = path.endsWith(".pdf");
            Association as = new Association();
            if (pdf) {
                as.setAssociationTypes(new String[]{"application/pdf"});
            } else {
                as.setAssociationTypes(new String[]{"text/html", "application/x-url"});
            }
            as.setAssociationPriority(1);
            as.setAssociatedObject((Object)path);
            boolean consumed = JaspiraEventMgr.fireGlobalEvent("plugin.association.tryopen", as);
            if (!consumed) {
                String msg = Cockpit.this.getPluginResourceCollection().getRequiredString(pdf ? "guide.noassociation.pdf" : "guide.noassociation.html");
                JMsgBox.show(null, (String)msg, (int)131072);
            }
        }
    }
}

