/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorCustomizer;
import org.openbp.cockpit.generator.GeneratorException;
import org.openbp.cockpit.generator.GeneratorMgr;
import org.openbp.cockpit.generator.GeneratorPageDescriptor;
import org.openbp.cockpit.generator.GeneratorProperty;
import org.openbp.common.ReflectUtil;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptorMgr;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.property.PropertyAccessUtil;
import org.openbp.common.property.PropertyException;
import org.openbp.common.template.TemplateEngine;
import org.openbp.common.template.TemplateEngineResult;
import org.openbp.common.util.CopyUtil;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;
import org.openbp.jaspira.plugin.ConfigMgr;

public class Generator
extends DisplayObjectImpl
implements Comparable {
    private String functionalGroup;
    private boolean itemGenerator;
    private int sequenceNr;
    private int xmlLoaderSequenceNr;
    private String itemType;
    private Map initialProperties;
    private List requiredItemPropertyList;
    private List customPageList;
    private String condition;
    private String templateName;
    private String defaultStartPageName;
    private String generatorCustomizerClassName;
    private boolean showOpenResultCheckBox = true;
    private transient GeneratorCustomizer customizer;
    private GeneratorMgr generatorMgr;
    private ClassLoader classLoader;
    private XMLDriver xmlDriver;

    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        Generator src = (Generator)source;
        this.itemType = src.itemType;
        this.functionalGroup = src.functionalGroup;
        this.itemGenerator = src.itemGenerator;
        this.sequenceNr = src.sequenceNr;
        this.xmlLoaderSequenceNr = src.xmlLoaderSequenceNr;
        this.templateName = src.templateName;
        this.condition = src.condition;
        this.defaultStartPageName = src.defaultStartPageName;
        this.showOpenResultCheckBox = src.showOpenResultCheckBox;
        this.generatorCustomizerClassName = src.generatorCustomizerClassName;
        this.customizer = src.customizer;
        this.generatorMgr = src.generatorMgr;
        this.classLoader = src.classLoader;
        this.xmlDriver = src.xmlDriver;
        if (copyMode == 2) {
            this.initialProperties = CopyUtil.copyMap((Map)src.initialProperties, (int)2);
            this.requiredItemPropertyList = (List)CopyUtil.copyCollection((Collection)src.requiredItemPropertyList, (int)2);
            this.customPageList = (List)CopyUtil.copyCollection((Collection)src.customPageList, (int)2);
        } else {
            this.initialProperties = src.initialProperties;
            this.requiredItemPropertyList = src.requiredItemPropertyList;
            this.customPageList = src.customPageList;
        }
    }

    public void preProcess(GeneratorContext context) throws Exception {
        if (this.customizer != null) {
            this.customizer.preProcess(context);
        } else {
            this.runTemplateEngine(context);
        }
    }

    public void performProcess(GeneratorContext context) throws Exception {
        if (this.customizer != null) {
            this.customizer.performProcess(context);
        }
    }

    public void postProcess(GeneratorContext context) throws Exception {
        if (this.customizer != null) {
            this.customizer.postProcess(context);
        }
    }

    public void runTemplateEngine(GeneratorContext context) throws Exception {
        String tn = this.templateName;
        if (this.customizer != null) {
            tn = this.customizer.getTemplateName(context);
        }
        if (tn != null) {
            Item item = context.getItem();
            Model model = item.getOwningModel();
            String modelPath = model.getModelPath();
            context.setProperty("modelPath", modelPath);
            context.setProperty("model", model);
            context.setProperty("item", item);
            context.setProperty("overwriteMode", context.getOverwriteMode());
            context.setProperty("settings", context.getGeneratorSettings());
            TemplateEngine engine = new TemplateEngine();
            engine.setOutputDir(context.getOutputRootDir());
            engine.setProperties(context.getProperties());
            engine.setClassLoader(this.getClassLoader());
            TemplateEngineResult result = engine.processTemplate(tn, null);
            if (result == null) {
                result = new TemplateEngineResult();
            }
            context.setTemplateEngineResult(result);
        }
    }

    public boolean checkPrecondition() {
        return ConfigMgr.getInstance().evaluate(this.condition);
    }

    public void checkRequirements(GeneratorContext context) {
        Item item = context.getItem();
        if (this.requiredItemPropertyList != null && item != null) {
            StringBuffer errMsg = null;
            ObjectDescriptor od = null;
            int n = this.requiredItemPropertyList.size();
            for (int i = 0; i < n; ++i) {
                PropertyDescriptor pd;
                String property = (String)this.requiredItemPropertyList.get(i);
                Object value = null;
                try {
                    value = PropertyAccessUtil.getProperty((Object)item, (String)property);
                }
                catch (PropertyException e) {
                    System.err.println("Cannot access property '" + property + "': " + (Object)((Object)e));
                }
                if (value != null) continue;
                if (errMsg == null) {
                    errMsg = new StringBuffer("The following required properties of the component have not been set:\n");
                    try {
                        od = ObjectDescriptorMgr.getInstance().getDescriptor(item.getClass(), 0);
                    }
                    catch (XMLDriverException e) {
                        System.err.println("Cannot access object descriptor for class '" + item.getClass().getName() + "': " + (Object)((Object)e));
                    }
                } else {
                    errMsg.append('\n');
                }
                String displayName = null;
                if (od != null && (pd = od.getProperty(property)) != null) {
                    displayName = pd.getDisplayName();
                }
                if (displayName == null) {
                    displayName = property;
                }
                errMsg.append("    ");
                errMsg.append(displayName);
            }
            if (errMsg != null) {
                throw new GeneratorException(errMsg.toString());
            }
        }
        if (this.customizer != null) {
            this.customizer.checkRequirements(context);
        }
    }

    public void createSettings(GeneratorContext context) {
        if (this.customizer != null) {
            this.customizer.createSettings(context);
        }
    }

    public void loadSettings(GeneratorContext context) {
        if (this.customizer != null) {
            this.customizer.loadSettings(context);
        }
    }

    public void saveSettings(GeneratorContext context) {
        if (this.customizer != null) {
            this.customizer.saveSettings(context);
        }
    }

    public GeneratorCustomizer getCustomizer() {
        return this.customizer;
    }

    protected void createCustomizer() {
        if (this.customizer != null || this.generatorCustomizerClassName == null) {
            return;
        }
        this.customizer = (GeneratorCustomizer)ReflectUtil.instantiate((String)this.generatorCustomizerClassName, (ClassLoader)this.getClassLoader(), GeneratorCustomizer.class, (String)"generator customizer");
        this.customizer.setGenerator(this);
    }

    public void addInitialProperty(GeneratorProperty initialProperty) {
        if (this.initialProperties == null) {
            this.initialProperties = new HashMap();
        }
        this.initialProperties.put(initialProperty.getName(), initialProperty.getValue());
    }

    public void copyInitialPropertiesToContext(GeneratorContext context) {
        if (this.initialProperties != null) {
            for (String key : this.initialProperties.keySet()) {
                String value = (String)this.initialProperties.get(key);
                context.setProperty(key, value);
            }
        }
    }

    public void removeInitialPropertiesToContext(GeneratorContext context) {
        if (this.initialProperties != null) {
            for (String key : this.initialProperties.keySet()) {
                context.removeProperty(key);
            }
        }
    }

    public String getFunctionalGroup() {
        return this.functionalGroup;
    }

    public void setFunctionalGroup(String functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public boolean isItemGenerator() {
        return this.itemGenerator;
    }

    public void setItemGenerator(boolean itemGenerator) {
        this.itemGenerator = itemGenerator;
    }

    public int getSequenceNr() {
        return this.sequenceNr;
    }

    public void setSequenceNr(int sequenceNr) {
        this.sequenceNr = sequenceNr;
    }

    public int getXmlLoaderSequenceNr() {
        return this.xmlLoaderSequenceNr;
    }

    public void setXmlLoaderSequenceNr(int xmlLoaderSequenceNr) {
        this.xmlLoaderSequenceNr = xmlLoaderSequenceNr;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Iterator getRequiredItemPropertys() {
        if (this.requiredItemPropertyList == null) {
            return EmptyIterator.getInstance();
        }
        return this.requiredItemPropertyList.iterator();
    }

    public void addRequiredItemProperty(String requiredItemProperty) {
        if (this.requiredItemPropertyList == null) {
            this.requiredItemPropertyList = new ArrayList();
        }
        this.requiredItemPropertyList.add(requiredItemProperty);
    }

    public void clearRequiredItemPropertys() {
        this.requiredItemPropertyList = null;
    }

    public List getRequiredItemPropertyList() {
        return this.requiredItemPropertyList;
    }

    public void setRequiredItemPropertyList(List requiredItemPropertyList) {
        this.requiredItemPropertyList = requiredItemPropertyList;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Iterator getCustomPages() {
        if (this.customPageList == null) {
            return EmptyIterator.getInstance();
        }
        return this.customPageList.iterator();
    }

    public void addCustomPage(GeneratorPageDescriptor customPage) {
        if (this.customPageList == null) {
            this.customPageList = new ArrayList();
        }
        this.customPageList.add(customPage);
    }

    public void clearCustomPages() {
        this.customPageList = null;
    }

    public List getCustomPageList() {
        return this.customPageList;
    }

    public void setCustomPageList(List customPageList) {
        this.customPageList = customPageList;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getDefaultStartPageName() {
        return this.defaultStartPageName;
    }

    public void setDefaultStartPageName(String defaultStartPageName) {
        this.defaultStartPageName = defaultStartPageName;
    }

    public boolean isShowOpenResultCheckBox() {
        return this.showOpenResultCheckBox;
    }

    public void setShowOpenResultCheckBox(boolean showOpenResultCheckBox) {
        this.showOpenResultCheckBox = showOpenResultCheckBox;
    }

    public String getGeneratorCustomizerClassName() {
        return this.generatorCustomizerClassName;
    }

    public void setGeneratorCustomizerClassName(String generatorCustomizerClassName) {
        this.generatorCustomizerClassName = generatorCustomizerClassName;
    }

    public GeneratorMgr getGeneratorMgr() {
        return this.generatorMgr;
    }

    public void setGeneratorMgr(GeneratorMgr generatorMgr) {
        this.generatorMgr = generatorMgr;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public XMLDriver getXmlDriver() {
        return this.xmlDriver;
    }

    public void setXmlDriver(XMLDriver xmlDriver) {
        this.xmlDriver = xmlDriver;
    }

    public int compareTo(Object o) {
        Generator generator = (Generator)o;
        return this.getSequenceNr() - generator.getSequenceNr();
    }
}

