/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator;

import java.util.HashMap;
import java.util.Map;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.common.template.TemplateEngineResult;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;

public class GeneratorContext {
    private static final int STATUS_NEW_ITEM = 1;
    private static final int STATUS_EMPTY_ITEM = 2;
    private static final int STATUS_ITEM_SAVED = 4;
    private static final int STATUS_NEED_GENERATION = 8;
    private static final int STATUS_INVALID_GENERATOR = 16;
    private static final int STATUS_CLASSNAME_SET = 32;
    private Item item;
    private Item originalItem;
    private int status;
    private Map properties = new HashMap();
    private String outputRootDir;
    private String overwriteMode;
    private Generator selectedGenerator;
    private GeneratorSettings generatorSettings;
    private TemplateEngineResult templateEngineResult;

    public void reset() {
        this.item = null;
        this.originalItem = null;
        this.status = 0;
        this.outputRootDir = null;
        this.overwriteMode = null;
        this.selectedGenerator = null;
        this.generatorSettings = null;
        this.templateEngineResult = null;
        this.properties.clear();
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
        if (item != null) {
            Model model = item.getOwningModel();
            if (model != null) {
                this.outputRootDir = model.getModelPath();
            }
        } else {
            this.outputRootDir = null;
        }
    }

    public Item getOriginalItem() {
        return this.originalItem;
    }

    public void setOriginalItem(Item originalItem) {
        this.originalItem = originalItem;
    }

    public boolean hasStatus(int statusFlag) {
        return (this.status & statusFlag) != 0;
    }

    public void setStatus(int statusFlag) {
        this.status |= statusFlag;
    }

    public void clearStatus(int statusFlag) {
        this.status &= ~statusFlag;
    }

    public String getOutputRootDir() {
        return this.outputRootDir;
    }

    public void setOutputRootDir(String outputRootDir) {
        this.outputRootDir = outputRootDir;
    }

    public String getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(String overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public Generator getSelectedGenerator() {
        return this.selectedGenerator;
    }

    public void setSelectedGenerator(Generator selectedGenerator) {
        if (this.selectedGenerator != null) {
            this.selectedGenerator.removeInitialPropertiesToContext(this);
        }
        this.selectedGenerator = selectedGenerator;
        if (selectedGenerator != null) {
            selectedGenerator.copyInitialPropertiesToContext(this);
        }
    }

    public GeneratorSettings getGeneratorSettings() {
        return this.generatorSettings;
    }

    public void setGeneratorSettings(GeneratorSettings generatorSettings) {
        this.generatorSettings = generatorSettings;
    }

    public TemplateEngineResult getTemplateEngineResult() {
        return this.templateEngineResult;
    }

    public void setTemplateEngineResult(TemplateEngineResult templateEngineResult) {
        this.templateEngineResult = templateEngineResult;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean isNewItem() {
        return (this.status & 1) != 0;
    }

    public void setNewItem(boolean newItem) {
        this.status = newItem ? (this.status |= 1) : (this.status &= 0xFFFFFFFE);
    }

    public boolean isEmptyItem() {
        return (this.status & 2) != 0;
    }

    public void setEmptyItem(boolean isEmpty) {
        this.status = isEmpty ? (this.status |= 2) : (this.status &= 0xFFFFFFFD);
    }

    public boolean isItemSaved() {
        return (this.status & 4) != 0;
    }

    public void setItemSaved(boolean itemSaved) {
        this.status = itemSaved ? (this.status |= 4) : (this.status &= 0xFFFFFFFB);
    }

    public boolean isNeedGeneration() {
        return (this.status & 8) != 0;
    }

    public void setNeedGeneration(boolean needGeneration) {
        this.status = needGeneration ? (this.status |= 8) : (this.status &= 0xFFFFFFF7);
    }

    public boolean isInvalidGenerator() {
        return (this.status & 0x10) != 0;
    }

    public void setInvalidGenerator(boolean invalidGenerator) {
        this.status = invalidGenerator ? (this.status |= 0x10) : (this.status &= 0xFFFFFFEF);
    }

    public boolean isClassnameSet() {
        return (this.status & 0x20) != 0;
    }

    public void setClassnameSet(boolean classnameSet) {
        this.status = classnameSet ? (this.status |= 0x20) : (this.status &= 0xFFFFFFDF);
    }
}

