/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.generic.ProcessEntry;
import org.openbp.cockpit.generator.generic.ProcessEntrySettings;
import org.openbp.common.generic.msgcontainer.MsgContainer;
import org.openbp.common.util.CopyUtil;
import org.openbp.common.util.iterator.EmptyIterator;

public class ProcessEntrySettingsImpl
extends GeneratorSettings
implements ProcessEntrySettings {
    private List entryList;

    @Override
    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        ProcessEntrySettingsImpl src = (ProcessEntrySettingsImpl)source;
        this.entryList = copyMode == 1 || copyMode == 2 ? (List)CopyUtil.copyCollection((Collection)src.entryList, (int)(copyMode == 2 ? 2 : 0)) : src.entryList;
    }

    public Iterator getEntries() {
        if (this.entryList == null) {
            return EmptyIterator.getInstance();
        }
        return this.entryList.iterator();
    }

    public void addEntry(ProcessEntry entry) {
        if (this.entryList == null) {
            this.entryList = new ArrayList();
        }
        this.entryList.add(entry);
    }

    public void clearEntries() {
        this.entryList = null;
    }

    @Override
    public List getEntryList() {
        return this.entryList;
    }

    @Override
    public void setEntryList(List entryList) {
        this.entryList = entryList;
    }

    @Override
    public void beforeSerialization() {
        super.beforeSerialization();
        Iterator it = this.getEntries();
        while (it.hasNext()) {
            ProcessEntry entry = (ProcessEntry)((Object)it.next());
            entry.beforeSerialization(this.getModel());
        }
    }

    @Override
    public void afterDeserialization(MsgContainer msgs) {
        super.afterDeserialization(msgs);
        Iterator it = this.getEntries();
        while (it.hasNext()) {
            ProcessEntry entry = (ProcessEntry)((Object)it.next());
            entry.afterDeserialization(msgs, this.getModel());
        }
    }
}

