/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.process;

import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorCustomizer;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.itemeditor.ItemCreationUtil;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.jaspira.gui.wizard.JaspiraWizardObjectPage;
import org.openbp.swing.components.wizard.WizardEvent;

public class ProcessCustomizer
extends GeneratorCustomizer {
    public static final String PROCESS_TYPE = "ProcessType";
    public static final String SKIN_NAME = "SkinName";

    @Override
    public Class getSettingsClass() {
        return GeneratorSettings.class;
    }

    @Override
    public boolean hasResultPage(GeneratorContext context) {
        return false;
    }

    @Override
    public void processWizardEvent(GeneratorContext context, WizardEvent event) {
        String pageName = event.wizard.getManager().getCurrent();
        if (pageName.equals("selection")) {
            if (event.eventType == 3 || event.eventType == 2) {
                this.initializeProcess(context);
            }
        } else if (pageName.equals("property")) {
            if (event.eventType == 0) {
                if (!"selection".equals(event.wizard.getManager().getFirst())) {
                    this.initializeProcess(context);
                    JaspiraWizardObjectPage page = (JaspiraWizardObjectPage)((Object)event.wizard.getPage(pageName));
                    page.handleWizardEvent(event);
                }
                if (context.getOriginalItem() == null) {
                    try {
                        context.setOriginalItem((Item)context.getItem().clone());
                    }
                    catch (CloneNotSupportedException e) {}
                }
            } else if (event.eventType == 4) {
                try {
                    context.setItem((Item)context.getOriginalItem().clone());
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
            }
        }
        super.processWizardEvent(context, event);
    }

    private void initializeProcess(GeneratorContext context) {
        ProcessItem process = (ProcessItem)context.getItem();
        String processType = (String)context.getProperty(PROCESS_TYPE);
        process.setProcessType(processType);
        String skinName = (String)context.getProperty(SKIN_NAME);
        if (skinName != null) {
            process.setSkinName(skinName);
        }
        if (context.isEmptyItem() && context.isNewItem()) {
            this.updateItemName(context);
            this.updateItemStructure(context);
        }
    }

    public void updateItemName(GeneratorContext context) {
        String processType;
        ProcessItem process = (ProcessItem)context.getItem();
        if (process.getName() != null) {
            ModelQualifier itemQualifier = process.getQualifier();
            if (ModelConnector.getInstance().getItemByQualifier(itemQualifier, false) == null) {
                return;
            }
        }
        if ((processType = process.getProcessType()) != null) {
            String name = processType;
            String nameSuffix = this.determineUniqueSuffix((Item)process, name);
            if (nameSuffix != null) {
                name = name + nameSuffix;
            }
            process.setName(name);
        }
    }

    public void updateItemStructure(GeneratorContext context) {
        ProcessItem process = (ProcessItem)context.getItem();
        if (!process.getNodes().hasNext()) {
            Skin processSkin = FigureUtil.determineProcessSkin(process);
            processSkin.initalizeNewProcess(process);
            ItemCreationUtil.setupStandardConfiguration((Item)process);
            FigureUtil.updateItemGeometry(null, (Item)process);
        }
    }
}

