/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.wizard;

import java.awt.Component;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.List;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorCustomizer;
import org.openbp.cockpit.generator.GeneratorException;
import org.openbp.cockpit.generator.GeneratorPageDescriptor;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.WizardObjectPage;
import org.openbp.cockpit.generator.wizard.WizardResultPage;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.string.StringBufferOutputStream;
import org.openbp.common.string.StringUtil;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.PlaceholderItem;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.swing.components.JMsgBox;
import org.openbp.swing.components.wizard.SequenceManager;
import org.openbp.swing.components.wizard.SequenceManagerImpl;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.components.wizard.WizardImpl;
import org.openbp.swing.components.wizard.WizardPage;

public class GeneratorWizard
extends WizardImpl {
    public static final String SELECTION_PAGE = "selection";
    public static final String SETTINGS_PAGE = "settings";
    public static final String RESULT_PAGE = "result";
    protected GeneratorContext context;
    private SequenceManagerImpl originalSequence;

    public GeneratorWizard(ResourceCollection resource) {
        super(resource);
    }

    public GeneratorWizard(ResourceCollection resource, Item item) {
        this(resource);
        this.context = new GeneratorContext();
        this.context.setItem(item);
    }

    public void clearPages() {
        super.clearPages();
        this.originalSequence = null;
    }

    protected boolean fireWizardEvent(WizardEvent event) {
        GeneratorCustomizer customizer;
        Generator selectedGenerator = this.context.getSelectedGenerator();
        if (!super.fireWizardEvent(event)) {
            return false;
        }
        if (selectedGenerator != null && (customizer = selectedGenerator.getCustomizer()) != null) {
            customizer.processWizardEvent(this.context, event);
            if (event.cancel) {
                return false;
            }
        }
        if (event.eventType == 2) {
            boolean save = false;
            if (selectedGenerator == null) {
                save = true;
            } else {
                if (selectedGenerator.isItemGenerator()) {
                    save = true;
                }
                selectedGenerator.saveSettings(this.context);
            }
            if (save) {
                Item item = this.context.getItem();
                String info = null;
                GeneratorSettings settings = this.context.getGeneratorSettings();
                if (settings != null && selectedGenerator != null) {
                    settings.beforeSerialization();
                    StringBuffer sb = new StringBuffer();
                    StringBufferOutputStream os = new StringBufferOutputStream(sb);
                    try {
                        selectedGenerator.getXmlDriver().serialize((Object)settings, (OutputStream)os);
                    }
                    catch (XMLDriverException e) {
                        ExceptionUtil.printTrace((Throwable)e);
                    }
                    info = sb.toString().trim();
                    if (info.equals("")) {
                        info = null;
                    } else {
                        info = StringUtil.substitute((String)info, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (String)"");
                        info = StringUtil.substitute((String)info, (String)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>", (String)"");
                    }
                }
                item.setGeneratorInfo(info);
                if (!(item instanceof PlaceholderItem)) {
                    boolean add;
                    boolean bl = add = this.context.isNewItem() && !this.context.isItemSaved();
                    if (!ModelConnector.getInstance().saveItem(item, add)) {
                        event.cancel = true;
                        return false;
                    }
                }
                this.context.setItemSaved(true);
                this.context.setEmptyItem(false);
                Object original = item instanceof Model ? ModelConnector.getInstance().getModelByQualifier(item.getQualifier()) : ModelConnector.getInstance().getItemByQualifier(item.getQualifier(), false);
                this.context.setOriginalItem((Item)original);
                this.removePage(SELECTION_PAGE);
            }
            if (selectedGenerator != null) {
                boolean hasResultPage = true;
                GeneratorCustomizer customizer2 = selectedGenerator.getCustomizer();
                if (customizer2 != null) {
                    hasResultPage = customizer2.hasResultPage(this.context);
                }
                if (hasResultPage) {
                    if (this.getPage(RESULT_PAGE) == null) {
                        WizardResultPage resultPage = new WizardResultPage(this);
                        this.addPage(RESULT_PAGE, (Component)((Object)resultPage));
                    }
                    this.setResultPageName(RESULT_PAGE);
                }
            }
        }
        if (event.eventType == 1) {
            this.context.setItem(null);
        }
        return true;
    }

    public void updateGeneratorPageSequence() {
        Generator generator = this.context.getSelectedGenerator();
        SequenceManagerImpl manager = (SequenceManagerImpl)this.getManager();
        if (this.originalSequence == null) {
            try {
                this.originalSequence = (SequenceManagerImpl)manager.clone();
            }
            catch (CloneNotSupportedException e) {}
        } else {
            try {
                String current = manager.getCurrent();
                manager = (SequenceManagerImpl)this.originalSequence.clone();
                this.setManager((SequenceManager)manager);
                manager.setCurrent(current);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        if (generator != null) {
            this.context.setInvalidGenerator(false);
            try {
                List customPages;
                generator.checkRequirements(this.context);
                generator.createSettings(this.context);
                generator.loadSettings(this.context);
                GeneratorCustomizer customizer = generator.getCustomizer();
                if (customizer != null) {
                    customizer.beforePageSequenceUpdate(this.context, this);
                }
                if ((customPages = generator.getCustomPageList()) != null) {
                    String next;
                    String currentPageName;
                    if (this.getPage(SELECTION_PAGE) != null) {
                        currentPageName = SELECTION_PAGE;
                        next = manager.getNext(currentPageName);
                    } else {
                        currentPageName = null;
                        next = manager.getFirst();
                    }
                    int n = customPages.size();
                    for (int i = 0; i < n; ++i) {
                        GeneratorPageDescriptor pd = (GeneratorPageDescriptor)((Object)customPages.get(i));
                        String pageName = pd.getName();
                        WizardPage page = (WizardPage)this.getPage(pageName);
                        if (page == null) {
                            String pageClassName = pd.getPageClassName();
                            String objectClassName = pd.getObjectClassName();
                            if (objectClassName != null) {
                                Object o = this.context.getProperty(pageName);
                                if (o == null) {
                                    o = ReflectUtil.instantiate((String)objectClassName, null, (String)"generator settings object class");
                                    this.context.setProperty(pageName, o);
                                }
                                page = new WizardObjectPage((Wizard)this, pd);
                            } else if (pageClassName != null) {
                                try {
                                    Class<?> pageClass = Class.forName(pageClassName);
                                    Constructor<?>[] ctrs = pageClass.getDeclaredConstructors();
                                    for (int ic = 0; ic < ctrs.length; ++ic) {
                                        Class<?>[] params = ctrs[ic].getParameterTypes();
                                        if (params.length != 1 || params[0] != GeneratorWizard.class) continue;
                                        page = (WizardPage)ctrs[ic].newInstance(new Object[]{this});
                                        break;
                                    }
                                    if (page == null) {
                                        throw new GeneratorException("Class '" + pageClassName + "' does not have a (GeneratorWizard) constructor.");
                                    }
                                }
                                catch (Exception e) {
                                    String msg = LogUtil.error(((Object)((Object)this)).getClass(), (String)"Cannot instantiate page class $0.", (Object)pageClassName, (Object)e);
                                    String exMsg = ExceptionUtil.getNestedMessage((Throwable)e);
                                    throw new GeneratorException(exMsg != null ? exMsg : msg);
                                }
                            }
                            if (page != null) {
                                String pageDescription = pd.getDescription();
                                page.setDescription(pageDescription);
                                this.addPage(pageName, (Component)page);
                            }
                        }
                        if (page != null) {
                            String pageTitle = pd.getDisplayName();
                            if (pageTitle == null) {
                                pageTitle = generator.getDisplayName();
                            }
                            page.setTitle(pageTitle);
                            if (pd.isFinish()) {
                                page.canFinish = true;
                            }
                        }
                        manager.chain(currentPageName, pageName);
                        currentPageName = pageName;
                    }
                    if (next != null) {
                        manager.chain(currentPageName, next);
                    }
                }
                if (customizer != null) {
                    customizer.afterPageSequenceUpdate(this.context, this);
                }
            }
            catch (GeneratorException e) {
                this.context.setInvalidGenerator(true);
                JMsgBox.show((Component)((Object)this), (String)e.getMessage(), (int)262144);
            }
        }
        this.updateNavigator();
    }

    public GeneratorContext getContext() {
        return this.context;
    }
}

