/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.itemeditor;

import org.openbp.cockpit.modeler.skins.SkinMgr;
import org.openbp.common.generic.taggedvalue.TaggedValue;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.ItemTypeDescriptor;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.activity.ActivitySocket;
import org.openbp.core.model.item.activity.ActivitySocketImpl;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessUtil;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.ItemEditor;
import org.openbp.guiclient.model.item.ItemEditorRegistry;
import org.openbp.jaspira.option.OptionMgr;

public class ItemCreationUtil {
    private ItemCreationUtil() {
    }

    public static Item createItem(Model model, String suggestedName, String suggestedDisplayName, String itemType, String processType) {
        ItemTypeDescriptor itd = ModelConnector.getInstance().getItemTypeDescriptor(itemType);
        return ItemCreationUtil.createItem(model, suggestedName, suggestedDisplayName, itd, processType);
    }

    public static Item createItem(Model model, String suggestedName, String suggestedDisplayName, ItemTypeDescriptor itd, String processType) {
        Item item = itd.getItemFactory().createItem(model, suggestedName, suggestedDisplayName);
        if (item instanceof Model) {
            ItemCreationUtil.initializeModelDirectorySetup((Model)item);
        } else if (item instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)item;
            SkinMgr.getInstance().getDefaultSkin().initalizeNewProcess(process);
            process.setProcessType(processType);
        }
        ItemCreationUtil.setupStandardConfiguration(item);
        ItemEditor editor = ItemEditorRegistry.getInstance().lookupItemEditor(itd.getItemType());
        if (editor != null) {
            item = editor.openItem(item, 1);
        } else if (!ModelConnector.getInstance().saveItem(item, true)) {
            item = null;
        }
        return item;
    }

    public static void setupStandardConfiguration(Item item) {
        if (item instanceof ProcessItem) {
            ItemCreationUtil.setupProcessStandardConfiguration((ProcessItem)item);
        } else if (item instanceof ActivityItem) {
            ItemCreationUtil.setupActionStandardConfiguration((ActivityItem)item);
        }
    }

    private static void setupProcessStandardConfiguration(ProcessItem process) {
        ProcessUtil.setupProcessStandardConfiguration((ProcessItem)process);
    }

    private static void setupActionStandardConfiguration(ActivityItem item) {
        ActivitySocketImpl socket = new ActivitySocketImpl();
        socket.setName("In");
        socket.setEntrySocket(true);
        socket.setDefaultSocket(true);
        item.addSocket((ActivitySocket)socket);
        socket = new ActivitySocketImpl();
        socket.setName("Out");
        socket.setEntrySocket(false);
        socket.setDefaultSocket(true);
        item.addSocket((ActivitySocket)socket);
    }

    private static void initializeModelDirectorySetup(Model model) {
        String mode = OptionMgr.getInstance().getStringOption("itembrowser.newmodelgeneratordefaultdirectories", null);
        if (mode != null) {
            String extLibDir;
            String libDir;
            String classesDir;
            String srcDir;
            boolean test;
            String docDir = "${MODEL_DIR}/doc";
            boolean local = mode.indexOf("local") >= 0;
            boolean bl = test = mode.indexOf("test") >= 0;
            if (mode.startsWith("maven")) {
                String scopeDir = test ? "/test" : "/main";
                String locDir = local ? "" : "/../../../../..";
                srcDir = "${MODEL_DIR}" + locDir + "/src" + scopeDir + "/java";
                classesDir = "${MODEL_DIR}" + locDir + "/target" + (test ? "/test-classes" : "/classes");
                libDir = "${MODEL_DIR}" + locDir + "/target";
                extLibDir = "${MODEL_DIR}" + locDir + "/lib";
            } else {
                String locDir = local ? "" : "/../../../../..";
                srcDir = "${MODEL_DIR}" + locDir + "/src";
                classesDir = "${MODEL_DIR}" + locDir + "/classes";
                libDir = "${MODEL_DIR}" + locDir + "/lib";
                extLibDir = "${MODEL_DIR}" + locDir + "/extLib";
            }
            ItemCreationUtil.initializeTaggedValueDefault(model, "src", srcDir);
            ItemCreationUtil.initializeTaggedValueDefault(model, "classes", classesDir);
            ItemCreationUtil.initializeTaggedValueDefault(model, "lib", libDir);
            ItemCreationUtil.initializeTaggedValueDefault(model, "extlib", extLibDir);
            ItemCreationUtil.initializeTaggedValueDefault(model, "doc", docDir);
        }
    }

    private static void initializeTaggedValueDefault(Model model, String identifier, String value) {
        model.addTaggedValue(new TaggedValue(identifier, value));
    }
}

